/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures.activities;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.stp.bpmn.figures.activities.ActivityFigure;

public class ActivityPainter {
    public static void paint(Graphics graphics, ActivityFigure fig) {
        PrecisionRectangle innerRect = null;
        switch (fig.getActivityType()) {
            case 2: 
            case 3: 
            case 4: {
                innerRect = ActivityPainter.paintEventStart(graphics, fig);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                innerRect = ActivityPainter.paintEventIntermediate(graphics, fig);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                innerRect = ActivityPainter.paintEventEnd(graphics, fig);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                innerRect = ActivityPainter.paintGateway(graphics, fig);
            }
        }
        switch (fig.getActivityType()) {
            case 2: {
                break;
            }
            case 3: {
                ActivityPainter.paintMessage(graphics, fig, innerRect);
                break;
            }
            case 4: {
                ActivityPainter.paintRule(graphics, fig);
                break;
            }
            case 9: {
                ActivityPainter.paintCompensation(graphics, fig);
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                ActivityPainter.paintError(graphics, fig);
                break;
            }
            case 6: {
                ActivityPainter.paintMessage(graphics, fig, innerRect);
                break;
            }
            case 10: {
                ActivityPainter.paintRule(graphics, fig);
                break;
            }
            case 7: {
                ActivityPainter.paintTimer(graphics, fig, innerRect);
                break;
            }
            case 14: {
                ActivityPainter.paintCompensation(graphics, fig);
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                ActivityPainter.paintError(graphics, fig);
                break;
            }
            case 12: {
                ActivityPainter.paintMessage(graphics, fig, innerRect);
                break;
            }
            case 15: {
                ActivityPainter.paintTerminate(graphics, fig, innerRect);
                break;
            }
            case 16: {
                ActivityPainter.paintX(graphics, fig, innerRect);
                break;
            }
            case 18: {
                ActivityPainter.paintBoldOval(graphics, fig, innerRect);
                break;
            }
            case 17: {
                ActivityPainter.paintStar(graphics, fig, innerRect);
                break;
            }
            case 19: {
                ActivityPainter.paintPlus(graphics, fig, innerRect);
            }
        }
        if (fig.isLooping()) {
            ActivityPainter.paintLoopInsideFigure(graphics, fig.getBounds(), (IFigure)fig);
        }
    }

    public static PrecisionRectangle paintGateway(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        int lineWidth = MapModeUtil.getMapMode((IFigure)fig).LPtoDP(2);
        graphics.setLineWidth(lineWidth);
        PrecisionRectangle r = ActivityPainter.calcInnerRectangle(fig.getBounds().getCopy(), lineWidth);
        PointList pointList = new PointList();
        pointList.addPoint(r.x + r.width / 2, r.y);
        pointList.addPoint(r.x + r.width, r.y + r.height / 2);
        pointList.addPoint(r.x + r.width / 2, r.y + r.height);
        pointList.addPoint(r.x, r.y + r.height / 2);
        graphics.fillPolygon(pointList);
        graphics.drawPolygon(pointList);
        graphics.popState();
        return r;
    }

    public static PrecisionRectangle paintEventStart(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.black);
        Rectangle rect = fig.getBounds().getCopy();
        graphics.fillOval(rect);
        graphics.setLineWidth(MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1));
        PrecisionRectangle outerCircle = ActivityPainter.calcInnerRectangle(rect, graphics.getLineWidth());
        PrecisionRectangle precRect = outerCircle.getPreciseCopy();
        ActivityPainter.shrink(precRect, outerCircle.preciseWidth / 12.0, outerCircle.preciseHeight / 12.0);
        outerCircle = precRect.getPreciseCopy();
        ActivityPainter.shrink(outerCircle, -outerCircle.preciseWidth / 12.0, -outerCircle.preciseHeight / 12.0);
        graphics.drawOval((Rectangle)outerCircle);
        graphics.popState();
        return precRect;
    }

    private static PrecisionRectangle calcInnerRectangle(Rectangle rect, int lineWidth) {
        PrecisionRectangle newRect = new PrecisionRectangle(rect);
        double halfLineWidth = (double)lineWidth / 2.0;
        newRect.setX(newRect.preciseX + halfLineWidth);
        newRect.setY(newRect.preciseY + halfLineWidth);
        newRect.setWidth(newRect.preciseWidth - (double)lineWidth);
        newRect.setHeight(newRect.preciseHeight - (double)lineWidth);
        return newRect;
    }

    public static PrecisionRectangle paintEventIntermediate(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.black);
        Rectangle rect = fig.getBounds().getCopy();
        graphics.fillOval(rect);
        graphics.setLineWidth(1);
        PrecisionRectangle outerCircle = ActivityPainter.calcInnerRectangle(rect, graphics.getLineWidth());
        PrecisionRectangle precRect = outerCircle.getPreciseCopy();
        double ddW = outerCircle.preciseWidth / 10.0;
        double ddH = outerCircle.preciseHeight / 10.0;
        ActivityPainter.shrink(precRect, ddW, ddH);
        outerCircle = precRect.getPreciseCopy();
        ActivityPainter.shrink(outerCircle, -ddW, -ddH);
        graphics.drawOval((Rectangle)precRect);
        graphics.drawOval((Rectangle)outerCircle);
        graphics.popState();
        return precRect;
    }

    public static PrecisionRectangle paintEventIntermediateOld(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.black);
        Rectangle rect = fig.getBounds().getCopy();
        graphics.fillOval(rect);
        graphics.setLineWidth(MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1));
        PrecisionRectangle outerCircle = ActivityPainter.calcInnerRectangle(rect, graphics.getLineWidth());
        PrecisionRectangle precRect = outerCircle.getPreciseCopy();
        ActivityPainter.shrink(precRect, outerCircle.preciseWidth / 12.0, outerCircle.preciseHeight / 12.0);
        outerCircle = precRect.getPreciseCopy();
        ActivityPainter.shrink(outerCircle, -outerCircle.preciseWidth / 12.0, -outerCircle.preciseHeight / 12.0);
        graphics.drawOval((Rectangle)precRect);
        graphics.drawOval((Rectangle)outerCircle);
        graphics.popState();
        return precRect;
    }

    public static PrecisionRectangle paintEventEnd(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        graphics.setBackgroundColor(ColorConstants.white);
        int inn = 2;
        double lineWidth = (double)fig.getBounds().width * graphics.getAbsoluteScale() / 10.0;
        graphics.setLineWidth((int)Math.floor(lineWidth));
        PrecisionRectangle outerCircle = new PrecisionRectangle(fig.getBounds());
        ActivityPainter.shrink(outerCircle, inn, inn);
        graphics.fillOval((Rectangle)outerCircle);
        graphics.drawOval((Rectangle)outerCircle);
        graphics.popState();
        ActivityPainter.shrink(outerCircle, outerCircle.preciseWidth / 10.0, outerCircle.preciseHeight / 10.0);
        return outerCircle;
    }

    public static PrecisionRectangle paintEventEndOld(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.black);
        Rectangle rect = fig.getBounds().getCopy();
        PrecisionRectangle outerCircle = ActivityPainter.calcInnerRectangle(rect, graphics.getLineWidth());
        PrecisionRectangle precRect = outerCircle.getPreciseCopy();
        ActivityPainter.shrink(precRect, outerCircle.preciseWidth / 10.0, outerCircle.preciseHeight / 10.0);
        outerCircle = precRect.getPreciseCopy();
        ActivityPainter.shrink(outerCircle, -outerCircle.preciseWidth / 10.0, -outerCircle.preciseHeight / 10.0);
        graphics.setBackgroundColor(ColorConstants.darkGray);
        graphics.fillOval((Rectangle)outerCircle);
        graphics.setBackgroundColor(ColorConstants.white);
        graphics.fillOval((Rectangle)precRect);
        graphics.popState();
        return precRect;
    }

    public static void paintTerminate(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.darkGray);
        ActivityPainter.shrink(innerRect, innerRect.preciseWidth / 5.0, innerRect.preciseHeight / 5.0);
        ++innerRect.x;
        ++innerRect.y;
        graphics.fillOval((Rectangle)innerRect);
        graphics.popState();
    }

    public static void paintMessage(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        int lineWidth = MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1);
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setLineWidth(lineWidth);
        ActivityPainter.shrink(innerRect, innerRect.preciseWidth / 6.0, innerRect.preciseHeight / 4.5);
        graphics.drawRectangle((Rectangle)innerRect);
        graphics.drawPolyline(new int[]{innerRect.getTopLeft().x, innerRect.getTopLeft().y, innerRect.getCenter().x, innerRect.getCenter().y, innerRect.getTopRight().x, innerRect.getTopRight().y});
        graphics.popState();
    }

    public static void paintCompensation(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        Rectangle rect = fig.getBounds().getCopy();
        graphics.setBackgroundColor(ColorConstants.darkGray);
        graphics.setForegroundColor(ColorConstants.darkGray);
        rect.shrink(rect.width / 4, rect.height * 12 / 44);
        rect.translate(-rect.width / 16, 0);
        PointList pl = new PointList(3);
        pl.addPoint(rect.getLeft());
        pl.addPoint(rect.getTop());
        pl.addPoint(rect.getBottom());
        graphics.fillPolygon(pl);
        pl = new PointList(3);
        pl.addPoint(rect.getCenter());
        pl.addPoint(rect.getTopRight());
        pl.addPoint(rect.getBottomRight());
        graphics.fillPolygon(pl);
        graphics.popState();
    }

    public static void paintTimer(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        int lineWidth = MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1);
        PrecisionRectangle rect = innerRect;
        ActivityPainter.shrink(rect, (double)lineWidth / 2.0, (double)lineWidth / 2.0);
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setLineWidth(lineWidth);
        ActivityPainter.shrink(rect, rect.preciseWidth / 6.0, rect.preciseHeight / 6.0);
        graphics.drawOval((Rectangle)rect);
        ActivityPainter.shrink(rect, (double)lineWidth / 2.0, (double)lineWidth / 2.0);
        double a = rect.preciseWidth / 2.0;
        double b = rect.preciseHeight / 2.0;
        double x0 = rect.preciseX + a;
        double y0 = rect.preciseY + b;
        int i = 0;
        while (i < 12) {
            int angleGrad = i * 30;
            double x = a * Math.cos(Math.toRadians(angleGrad));
            double y = b * Math.sin(Math.toRadians(angleGrad));
            PrecisionPoint pp1 = new PrecisionPoint(x0 + x * 0.8, y0 + y * 0.8);
            PrecisionPoint pp2 = new PrecisionPoint(x0 + x, y0 + y);
            graphics.drawLine((Point)pp1, (Point)pp2);
            ++i;
        }
        PrecisionPoint center = new PrecisionPoint(x0, y0);
        PrecisionPoint bigHand = new PrecisionPoint(rect.preciseX, rect.preciseY);
        bigHand.preciseX += 11.0 * rect.preciseWidth / 18.0;
        bigHand.preciseY += 3.0 * rect.preciseHeight / 24.0;
        bigHand.updateInts();
        graphics.drawLine((Point)center, (Point)bigHand);
        PrecisionPoint littleHand = new PrecisionPoint(x0, y0);
        littleHand.preciseX += 3.0 * rect.preciseWidth / 10.0;
        littleHand.preciseY -= 1.0 * rect.preciseHeight / 24.0;
        littleHand.updateInts();
        graphics.drawLine((Point)center, (Point)littleHand);
        graphics.popState();
    }

    private static final void shrink(PrecisionRectangle rect, double w, double h) {
        rect.setX(rect.preciseX + w);
        rect.setY(rect.preciseY + h);
        rect.setWidth(rect.preciseWidth - 2.0 * w);
        rect.setHeight(rect.preciseHeight - 2.0 * h);
        rect.updateInts();
    }

    public static void paintError(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        Rectangle rect = fig.getBounds().getCopy();
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setLineWidth((int)Math.floor(2 * Math.max(rect.width, rect.height) / 22));
        rect.shrink(rect.width / 4, rect.height / 4);
        Point one = rect.getTopLeft().translate(1 * rect.width / 3, 1 * rect.height / 3);
        Point onebis = one.getCopy().translate(1 * rect.width / 10, 1 * rect.height / 10);
        Point two = rect.getTopLeft().translate(2 * rect.width / 3, 2 * rect.height / 3);
        Point twobis = two.getCopy().translate(-1 * rect.width / 10, -1 * rect.height / 10);
        graphics.drawLine(one, two);
        PointList pl = new PointList(4);
        pl.addPoint(rect.getBottomLeft());
        pl.addPoint(one);
        pl.addPoint(onebis);
        graphics.fillPolygon(pl);
        pl = new PointList(4);
        pl.addPoint(rect.getTopRight());
        pl.addPoint(two);
        pl.addPoint(twobis);
        graphics.fillPolygon(pl);
        graphics.popState();
    }

    public static void paintRule(Graphics graphics, ActivityFigure fig) {
        graphics.pushState();
        Rectangle rect = fig.getBounds().getCopy();
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setLineWidth((int)Math.floor(2 * Math.max(rect.width, rect.height) / 22));
        graphics.drawRectangle(rect.shrink(graphics.getLineWidth() / 2 + rect.width * 12 / 44, graphics.getLineWidth() / 2 + rect.height / 4));
        graphics.setLineWidth((int)Math.floor(Math.max(rect.width, rect.height) / 22));
        rect.shrink(graphics.getLineWidth(), graphics.getLineWidth() * 4);
        int i = 0;
        while (i < 5) {
            graphics.drawLine(rect.getTopLeft().translate(0, i * rect.width / 5), rect.getTopRight().translate(0, i * rect.width / 5));
            ++i;
        }
        graphics.popState();
    }

    public static void paintStar(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        Rectangle rect = fig.getBounds().getCopy();
        graphics.setBackgroundColor(ColorConstants.darkGray);
        graphics.setForegroundColor(ColorConstants.darkGray);
        if (fig.getActivityType() == 17) {
            int lineWidth = 1;
            MapModeUtil.getMapMode((IFigure)fig).LPtoDP(1);
            PrecisionRectangle inner = new PrecisionRectangle((Rectangle)innerRect);
            inner.preciseWidth = 1.414 * (double)rect.width / 2.0;
            inner.preciseHeight = 1.414 * (double)rect.height / 2.0;
            inner.preciseX = (double)rect.x + (double)rect.width * 0.5857864399999999 / 4.0;
            inner.preciseY = (double)rect.y + (double)rect.height * 0.5857864399999999 / 4.0;
            inner.updateInts();
            inner = ActivityPainter.calcInnerRectangle((Rectangle)inner, lineWidth);
            PrecisionRectangle precRect = inner.getPreciseCopy();
            ActivityPainter.shrink(precRect, 2.0 * inner.preciseWidth / 12.0, 2.0 * inner.preciseHeight / 12.0);
            inner = precRect.getPreciseCopy();
            ActivityPainter.shrink(inner, -3.0 * inner.preciseWidth / 24.0, -3.0 * inner.preciseHeight / 24.0);
            graphics.drawOval((Rectangle)precRect);
            graphics.drawOval((Rectangle)inner);
            precRect = ActivityPainter.calcInnerRectangle((Rectangle)precRect, lineWidth);
            ActivityPainter.shrink(precRect, precRect.preciseWidth / 6.0, precRect.preciseHeight / 5.0);
            rect = precRect.getCopy();
        } else {
            rect.shrink(rect.width / 5, rect.height / 4);
        }
        rect.translate(0, -1 * rect.height / 5);
        PointList pl = new PointList(3);
        pl.addPoint(rect.getTop());
        pl.addPoint(rect.getBottomLeft());
        pl.addPoint(rect.getBottomRight());
        graphics.fillPolygon(pl);
        rect.translate(0, 2 * rect.height / 5);
        pl = new PointList(3);
        pl.addPoint(rect.getBottom());
        pl.addPoint(rect.getTopRight());
        pl.addPoint(rect.getTopLeft());
        graphics.fillPolygon(pl);
        graphics.popState();
    }

    static PointList getStarPolygon(double radius, double rotation) {
        PointList pointList = new PointList(10);
        double radius2 = radius * Math.sin(0.3141592653589793) / Math.cos(0.6283185307179586);
        int i = 0;
        while (i < 5) {
            double xAngle = Math.PI * 2 * (double)i / 5.0 + rotation - 1.5707963267948966;
            float x1 = (float)(radius * Math.cos(xAngle));
            float y1 = (float)(radius * Math.sin(xAngle));
            Point point1 = new Point(Math.round(x1), Math.round(y1));
            pointList.addPoint(point1);
            double xAngle2 = xAngle + 0.6283185307179586;
            float x2 = (float)(radius2 * Math.cos(xAngle2));
            float y2 = (float)(radius2 * Math.sin(xAngle2));
            Point point2 = new Point(Math.round(x2), Math.round(y2));
            pointList.addPoint(point2);
            ++i;
        }
        return pointList;
    }

    public static void paintX(Graphics graphics, ActivityFigure fig, PrecisionRectangle rect) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        double lineWidth = rect.preciseWidth * graphics.getAbsoluteScale() / 6.0;
        ActivityPainter.shrink(rect, 3.0 * rect.preciseWidth / 8.0, 3.0 * rect.preciseHeight / 8.0);
        graphics.setLineCap(3);
        graphics.setLineWidth((int)Math.floor(lineWidth * 0.95));
        graphics.drawLine(rect.getTopLeft(), rect.getBottomRight());
        graphics.drawLine(rect.getTopRight(), rect.getBottomLeft());
        graphics.popState();
    }

    public static void paintPlus(Graphics graphics, ActivityFigure fig, PrecisionRectangle rect) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.darkGray);
        double lineWidth = rect.preciseWidth * graphics.getAbsoluteScale() / 6.0;
        ActivityPainter.shrink(rect, 5.0 * rect.preciseWidth / 16.0, 5.0 * rect.preciseHeight / 16.0);
        graphics.setLineCap(3);
        graphics.setLineWidth((int)Math.floor(lineWidth));
        graphics.drawLine(rect.getTop(), rect.getBottom());
        graphics.drawLine(rect.getLeft(), rect.getRight());
        graphics.popState();
    }

    public static void paintBoldOval(Graphics graphics, ActivityFigure fig, PrecisionRectangle innerRect) {
        graphics.pushState();
        PrecisionRectangle rect = innerRect;
        graphics.setForegroundColor(ColorConstants.darkGray);
        int orih = rect.height;
        int oriw = rect.width;
        Rectangle rr = rect.getCopy().shrink(11 * oriw / 44, 11 * orih / 44);
        graphics.setLineWidth((int)Math.round(graphics.getAbsoluteScale() * (double)rr.width / 8.0));
        graphics.drawOval(rr);
        graphics.popState();
    }

    public static PrecisionRectangle getLoopMarkerBounds(Rectangle figureRect) {
        double loopHeight = (double)figureRect.height / 5.0;
        double loopWidth = Math.min(loopHeight, (double)figureRect.width);
        double loopX = (double)figureRect.x + ((double)figureRect.width - loopWidth) / 2.0;
        double loopY = (double)(figureRect.y + figureRect.height) - loopHeight;
        PrecisionRectangle bounds = new PrecisionRectangle();
        bounds.setX(loopX);
        bounds.setY(loopY);
        bounds.setWidth(loopWidth);
        bounds.setHeight(loopHeight);
        return bounds;
    }

    public static void paintLoopInsideFigure(Graphics graphics, Rectangle figureRect, IFigure fig) {
        PrecisionRectangle loopRect = ActivityPainter.getLoopMarkerBounds(figureRect);
        ActivityPainter.paintLoop(graphics, loopRect, fig);
    }

    public static void paintLoop(Graphics graphics, PrecisionRectangle loopRect, IFigure fig) {
        graphics.pushState();
        graphics.setLineWidth(MapModeUtil.getMapMode((IFigure)fig).LPtoDP(2));
        int angleGrad = 30;
        graphics.drawArc((Rectangle)loopRect, -(90 - angleGrad), 360 - 2 * angleGrad);
        double dx = loopRect.preciseWidth / 2.0 * Math.cos(Math.toRadians(90 - angleGrad));
        double dy = loopRect.preciseHeight / 2.0 * Math.sin(Math.toRadians(90 - angleGrad));
        double endX = loopRect.preciseX + loopRect.preciseWidth / 2.0 - dx;
        double endY = loopRect.preciseY + loopRect.preciseHeight / 2.0 + dy;
        double length = endX - loopRect.preciseX;
        PrecisionPoint pp1 = new PrecisionPoint(loopRect.preciseX, endY);
        PrecisionPoint pp2 = new PrecisionPoint(endX, endY);
        graphics.drawLine((Point)pp1, (Point)pp2);
        PrecisionPoint pp3 = new PrecisionPoint(endX, endY - length);
        graphics.drawLine((Point)pp2, (Point)pp3);
        graphics.popState();
    }
}

