/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.ui.PopupBalloon;
import org.eclipse.stp.bpmn.dnd.IGenericEAnnotationDndHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEAnnotationDropPolicy
extends GraphicalEditPolicy {
    private EditPolicy previousEditPolicy;
    private Map<Request, List<EAnnotation>> requestAnnotations = new WeakHashMap<Request, List<EAnnotation>>();
    private static PopupBalloon _balloon;
    private List<IStatus> _messages = new LinkedList<IStatus>();

    public GenericEAnnotationDropPolicy(IGraphicalEditPart part) {
        EditPolicy policy = part.getEditPolicy((Object)"DragDropPolicy");
        if (policy != null) {
            this.previousEditPolicy = policy;
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if (this.understandsRequest(request)) {
            return this.getHost();
        }
        return null;
    }

    public boolean understandsRequest(Request req) {
        if (req instanceof DropObjectsRequest) {
            List objects = ((DropObjectsRequest)req).getObjects();
            if (objects == null || objects.isEmpty()) {
                return this.delegateUnderstandsRequest(req);
            }
            List<EAnnotation> annotations = this.retrieveAnnotations(objects);
            if (annotations == null) {
                return this.delegateUnderstandsRequest(req);
            }
            boolean accepted = this.accept(annotations, (DropObjectsRequest)req);
            if (accepted) {
                this.requestAnnotations.put(req, annotations);
                return true;
            }
        }
        return this.delegateUnderstandsRequest(req);
    }

    private boolean delegateUnderstandsRequest(Request req) {
        if (this.previousEditPolicy != null) {
            return this.previousEditPolicy.understandsRequest(req);
        }
        return false;
    }

    private Command delegateGetCommand(Request req) {
        if (this.previousEditPolicy != null) {
            return this.previousEditPolicy.getCommand(req);
        }
        return null;
    }

    private List<EAnnotation> retrieveAnnotations(List objects) {
        LinkedList<EAnnotation> annotations = new LinkedList<EAnnotation>();
        for (Object dropped : objects) {
            Object ann = Platform.getAdapterManager().getAdapter(dropped, EAnnotation.class);
            if (dropped instanceof EAnnotation) {
                ann = dropped;
            }
            if (ann == null || !(ann instanceof EAnnotation)) {
                return null;
            }
            annotations.add((EAnnotation)ann);
        }
        return annotations;
    }

    private boolean accept(List<EAnnotation> annotations, DropObjectsRequest request) {
        this._messages.clear();
        boolean doit = true;
        for (EAnnotation annotation : annotations) {
            IGenericEAnnotationDndHandler handler = BpmnDiagramEditorPlugin.getInstance().getEAnnotationDragAndDropHandler(annotation.getSource());
            if (handler == null) {
                throw new IllegalArgumentException("No extension point is defined for the annotation source " + annotation.getSource());
            }
            IStatus status = handler.accept(annotation, (IGraphicalEditPart)this.getHost());
            if (status.getSeverity() != 0) {
                doit = false;
            }
            if (status.getMessage() == null || status.getMessage().length() == 0) continue;
            this._messages.add(status);
        }
        if (!this._messages.isEmpty()) {
            if (_balloon == null) {
                _balloon = new PopupBalloon((IGraphicalEditPart)this.getHost());
            }
            if (_balloon.isShowing() && !_balloon.showsOnThisEditPart((IGraphicalEditPart)this.getHost())) {
                _balloon.hide();
            }
            if (!_balloon.isShowing()) {
                for (IStatus descriptor : this._messages) {
                    _balloon.addPopupBarDescriptor(descriptor.getMessage(), descriptor.getSeverity());
                }
                _balloon.showBalloon(request.getLocation());
            }
        }
        return doit;
    }

    public Command getCommand(Request request) {
        if (!this.understandsRequest(request) || this.requestAnnotations.get(request) == null) {
            return this.delegateGetCommand(request);
        }
        List<EAnnotation> annotations = this.requestAnnotations.get(request);
        if (this.getHost().getModel() instanceof View && ((View)this.getHost().getModel()).getElement() instanceof EModelElement) {
            EModelElement modelElement = (EModelElement)((View)this.getHost().getModel()).getElement();
            AddAnnotationCommand gmfco = new AddAnnotationCommand(modelElement, annotations);
            Command co = new Command((ICommand)gmfco){
                private final /* synthetic */ ICommand val$gmfco;
                {
                    this.val$gmfco = iCommand;
                }

                public void execute() {
                    try {
                        this.val$gmfco.execute(null, null);
                    }
                    catch (ExecutionException e) {
                        BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, "Error dropping the annotation", (Throwable)e));
                    }
                }

                public void undo() {
                    try {
                        this.val$gmfco.undo(null, null);
                    }
                    catch (ExecutionException e) {
                        BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, "Error dropping the annotation", (Throwable)e));
                    }
                }

                public void redo() {
                    try {
                        this.val$gmfco.redo(null, null);
                    }
                    catch (ExecutionException e) {
                        BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, "Error dropping the annotation", (Throwable)e));
                    }
                }
            };
            co.setLabel("DnD annotation");
            return co;
        }
        return this.delegateGetCommand(request);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddAnnotationCommand
    extends AbstractTransactionalCommand {
        private EModelElement element;
        private List<EAnnotation> annotationsToAdd;
        private CompoundCommand emfCommand;

        public AddAnnotationCommand(EModelElement elt, List<EAnnotation> annotationsToAdd) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)elt), "DnD", AddAnnotationCommand.getWorkspaceFiles((EObject)elt));
            this.element = elt;
            this.annotationsToAdd = annotationsToAdd;
            this.initCommand();
        }

        private void initCommand() {
            this.emfCommand = new CompoundCommand();
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.element);
            for (EAnnotation annotation : this.annotationsToAdd) {
                IGenericEAnnotationDndHandler handler = BpmnDiagramEditorPlugin.getInstance().getEAnnotationDragAndDropHandler(annotation.getSource());
                if (handler == null) {
                    throw new IllegalArgumentException("No extension point is defined for the annotation source " + annotation.getSource());
                }
                if (!handler.doPerformDrop(this.emfCommand, annotation, this.element)) continue;
                this.emfCommand.append(SetCommand.create((EditingDomain)domain, (Object)annotation, (Object)EcorePackage.eINSTANCE.getEAnnotation_EModelElement(), (Object)this.element));
            }
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.emfCommand.execute();
            if (_balloon != null && _balloon.isShowing()) {
                _balloon.hide();
            }
            return CommandResult.newOKCommandResult();
        }

        protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.emfCommand.undo();
            return super.doUndo(monitor, info);
        }

        protected IStatus doRedo(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            this.emfCommand.redo();
            return super.doRedo(arg0, arg1);
        }
    }
}

