/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.tools.ConnectionValidator;

public class MessageConnectionValidator
implements ConnectionValidator {
    public boolean canStart(EditPart sourceEditPart) {
        if (sourceEditPart instanceof ActivityEditPart) {
            EObject element = ((Node)sourceEditPart.getModel()).getElement();
            int activityType = ((Activity)element).getActivityType().getValue();
            switch (activityType) {
                case 2: 
                case 3: 
                case 4: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return false;
                }
            }
        } else {
            if (sourceEditPart instanceof SubProcessEditPart) {
                return false;
            }
            if (sourceEditPart instanceof Activity2EditPart) {
                return false;
            }
        }
        return true;
    }

    public boolean canEnd(EditPart targetEditPart) {
        if (targetEditPart instanceof ActivityEditPart) {
            EObject element = ((Node)targetEditPart.getModel()).getElement();
            int activityType = ((Activity)element).getActivityType().getValue();
            switch (activityType) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return false;
                }
            }
        } else {
            if (targetEditPart instanceof SubProcessEditPart) {
                return false;
            }
            if (targetEditPart instanceof Activity2EditPart) {
                return false;
            }
        }
        return true;
    }

    public boolean canConnect(EditPart source, EditPart target) {
        if (source.equals(target)) {
            return false;
        }
        if (!this.canEnd(target)) {
            return false;
        }
        if (!this.canStart(source)) {
            return false;
        }
        return !this.getPool(source).equals(this.getPool(target));
    }

    protected EditPart getPool(EditPart activity) {
        if (activity instanceof PoolEditPart) {
            return activity;
        }
        EditPart parent = activity.getParent();
        while (!(parent instanceof PoolEditPart)) {
            parent = parent.getParent();
        }
        return parent;
    }
}

