/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.tools.ActivityResizeTracker;
import org.eclipse.swt.SWT;

public class PoolResizeTracker
extends ActivityResizeTracker {
    public PoolResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        int direction = this.getResizeDirection();
        List part = this.getOperationSet();
        List siblings = null;
        request.setConstrainedResize(false);
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        GraphicalEditPart owner = this.getOwner();
        PrecisionRectangle sourceRect = this.getSourceRectangle();
        SnapToHelper snapToHelper = this.getSnapToHelper();
        if (this.hasPoolEditPart(part) && (direction == 16 || direction == 8 || direction == 17 || direction == 9 || direction == 20 || direction == 20)) {
            int k = 0;
            while (k < part.size()) {
                if (part.get(k) instanceof PoolEditPart) {
                    siblings = ((PoolEditPart)((Object)part.get(k))).getParent().getChildren();
                }
                ++k;
            }
            int i = 0;
            while (i < siblings.size()) {
                if (!part.contains(siblings.get(i))) {
                    part.add(siblings.get(i));
                }
                ++i;
            }
        }
        Dimension minSize = this.getMinPoolSize(part);
        Dimension siblingsMinSize = this.getMinPoolSize(siblings);
        Dimension figureSize = owner.getFigure().getSize();
        RootEditPart rootEditPart = owner.getRoot();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            double zoom = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager().getZoom();
            minSize.scale(zoom);
            siblingsMinSize.scale(zoom);
            figureSize.scale(zoom);
        }
        if ((direction & 1) != 0 && part.size() < 2) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (minSize.height > figureSize.height - 2 * d.height) {
                    d.setSize(new Dimension(d.width, (figureSize.height - minSize.height) / 2));
                }
                resizeDelta.height -= d.height;
            } else if (minSize.height > figureSize.height - d.height) {
                d.setSize(new Dimension(d.width, figureSize.height - minSize.height));
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((direction & 4) != 0 && part.size() < 2) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (minSize.height > figureSize.height + 2 * d.height) {
                    d.setSize(new Dimension(d.width, -(figureSize.height - minSize.height) / 2));
                }
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            } else if (minSize.height > figureSize.height + d.height) {
                d.setSize(new Dimension(d.width, -(figureSize.height - minSize.height)));
            }
            resizeDelta.height += d.height;
        }
        if ((direction & 8) != 0) {
            if (siblingsMinSize.width > figureSize.width - d.width) {
                d.setSize(new Dimension(figureSize.width - siblingsMinSize.width, d.height));
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((direction & 0x10) != 0) {
            if (siblingsMinSize.width > figureSize.width + d.width) {
                d.setSize(new Dimension(-(figureSize.width - siblingsMinSize.width), d.height));
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(part);
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && snapToHelper != null) {
            PrecisionRectangle rect = sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                    result.preciseWidth *= 2.0;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                    result.preciseHeight *= 2.0;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }

    private boolean hasPoolEditPart(List parts) {
        int i = 0;
        while (i < parts.size()) {
            if (parts.get(i) instanceof PoolEditPart) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Dimension getMinPoolSize(List parts) {
        Dimension result = new Dimension(150, 50);
        if (parts == null) {
            return result;
        }
        int i = 0;
        while (i < parts.size()) {
            if (parts.get(i) instanceof PoolEditPart) {
                PoolEditPart pool = (PoolEditPart)((Object)parts.get(i));
                IGraphicalEditPart poolCompartment = pool.getChildBySemanticHint(Integer.toString(5001));
                int nameWidth = poolCompartment.getFigure().getBounds().x + 1;
                Dimension rect = pool.getPoolContainRectangle().getSize();
                rect.expand(PoolPoolCompartmentEditPart.INSETS.getWidth(), PoolPoolCompartmentEditPart.INSETS.getHeight() + 2);
                if (rect.height > result.height) {
                    result.setSize(new Dimension(result.width, rect.height));
                }
                if (rect.width + nameWidth > result.width) {
                    result.setSize(new Dimension(rect.width + nameWidth, result.height));
                }
            }
            ++i;
        }
        return result;
    }
}

