/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.tools.TaskDragHelper;

public class TaskDragEditPartsTrackerEx
extends DragEditPartsTrackerEx {
    public TaskDragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected void performDrag() {
        boolean reparentEnabled = this.isReparentEnabled();
        if (!reparentEnabled) {
            EditPart source = this.getSourceEditPart();
            EditPart parent = source.getParent();
            Rectangle parentBounds = ((GraphicalEditPart)parent).getFigure().getBounds();
            List selectedObjects = this.getCurrentViewer().getSelectedEditParts();
            Rectangle selectionBounds = ((GraphicalEditPart)source).getFigure().getBounds().getCopy();
            for (Object item : selectedObjects) {
                if (!(item instanceof GraphicalEditPart)) continue;
                Rectangle itemBounds = ((GraphicalEditPart)item).getFigure().getBounds().getCopy();
                selectionBounds.union(itemBounds);
            }
            assert (parent instanceof SubProcessSubProcessBodyCompartmentEditPart || parent instanceof PoolPoolCompartmentEditPart);
            Command containerBoundsCommand = TaskDragHelper.getNewContainerBoundsCommand((GraphicalEditPart)source, selectedObjects, selectionBounds, (GraphicalEditPart)parent.getParent(), parentBounds, this.getDragMoveDelta());
            CompoundCommand currentCommand = (CompoundCommand)this.getCurrentCommand();
            currentCommand.add(containerBoundsCommand);
            super.performDrag();
            parent.refresh();
        } else {
            super.performDrag();
        }
    }

    private boolean isReparentEnabled() {
        IGraphicalEditPart source = (IGraphicalEditPart)this.getSourceEditPart();
        return this.getCurrentInput().isControlKeyDown() && source.getParent() instanceof PoolPoolCompartmentEditPart && source.getSourceConnections().size() == 0 && source.getTargetConnections().size() == 0;
    }

    protected boolean isMove() {
        boolean isMove = this.isReparentEnabled() ? super.isMove() : true;
        return isMove;
    }

    protected void setTargetEditPart(EditPart editpart) {
        if (this.isReparentEnabled()) {
            this.setCloneActive(!(editpart instanceof PoolPoolCompartmentEditPart) || editpart == this.getSourceEditPart().getParent());
        }
        super.setTargetEditPart(editpart);
    }
}

