package org.eclipse.stp.bpmn.diagram.edit.policies;

import java.util.List;

import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;

/**
 * Set subprocess figure default size 
 * 
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 * @author vlevytskyy
 */
public class SubProcessCreationEditPolicy extends CreationEditPolicy {

    @Override
    /**
     * Set subprocess figure default size
     */
    protected Command getCreateCommand(CreateViewRequest request) {
        List viewDescriptors = request.getViewDescriptors();
        for (Object viewDescriptor : viewDescriptors) {
            String semanticHints = BpmnVisualIDRegistry
                    .getType(org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart.VISUAL_ID);
            if (semanticHints
                    .equals(((ViewDescriptor) viewDescriptor)
                            .getSemanticHint())) {
                if (request.getSize() == null) {
                    request
                            .setSize(SubProcessEditPart.EXPANDED_SIZE);
                }
            }
        }
        return super.getCreateCommand(request);
    }

}
