/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

/** 
 * Date           	Author              Changes 
 * 12 Sep 2006   	MPeleshchyshyn  	Created 
 **/

package org.eclipse.stp.bpmn.policies;

import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.stp.bpmn.tools.SubProcessResizeTracker;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

/**
 * Resize edit policy for subprocesses.
 * 
 * @author MPeleshchyshyn
 * 
 */
public class ResizableSubProcessEditPolicy extends ResizableShapeEditPolicyEx {

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx#createHandle(org.eclipse.gef.GraphicalEditPart,
     *      int)
     */
    @Override
    protected Handle createHandle(GraphicalEditPart owner, int direction) {
        return new SubProcessResizeHandle(owner, direction);
    }

    protected static class SubProcessResizeHandle extends ResizeHandleEx {

        public SubProcessResizeHandle(GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        @Override
        protected DragTracker createDragTracker() {
            return new SubProcessResizeTracker(getOwner(), cursorDirection);
        }
    }

    @Override
    protected void replaceHandleDragEditPartsTracker(Handle handle) {
        if (handle instanceof AbstractHandle) {
            AbstractHandle h = (AbstractHandle) handle;
            h.setDragTracker(new TaskDragEditPartsTrackerEx(getHost()));
        }
    }
}
