/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

package org.eclipse.stp.bpmn.preferences;

import org.eclipse.gmf.runtime.diagram.ui.preferences.DiagramsPreferencePage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * Preference page. Follow the tutorial here:
 * <link>http://help.eclipse.org/help32/topic/org.eclipse.gmf.doc/tutorials/diagram/diagramPreferencesTutorial.html</link>
 * 
 * @author hmalphettes
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class BpmnDiagramsPreferencePage extends DiagramsPreferencePage {

    /** the preference key used to store the default value for the
     * delay of the connection assistant */
    private static String PREF_CONN_DIAG_ASSISTANT_DELAY_MS =
        BpmnDiagramPreferenceInitializer.PREF_CONN_DIAG_ASSISTANT_DELAY_MS;

    /** the preference key used to store the default value to enable snap-to-geometry*/
    private static String PREF_SNAP_TO_GEOMETRY =
        BpmnDiagramPreferenceInitializer.PREF_SNAP_TO_GEOMETRY;

    public BpmnDiagramsPreferencePage() {
        super();
        setPreferenceStore(BpmnDiagramEditorPlugin.getInstance().getPreferenceStore());
    }
    
    
    /* (non-Javadoc)
     * @see org.eclipse.gmf.runtime.common.ui.preferences.AbstractPreferencePage#addFields(org.eclipse.swt.widgets.Composite)
     */
    protected void addFields(Composite parent) {
        super.addFields(parent);
        
        Group bpmnGlobalGroup = new Group(parent, SWT.NONE);
        GridLayout gridLayout = new GridLayout(2, false);
        bpmnGlobalGroup.setLayout(gridLayout);
        GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        bpmnGlobalGroup.setLayoutData(gridData);
        bpmnGlobalGroup.setText("Other Settings");

        Composite newParent = new Composite(bpmnGlobalGroup, SWT.NONE);
        
        BooleanFieldEditor snapGeomEd = new BooleanFieldEditor(
                PREF_SNAP_TO_GEOMETRY,
                "Unable align helpers based on geometry",
                newParent);
        super.addField(snapGeomEd);
        
        IntegerFieldEditor delayEd = new IntegerFieldEditor(
                PREF_CONN_DIAG_ASSISTANT_DELAY_MS,
                "Connection assistant appearance delay (milli-seconds)",
                newParent);
        delayEd.setErrorMessage("Expecting a positive integer or zero.");
        delayEd.setValidRange(0, 20000);
        super.addField(delayEd);

    }
    
}
