/**
 * 
 */
package org.eclipse.stp.bpmn.commands;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

/**
 * Creates a blank task and add it to the creating subprocess
 * 
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 * @author vlevytskyy
 */
public class CreateSubProcessCommand extends CreateElementCommandEx {

    public CreateSubProcessCommand(CreateElementRequest req) {
        super(req);
    }

    @Override
    /**
     * Create and add a task to the subprocess
     */
    protected EObject doDefaultElementCreation() {
        EObject object = super.doDefaultElementCreation();
        EReference containment = getContainmentFeature();
        IElementType type = BpmnElementTypes.Activity_2001;
        EClass eClass = type.getEClass();

        if (containment != null) {
            EMFCoreUtil.create(object, containment, eClass);
        }

        return object;
    }
}
