/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

/**
 * Date             Author              Changes
 * Nov 28, 2006     MPeleshchsyhyn         Created
 **/
package org.eclipse.stp.bpmn.commands;

import java.util.List;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.PromptForConnectionAndEndCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

import com.sun.org.apache.bcel.internal.generic.GETSTATIC;

/**
 * 
 * @author MPeleshchyshyn
 * 
 */
public class PromptForConnectionAndEndCommandEx extends
        PromptForConnectionAndEndCommand {

    private CreateConnectionRequest request;

    public PromptForConnectionAndEndCommandEx(CreateConnectionRequest request,
            IGraphicalEditPart containerEP) {
        super(request, containerEP);
        this.request = request;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gmf.runtime.diagram.ui.commands.PromptForConnectionAndEndCommand#getEndMenuContent(java.lang.Object)
     */
    @Override
    protected List getEndMenuContent(Object connectionItem) {
        List l = super.getEndMenuContent(connectionItem);
        EditPart source = request.getSourceEditPart();
        EditPart target = request.getTargetEditPart();
        if ((MetamodelType) connectionItem == BpmnElementTypes.MessagingEdge_3002) {
            if (getPool(source).equals(getPool(target))) {
                Object lastElement = l.get(l.size() - 1);
                l.clear();
                l.add(lastElement);
            }
        } else if ((MetamodelType) connectionItem == BpmnElementTypes.SequenceEdge_3001) {
            if (!(getPool(source).equals(getPool(target)))) {
                Object lastElement = l.get(l.size() - 1);
                l.clear();
                l.add(lastElement);
            }
        }
        return l;
    }

    /**
     * Returns parent pool for the specified edit part or edit part itself in
     * case if specified edit part is a pool edit part
     * 
     * @param editPart
     *            the edit part
     * @return parent pool for the specified edit part or edit part itself in
     *         case if specified edit part is a pool edit part
     */
    protected EditPart getPool(EditPart editPart) {
        if (editPart instanceof PoolEditPart) {
            return editPart;
        }
        EditPart parent = editPart.getParent();

        while (!(parent instanceof PoolEditPart)) {
            parent = parent.getParent();
        }

        return parent;
    }
}
