/**
 * Copyright (C) 2000-2006, Intalio Inc.
 *
 * The program(s) herein may be used and/or copied only with the
 * written permission of Intalio Inc. or in accordance with the terms
 * and conditions stipulated in the agreement/contract under which the
 * program(s) have been supplied.
 *
 * Dates       		 Author              Changes
 * Nov 28, 2006      Antoine Toulm   Creation
 */
package org.eclipse.stp.bpmn.policies;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;

/**
 * Extending the diagram drag and drop edit policy so that
 * the diagram checks the selection before casting in EObjects.
 * 
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class DiagramDragDropEditPolicyEx extends DiagramDragDropEditPolicy {

	/* (non-Javadoc)
	 * @see org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy#getDropObjectsCommand(org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
		List objects = dropRequest.getObjects();
		for (Object o : objects) {
			if (! (o instanceof EObject)) {
				return null;
			}
		}
		return super.getDropObjectsCommand(dropRequest);
	}

}
