/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.views.properties.tabbed.AbstractTypeMapper;

/**
 * Maps IGraphicalEditParts to EModelElements, so that they can be detected and 
 * the BPMN tab shown.
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class BpmnTypeMapper extends AbstractTypeMapper {

	public BpmnTypeMapper() {
	}
	/**
     * @inheritDoc
     */
    public Class mapType(Object input) {
        Class type = null;
        if (input instanceof IGraphicalEditPart) {
        	View v = ((IGraphicalEditPart) input).getNotationView();
        	EObject tmpObj = v.getElement();
        	if (tmpObj != null) {
        		type = tmpObj.getClass();
        	}
        } else if (input instanceof EObject) {
        	type = input.getClass();
        }
        if (type == null) {
        	type = super.mapType(input);
        }
        return type;
    }
}
