/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener.Stub;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;

/**
 * @author Anton Serhiychuk
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 * 
 */
public class AddChildLayoutListener extends Stub {
    private EditPart editPart;

    public AddChildLayoutListener(EditPart editPart) {
        this.editPart = editPart;
    }

    @Override
    public void postLayout(IFigure source) {
        if (editPart instanceof SubProcessEditPart) {
            if (((SubProcessEditPart) editPart).isNeedToUpdateContainer()) {
                ((SubProcessEditPart) editPart).setNeedToUpdateContainer(false);
            } else {
                return;
            }
        } else if (editPart instanceof ActivityEditPart) {
            if (((ActivityEditPart) editPart).isChildAdded()) {
                ((ActivityEditPart) editPart).setChildAdded(false);
            } else {
                return;
            }
        }
        super.postLayout(source);

        // child
        Rectangle sourceBounds = source.getBounds().getCopy();
        TaskDragHelper.updateContainerBounds((GraphicalEditPart) editPart,
                sourceBounds, true);
    }
}
