/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.figures.activities.ActivityDiamondFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityNodeFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityOvalFigure;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.WrapperNodeFigureEx;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.GenericEAnnotationDropPolicy;
import org.eclipse.stp.bpmn.policies.ResizableActivityEditPolicy;
import org.eclipse.stp.bpmn.tools.AddChildLayoutListener;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.MessageConnectionValidator;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;
import org.eclipse.swt.graphics.Font;

/**
 * @generated
 */
public class ActivityEditPart extends ShapeNodeEditPart {
    // private Point targetFigureLocation = new Point(-300, -300);

    private static final int SHAPE_RECTANGLE = 0;

    private static final int SHAPE_DIAMOND = 1;

    private static final int SHAPE_CIRCLE = 2;

    /**
     * @notgenerated
     */
    private static final int EVENT_FIGURE_SIZE = 30;

    /**
     * @notgenerated
     */
    private static final int GATEWAY_FIGURE_SIZE = 50;

    /**
     * @notgenerated
     */
    public static final Dimension ACTIVITY_FIGURE_SIZE = new Dimension(111, 61);

    /**
     * @generated
     */
    public static final int VISUAL_ID = 2001;

    /**
     * @notgenerated
     */
    private int handlePosition;

    /**
     * @notgenerated
     */
    protected boolean isChildAdded = false;

    /**
     * @generated
     */
    protected IFigure contentPane;

    /**
     * @generated
     */
    protected IFigure primaryShape;

    /**
     * Structure of figure: WrapperNodeFigure is a node plate figure that wraps
     * Oval, Diamond or rectanle, that holds primary shape. Wrapped shape can be
     * chaged when activity type is changed.
     * 
     * @notgenerated
     */
    private NodeFigure wrappedFigure;

    /**
     * @generated
     */
    public ActivityEditPart(View view) {
        super(view);
    }

    /**
     * @generated
     */
    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
                new ActivityItemSemanticEditPolicy());
        installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE,
                new ActivityGraphicalNodeEditPolicy());
        installEditPolicy(EditPolicyRoles.CANONICAL_ROLE,
                new ActivityCanonicalEditPolicy());
        installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
    }

    /**
     * @notgenerated
     */
    protected void createDefaultEditPolicies() {
        createDefaultEditPoliciesGen();

        // replace ConnectionHandleEditPolicy with our own
        removeEditPolicy(EditPolicyRoles.CONNECTION_HANDLES_ROLE);
        installEditPolicy(EditPolicyRoles.CONNECTION_HANDLES_ROLE,
                new ConnectionHandleEditPolicyEx());
        // adding default drag and drop edit policy
        installEditPolicy(EditPolicyRoles.DRAG_DROP_ROLE,
                new GenericEAnnotationDropPolicy(this));
    }

    /**
     * @generated
     */
    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy() {

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child
                        .getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    @Override
    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    /**
     * @generated
     */
    protected IFigure createNodeShapeGen() {
        ActivityFigure figure = new ActivityFigure();
        return primaryShape = figure;
    }

    /**
     * @notgenerated
     */
    protected IFigure createNodeShape() {
        ActivityFigure figure = (ActivityFigure) createNodeShapeGen();
        Activity activity = (Activity) getPrimaryView().getElement();
        setActivityTypeAndLabelAndLayout(figure, activity);
        figure.setLooping(activity.isLooping());
        return figure;
    }

    /**
     * 
     * @param activityFigure
     * @param activity
     * @return true if refreshVisual is recommended (there was a change)
     */
    private boolean setActivityTypeAndLabelAndLayout(
            ActivityFigure activityFigure, Activity activity) {
        activityFigure.setActivityType(activity.getActivityType().getLiteral());
        boolean res = false;
        if (activity.getName() == null) {
            WrapLabel wl = activityFigure.getFigureActivityNameFigure();
            if (activity.getActivityType().equals(ActivityType.TASK_LITERAL)) {
                if (!"Task".equals(wl.getText())) {
                    wl.setText("Task");
                }
            }
            res = true;
        }

        if (activity.getActivityType().equals(ActivityType.TASK_LITERAL)) {
            if (!(activityFigure.getLayoutManager() instanceof StackLayout)) {
                StackLayout layout = new StackLayout();
                activityFigure.setLayoutManager(layout);
                res = true;
            }
        } else {
            if (!(activityFigure.getLayoutManager() instanceof ConstrainedToolbarLayout)) {
                ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
                layout.setSpacing(getMapMode().DPtoLP(5));
                activityFigure.setLayoutManager(layout);
                res = true;
            }
        }

        return res;
    }

    /**
     * @generated
     */
    public ActivityFigure getPrimaryShape() {
        return (ActivityFigure) primaryShape;
    }

    /**
     * @generated
     */
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityNameEditPart) {
            ((ActivityNameEditPart) childEditPart).setLabel(getPrimaryShape()
                    .getFigureActivityNameFigure());
            return true;
        }
        return false;
    }

    /**
     * @generated
     */
    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    /**
     * @notgenerated
     */
    protected NodeFigure createNodePlate() {

        // final Activity2EditPart zis = this;

        return new WrapperNodeFigureEx(ConnectionAnchorFactory.INSTANCE,
                createWrappedFigure()) {
            @Override
            /**
             * Exclude activity name label from handle bounds
             */
            public Rectangle getHandleBounds() {
                Rectangle rectangle = super.getHandleBounds();
                Activity activity = (Activity) getPrimaryView().getElement();
                if (activity.getActivityType()
                        .equals(ActivityType.TASK_LITERAL)) {
                    return rectangle;
                }

                IGraphicalEditPart activityNameEditPart = getChildBySemanticHint(BpmnVisualIDRegistry
                        .getType(org.eclipse.stp.bpmn.diagram.edit.parts.ActivityNameEditPart.VISUAL_ID));
                int nameFigureHeight = activityNameEditPart.getFigure()
                        .getSize().height;

                return new Rectangle(rectangle.x, rectangle.y, rectangle.width,
                        rectangle.height - nameFigureHeight);

            };

            @Override
            public void setBounds(Rectangle rect) {
                int x = bounds.x, y = bounds.y;

                boolean resize = (rect.width != bounds.width)
                        || (rect.height != bounds.height), translate = (rect.x != x)
                        || (rect.y != y);

                if ((resize || translate) && isVisible())
                    erase();
                if (translate) {
                    int dx = rect.x - x;
                    int dy = rect.y - y;
                    primTranslate(dx, dy);
                }

                bounds.width = rect.width;
                bounds.height = rect.height;

                if (translate || resize) {
                    if (resize || isChildAdded && translate) {
                        invalidate();
                    }
                    fireFigureMoved();
                    repaint();
                }

            }
        };
    }

    /**
     * @notgenerated
     * @return
     */
    private NodeFigure createWrappedFigure() {
        Activity activity = (Activity) getPrimaryView().getElement();
        final int activityType = activity.getActivityType().getValue();

        int shapeType = getShapeType(activityType);
        if (shapeType == SHAPE_RECTANGLE) {
            int width = getMapMode().DPtoLP(ACTIVITY_FIGURE_SIZE.width);
            int height = getMapMode().DPtoLP(ACTIVITY_FIGURE_SIZE.height);
            wrappedFigure = new ActivityNodeFigure(width, height);
        } else if (shapeType == SHAPE_DIAMOND) {
            wrappedFigure = new ActivityNodeFigure(0, 0);
        } else {
            wrappedFigure = new ActivityNodeFigure(0, 0);
        }
        wrappedFigure.setLayoutManager(new StackLayout());
        return wrappedFigure;
    }

    /**
     * @notgenerated
     */
    private void buildFigure(IFigure container, IFigure shape,
            WrapLabel wrapLabel, int size) {
        int resultSize = getMapMode().DPtoLP(size);
        container.setSize(resultSize, resultSize);

        wrappedFigure.setLayoutManager(new BorderLayout());
        container.setLayoutManager(new StackLayout());
        container.add(shape);

        wrappedFigure.add(container, BorderLayout.CENTER);
        wrappedFigure.add(wrapLabel, BorderLayout.BOTTOM);

        ((ActivityFigure) shape).setFigureActivityNameFigure(wrapLabel);

        contentPane = setupContentPane(wrappedFigure);
    }

    /**
     * @author vlevytskyy
     * @notgenerated
     */
    private class ResizableWrapLabel extends WrapLabel {
        @Override
        public void setText(String s) {
            String s1 = s.trim();
            if (s.length() != 0 && s1.length() == 0) {
                s = s1;
            }
            super.setText(s);
        }

        @Override
        public void setFont(Font f) {
            Font oldFont = super.getFont();
            super.setFont(f);
            changeActivitySize(oldFont, f);
        }
    }

    /**
     * 
     * @notgenerated
     */
    private void changeActivitySize(Font oldFont, Font newFont) {
        IFigure child = ((IGraphicalEditPart) getPrimaryChildEditPart())
                .getFigure();
        int fontDiff = FigureUtilities.getTextExtents("", newFont).height
                - FigureUtilities.getTextExtents("", oldFont).height;

        if ((fontDiff != 0) && (child instanceof WrapLabel)) {
            String text = ((WrapLabel) child).getText();
            if (text != null && text.length() > 0) {
                Rectangle oldBounds = getNodeFigure().getBounds();
                changeBounds(new Rectangle(oldBounds.x, oldBounds.y,
                        oldBounds.width, oldBounds.height + fontDiff));
            }
        }
    }

    /**
     * Increase node figure height for wraplabel height when text is not empty
     * and set it to default otherwise
     * 
     * @notgenerated
     */
    private void changeActivitySize(String oldNameText, String newNameText) {
        IFigure child = ((IGraphicalEditPart) getPrimaryChildEditPart())
                .getFigure();
        Rectangle oldBounds = getNodeFigure().getBounds();

        final int wrapLabelHeight = FigureUtilities.getTextExtents("", child
                .getFont()).height;

        boolean wasEmpty = oldNameText == null
                || oldNameText.trim().length() == 0;
        boolean isEmpty = newNameText == null
                || newNameText.trim().length() == 0;

        int height;
        if (wasEmpty == isEmpty) {
            return;
        } else if (wasEmpty && !isEmpty) {
            height = wrapLabelHeight;
        } else {
            height = -wrapLabelHeight;
        }

        changeBounds(new Rectangle(oldBounds.x, oldBounds.y, oldBounds.width,
                oldBounds.height + height));
    }

    /**
     * Change bounds of node figure
     * 
     * @notgenerated
     * @param newBounds -
     *            new bounds
     */
    private void changeBounds(Rectangle newBounds) {
        SetBoundsCommand cmd = new SetBoundsCommand(getEditingDomain(),
                "Change node figure size", this, newBounds);
        getDiagramEditDomain().getDiagramCommandStack().execute(
                new ICommandProxy(cmd));
    }

    /**
     * Creates figure for this edit part.
     * 
     * Body of this method does not depend on settings in generation model so
     * you may safely remove <i>generated</i> tag and modify it.
     * 
     * @notgenerated
     */
    protected NodeFigure createNodeFigure() {
        NodeFigure figure = createNodePlate();
        IFigure shape = createNodeShape();

        ActivityType activityType = ((Activity) getPrimaryView().getElement())
                .getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean event = ActivityType.VALUES_EVENTS.contains(activityType)
                || ActivityType.VALUES_EVENTS_INTERMEDIATE
                        .contains(activityType);

        if (gateway) {
            int size = getMapMode().DPtoLP(GATEWAY_FIGURE_SIZE);
            IFigure diamondFigure = new ActivityDiamondFigure(new Dimension(
                    size, size));
            buildFigure(diamondFigure, shape, new ResizableWrapLabel(),
                    GATEWAY_FIGURE_SIZE);
        } else if (event) {
            ActivityOvalFigure ovalFigure = new ActivityOvalFigure();
            buildFigure(ovalFigure, shape, new ResizableWrapLabel(),
                    EVENT_FIGURE_SIZE);
        } else {
            wrappedFigure.add(shape);
            contentPane = setupContentPane(shape);
        }

        figure.addLayoutListener(new AddChildLayoutListener(this));

        figure.addLayoutListener(new LayoutListener.Stub() {
            @Override
            /**
             * set activity default size
             */
            public void postLayout(IFigure container) {
                super.postLayout(container);
                boolean initialLayout = getStructuralFeatureValue(
                        NotationPackage.eINSTANCE.getSize_Width()).equals(-1)
                        && getStructuralFeatureValue(
                                NotationPackage.eINSTANCE.getSize_Height())
                                .equals(-1);
                if (initialLayout) {
                    changeBounds(getNodeFigure().getBounds());
                }
            }
        });
        return figure;
    }

    /**
     * Default implementation treats passed figure as content pane. Respects
     * layout one may have set for generated figure.
     * 
     * @param nodeShape
     *            instance of generated figure class
     * @generated
     */
    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager(layout);
        }
        return nodeShape; // use nodeShape itself as contentPane
    }

    /**
     * @notgenerated
     */
    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            EObject element = ((Node) getModel()).getElement();
            int activityType = ((Activity) element).getActivityType()
                    .getValue();
            if (activityType == ActivityType.TASK) {
                StackLayout layout = new StackLayout();
                nodeShape.setLayoutManager(layout);
            } else {
                return setupContentPaneGen(nodeShape);
            }
        }
        return nodeShape; // use nodeShape itself as contentPane
    }

    /**
     * @generated
     */
    public IFigure getContentPane() {
        if (contentPane != null) {
            return contentPane;
        }
        return super.getContentPane();
    }

    /**
     * @generated
     */
    public EditPart getPrimaryChildEditPart() {
        return getChildBySemanticHint(BpmnVisualIDRegistry
                .getType(ActivityNameEditPart.VISUAL_ID));
    }

    /**
     * @generated
     */
    protected void addChildVisual(EditPart childEditPart, int index) {
        if (addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    /**
     * @generated
     */
    protected void removeChildVisual(EditPart childEditPart) {
        if (removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    /**
     * 
     * @return true if activity type is event or gateway, false otherwise
     * @notgenerated
     */
    private boolean isEventOrGateway() {
        ActivityType activityType = ((Activity) getPrimaryView().getElement())
                .getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean event = ActivityType.VALUES_EVENTS.contains(activityType)
                || ActivityType.VALUES_EVENTS_INTERMEDIATE
                        .contains(activityType);

        return gateway || event;
    }

    /**
     * Synchronizes the shape with the activityType
     * 
     * @notgenerated
     * @see org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart
     *      #handlePropertyChangeEvent(java.beans.PropertyChangeEvent)
     */
    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == Notification.SET) {
            if (BpmnPackage.eINSTANCE.getActivity_ActivityType().equals(
                    notification.getFeature())) {
                // figure = null;
                ActivityType oldActivityType = (ActivityType) notification
                        .getOldValue();
                ActivityType newActivityType = (ActivityType) notification
                        .getNewValue();
                maybeChangeFigure(oldActivityType, newActivityType);
                getPrimaryShape().setActivityType(newActivityType.getLiteral());
                // refreshVisuals();
            } else if (BpmnPackage.eINSTANCE.getActivity_Looping().equals(
                    notification.getFeature())) {
                // looping changed
                getPrimaryShape().setLooping(notification.getNewBooleanValue());
            } else if (NotationPackage.eINSTANCE.getSize_Width().equals(
                    notification.getFeature())
                    || NotationPackage.eINSTANCE.getSize_Height().equals(
                            notification.getFeature())) {
                setChildAdded(true);
            } else if (BpmnPackage.eINSTANCE.getActivity_Name().equals(
                    notification.getFeature())
                    && isEventOrGateway()) {
                changeActivitySize(notification.getOldStringValue(),
                        notification.getNewStringValue());
            }
            Activity activity = (Activity) getPrimaryView().getElement();
            if (setActivityTypeAndLabelAndLayout(getPrimaryShape(), activity)) {
                refreshVisuals();
            }
        }

        super.handleNotificationEvent(notification);
    }

    /**
     * Changes activity type figure in case if shaps of old and new activities
     * are different.
     * 
     * @param oldActvityType
     * @param newActivityType
     * @notgenerated
     */
    private void maybeChangeFigure(ActivityType oldActivityType,
            ActivityType newActivityType) {
        int oldShape = getShapeType(oldActivityType.getValue());
        int newShape = getShapeType(newActivityType.getValue());
        if (newShape != oldShape) {
            wrappedFigure.remove(primaryShape);
            createWrappedFigure();
            ((WrapperNodeFigureEx) figure).setSubfigure(wrappedFigure);
            wrappedFigure.add(primaryShape);

            // refresh target connection anchors of all target connections
            List targetConnections = getTargetConnections();
            Iterator connectionsIterator = targetConnections.iterator();
            while (connectionsIterator.hasNext()) {
                ConnectionNodeEditPart edgeEditPart = (ConnectionNodeEditPart) connectionsIterator
                        .next();
                PolylineConnectionEx figure = (PolylineConnectionEx) edgeEditPart
                        .getFigure();
                ConnectionAnchor currentAnchor = figure.getTargetAnchor();
                Point refPoint = currentAnchor.getReferencePoint();
                figure.setTargetAnchor(wrappedFigure
                        .getTargetConnectionAnchorAt(refPoint));
            }

            // now refresh cource connection anchors of all source connections
            List srcConnections = getSourceConnections();
            connectionsIterator = srcConnections.iterator();
            while (connectionsIterator.hasNext()) {
                ConnectionNodeEditPart edgeEditPart = (ConnectionNodeEditPart) connectionsIterator
                        .next();
                PolylineConnectionEx figure = (PolylineConnectionEx) edgeEditPart
                        .getFigure();
                ConnectionAnchor currentAnchor = figure.getSourceAnchor();
                Point refPoint = currentAnchor.getReferencePoint();
                figure.setSourceAnchor(wrappedFigure
                        .getSourceConnectionAnchorAt(refPoint));
            }
        }
    }

    @Override
    protected void refreshSourceConnections() {
        super.refreshSourceConnections();
        List messages = ((Activity) (((Node) getModel()).getElement()))
                .getOrderedMessages();
        if (messages.size() > 0) {
            updateMessagesIndexes(messages, getSourceConnections(), true);
            updateMessagesIndexes(messages, getTargetConnections(), false);
        }
    }

    @Override
    /**
     * @notgenerated
     */
    protected void refreshTargetConnections() {
        super.refreshTargetConnections();
        List messages = ((Activity) (((Node) getModel()).getElement()))
                .getOrderedMessages();
        if (messages.size() > 0) {
            updateMessagesIndexes(messages, getSourceConnections(), true);
            updateMessagesIndexes(messages, getTargetConnections(), false);

            // now try to update connections on other side also
            List targetConnections = getTargetConnections();
            for (Object object : targetConnections) {
                if (object instanceof MessagingEdgeEditPart) {
                    // it might be a sequence edge.
                    MessagingEdgeEditPart connEditPart = (MessagingEdgeEditPart) object;
                    // opposite edit part
                    ActivityEditPart oppositeActivity = (ActivityEditPart) connEditPart
                            .getSource();
                    if (oppositeActivity != null) {
                        List oppositeSideMessages = ((Activity) (((Node) oppositeActivity
                                .getModel()).getElement()))
                                .getOrderedMessages();
                        updateMessagesIndexes(oppositeSideMessages,
                                oppositeActivity.getSourceConnections(), true);
                        updateMessagesIndexes(messages, oppositeActivity
                                .getTargetConnections(), false);
                    }
                } else {

                }
            }
        }
    }

    /**
     * @notgenerated
     * 
     */
    private void updateMessagesIndexes() {
        List messages = ((Activity) (((Node) getModel()).getElement()))
                .getOrderedMessages();
        if (messages.size() > 0) {
            updateMessagesIndexes(messages, getSourceConnections(), true);
            updateMessagesIndexes(messages, getTargetConnections(), false);
        }
    }

    /**
     * @notgenerated
     * 
     * @param messages
     * @param connectionsEditParts
     * @param isSource
     */
    private static void updateMessagesIndexes(List messages,
            List connectionsEditParts, boolean isSource) {
        int len = messages.size();
        for (Object object : connectionsEditParts) {
            ConnectionEditPart connEditPart = (ConnectionEditPart) object;
            View model = (View) connEditPart.getModel();
            int idx = messages.indexOf(model.getElement());
            if (idx > -1) {
                PolylineConnectionEx connFigure = (PolylineConnectionEx) connEditPart
                        .getFigure();
                ConnectionAnchor anchor;
                if (isSource) {
                    anchor = connFigure.getSourceAnchor();
                } else {
                    anchor = connFigure.getTargetAnchor();
                }
                if (anchor instanceof IModelAwareAnchor) {
                    ((IModelAwareAnchor) anchor).setConnectionType(isSource,
                            String.valueOf(MessagingEdgeEditPart.VISUAL_ID),
                            idx, len);
                    connEditPart.refresh();
                }
            }
        }
    }

    /**
     * @generated
     */
    public class ActivityFigure extends
            org.eclipse.stp.bpmn.figures.activities.ActivityFigure {

        /**
         * @generated
         */
        public ActivityFigure() {

            {
                this.setActivityType("Task");
            }

            this.setForegroundColor(org.eclipse.draw2d.ColorConstants.black

            );

            createContents();
        }

        /**
         * @notgenerated
         */
        private void createContents() {
            ActivityType activityType = ((Activity) getPrimaryView()
                    .getElement()).getActivityType();
            if (activityType.equals(ActivityType.TASK_LITERAL)) {
                createContentsGen();
            }
        }

        /**
         * @generated
         */
        private void createContentsGen() {
            org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fig_0 = new org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel();
            fig_0.setText("Task");

            setFigureActivityNameFigure(fig_0);

            Object layData0 = null;

            this.add(fig_0, layData0);
        }

        /**
         * @generated
         */
        private org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fActivityNameFigure;

        /**
         * @generated
         */
        public org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel getFigureActivityNameFigure() {
            return fActivityNameFigure;
        }

        /**
         * @generated
         */
        private void setFigureActivityNameFigure(
                org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fig) {
            fActivityNameFigure = fig;
        }

        /**
         * @generated
         */
        private boolean myUseLocalCoordinates = false;

        /**
         * @generated
         */
        protected boolean useLocalCoordinates() {
            return myUseLocalCoordinates;
        }

        /**
         * @generated
         */
        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            myUseLocalCoordinates = useLocalCoordinates;
        }

    }

    @Override
    /**
     * @notgenerated
     */
    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableActivityEditPolicy();
    }

    /**
     * @notgenerated
     * @param activityType
     * @return
     */
    private static int getShapeType(int activityType) {
        int shapeType;
        switch (activityType) {
        case ActivityType.TASK:
            shapeType = SHAPE_RECTANGLE;
            break;
        case ActivityType.GATEWAY_DATA_BASED_EXCLUSIVE:
        case ActivityType.GATEWAY_DATA_BASED_INCLUSIVE:
        case ActivityType.GATEWAY_EVENT_BASED_EXCLUSIVE:
        case ActivityType.GATEWAY_PARALLEL:
            shapeType = SHAPE_DIAMOND;
            break;
        default:
            shapeType = SHAPE_CIRCLE;
        }
        return shapeType;
    }

    /**
     * @notgenerated
     */
    @Override
    public Command getCommand(Request _request) {
        if (_request instanceof CreateUnspecifiedTypeConnectionRequest) {
            Object model = ((CreateUnspecifiedTypeConnectionRequest) _request)
                    .getTargetEditPart().getModel();

            if ((model instanceof Node)) {
                List elTypes = ((CreateUnspecifiedTypeConnectionRequest) _request)
                        .getElementTypes();
                MetamodelType connType = (MetamodelType) BpmnElementTypes.MessagingEdge_3002;

                for (int i = 0; i < elTypes.size(); i++) {
                    if (elTypes.get(i) instanceof MetamodelType) {
                        connType = (MetamodelType) elTypes.get(i);
                        break;
                    }
                }

                if (connType == BpmnElementTypes.MessagingEdge_3002) {
                    // message connection rules for gateways
                    MessageConnectionValidator messageValidator = new MessageConnectionValidator();

                    if (_request instanceof CreateUnspecifiedTypeConnectionRequest) {
                        CreateUnspecifiedTypeConnectionRequest request = (CreateUnspecifiedTypeConnectionRequest) _request;
                        // System.out.println("Reversed = " +
                        // request.isDirectionReversed());
                        if (request.isDirectionReversed()) {
                            // do nothing
                        } else {
                            if ((request.getSourceEditPart() != null)
                                    && (request.getTargetEditPart() != null)) {
                                for (Iterator iter = request.getAllRequests()
                                        .iterator(); iter.hasNext();) {
                                    CreateConnectionRequest connectionRequest = (CreateConnectionRequest) iter
                                            .next();
                                    if (connectionRequest.getSourceEditPart() != null
                                            && connectionRequest
                                                    .getTargetEditPart() != null
                                            && connectionRequest
                                                    .getSourceEditPart() == request
                                                    .getSourceEditPart()
                                            && connectionRequest
                                                    .getTargetEditPart() == request
                                                    .getTargetEditPart()) {
                                        if (!messageValidator.canConnect(
                                                request.getSourceEditPart(),
                                                request.getTargetEditPart())) {
                                            return null;
                                        }
                                    } else {
                                        // the connection is direction reversed
                                        if (!messageValidator.canConnect(
                                                request.getTargetEditPart(),
                                                request.getSourceEditPart())) {
                                            return null;
                                        }
                                    }
                                }
                            }
                            if ((request.getSourceEditPart() == null)
                                    && (request.getTargetEditPart() != null)) {
                                if (!messageValidator.canStart(request
                                        .getTargetEditPart())) {
                                    return null;
                                }
                            }
                        }
                    }
                }

                if (connType == BpmnElementTypes.SequenceEdge_3001) {
                    // edge connection rules
                    EdgeConnectionValidator edgeValidator = new EdgeConnectionValidator();

                    if (_request instanceof CreateUnspecifiedTypeConnectionRequest) {
                        CreateUnspecifiedTypeConnectionRequest request = (CreateUnspecifiedTypeConnectionRequest) _request;
                        // System.out.println("Reversed = " +
                        // request.isDirectionReversed());
                        if (request.isDirectionReversed()) {
                            // do nothing
                        } else {
                            if ((request.getSourceEditPart() != null)
                                    && (request.getTargetEditPart() != null)) {
                                if (request.getSourceEditPart().equals(
                                        request.getTargetEditPart())) {
                                    return null;
                                }
                                for (Iterator iter = request.getAllRequests()
                                        .iterator(); iter.hasNext();) {
                                    CreateConnectionRequest connectionRequest = (CreateConnectionRequest) iter
                                            .next();
                                    if (connectionRequest.getSourceEditPart() != null
                                            && connectionRequest
                                                    .getTargetEditPart() != null
                                            && connectionRequest
                                                    .getSourceEditPart() == request
                                                    .getSourceEditPart()
                                            && connectionRequest
                                                    .getTargetEditPart() == request
                                                    .getTargetEditPart()) {
                                        if (!edgeValidator.canConnect(request
                                                .getSourceEditPart(), request
                                                .getTargetEditPart())) {
                                            return null;
                                        }
                                    } else {
                                        // the connection is direction reversed
                                        if (!edgeValidator.canConnect(request
                                                .getTargetEditPart(), request
                                                .getSourceEditPart())) {
                                            return null;
                                        }
                                    }
                                }
                            }

                            if ((request.getSourceEditPart() == null)
                                    && (request.getTargetEditPart() != null)) {
                                if (!edgeValidator.canStart(request
                                        .getTargetEditPart())) {
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
        }

        return super.getCommand(_request);
    }

    /**
     * @notgenerated
     */
    public boolean isChildAdded() {
        return isChildAdded;
    }

    /**
     * @notgenerated
     */
    public void setChildAdded(boolean isChildAdded) {
        this.isChildAdded = isChildAdded;
    }

    /**
     * @notgenerated
     */
    @Override
    public DragTracker getDragTracker(Request request) {
        return new TaskDragEditPartsTrackerEx(this);
    }

    public int getHandlePosition() {
        return handlePosition;
    }

    public void setHandlePosition(int handlePosition) {
        this.handlePosition = handlePosition;
    }

}
