/*
 *******************************************************************************
 ** Copyright (c) 2006, Intalio Inc.
 ** All rights reserved. This program and the accompanying materials
 ** are made available under the terms of the Eclipse Public License v1.0
 ** which accompanies this distribution, and is available at
 ** http://www.eclipse.org/legal/epl-v10.html
 ** 
 ** Contributors:
 **     Intalio Inc. - initial API and implementation
 ********************************************************************************
 */
package org.eclipse.stp.bpmn.diagram.providers;

import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.stp.bpmn.diagram.actions.ArrangeSelectionAction;
import org.eclipse.stp.bpmn.diagram.actions.GroupAction;
import org.eclipse.stp.bpmn.diagram.actions.GroupActionManager;
import org.eclipse.stp.bpmn.diagram.actions.ResetBendpointsAction;
import org.eclipse.stp.bpmn.diagram.actions.UngroupAction;
import org.eclipse.ui.IWorkbenchPage;

/**
 * @notgenerated add the reset bendpoint action. overrides the Arrange actions.
 * 
 * @author hmalphettes
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class BpmnDiagramActionProvider extends AbstractContributionItemProvider {

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider#createMenuManager(java.lang.String,
     *      org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor)
     */
    protected IMenuManager createMenuManager(String menuId,
            IWorkbenchPartDescriptor partDescriptor) {
        IWorkbenchPage workbenchPage = partDescriptor.getPartPage();

        if (GroupActionManager.MENU_ID.equals(menuId)) {
            return new GroupActionManager(getAction(GroupAction.ACTION_ID,
                    partDescriptor));
        }

        return super.createMenuManager(menuId, partDescriptor);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider#createAction(java.lang.String,
     *      org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor)
     */
    protected IAction createAction(String actionId,
            IWorkbenchPartDescriptor partDescriptor) {

        IWorkbenchPage workbenchPage = partDescriptor.getPartPage();

        if (GroupAction.ACTION_ID.equals(actionId)) {
            return GroupAction.createGroupAction(workbenchPage);
        } else if (GroupAction.TOOLBAR_ACTION_ID.equals(actionId)) {
            return GroupAction.createToolbarGroupAction(workbenchPage);
        } else if (UngroupAction.ACTION_ID.equals(actionId)) {
            return UngroupAction.createUngroupAction(workbenchPage);
        } else if (UngroupAction.TOOLBAR_ACTION_ID.equals(actionId)) {
            return UngroupAction.createToolbarUngroupAction(workbenchPage);
        } else if (actionId.equals(ArrangeSelectionAction.ACTION_ARRANGE_SELECTION)) {
            return ArrangeSelectionAction
                    .createArrangeSelectionAction(workbenchPage);
        } else if (actionId.equals(ArrangeSelectionAction.ACTION_TOOLBAR_ARRANGE_SELECTION)) {
            return ArrangeSelectionAction
                    .createToolbarArrangeSelectionAction(workbenchPage);
        } else if (actionId.equals(ResetBendpointsAction.ACTION_ID)) {
            return ResetBendpointsAction
                    .createResetBendpointsAction(workbenchPage);
        } else if (actionId.equals(ResetBendpointsAction.TOOLBAR_ACTION_ID)) {
            return ResetBendpointsAction
                    .createToolbarResetBendpointsAction(workbenchPage);
        }
        return super.createAction(actionId, partDescriptor);
    }
}
