/******************************************************************************
* Copyright (c) 2006, Intalio Inc.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     Intalio Inc. - initial API and implementation
*******************************************************************************/

package org.eclipse.stp.bpmn;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Sequence Edge</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.stp.bpmn.SequenceEdge#getDocumentation <em>Documentation</em>}</li>
 *   <li>{@link org.eclipse.stp.bpmn.SequenceEdge#getGraph <em>Graph</em>}</li>
 *   <li>{@link org.eclipse.stp.bpmn.SequenceEdge#isIsDefault <em>Is Default</em>}</li>
 *   <li>{@link org.eclipse.stp.bpmn.SequenceEdge#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.stp.bpmn.SequenceEdge#getSource <em>Source</em>}</li>
 *   <li>{@link org.eclipse.stp.bpmn.SequenceEdge#getTarget <em>Target</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.stp.bpmn.BpmnPackage#getSequenceEdge()
 * @model extendedMetaData="name='SequenceEdge' kind='elementOnly'"
 * @generated
 */
public interface SequenceEdge extends Identifiable {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String copyright = "";

    /**
     * Returns the value of the '<em><b>Documentation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Documentation</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Documentation</em>' attribute.
     * @see #setDocumentation(String)
     * @see org.eclipse.stp.bpmn.BpmnPackage#getSequenceEdge_Documentation()
     * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
     *        extendedMetaData="kind='attribute' name='documentation'"
     * @generated
     */
    String getDocumentation();

    /**
     * Sets the value of the '{@link org.eclipse.stp.bpmn.SequenceEdge#getDocumentation <em>Documentation</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Documentation</em>' attribute.
     * @see #getDocumentation()
     * @generated
     */
    void setDocumentation(String value);

    /**
     * Returns the value of the '<em><b>Graph</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.stp.bpmn.Graph#getSequenceEdges <em>Sequence Edges</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Graph</em>' container reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Graph</em>' container reference.
     * @see #setGraph(Graph)
     * @see org.eclipse.stp.bpmn.BpmnPackage#getSequenceEdge_Graph()
     * @see org.eclipse.stp.bpmn.Graph#getSequenceEdges
     * @model opposite="sequenceEdges"
     *        extendedMetaData="kind='attribute' name='graph'"
     * @generated
     */
    Graph getGraph();

    /**
     * Sets the value of the '{@link org.eclipse.stp.bpmn.SequenceEdge#getGraph <em>Graph</em>}' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Graph</em>' container reference.
     * @see #getGraph()
     * @generated
     */
    void setGraph(Graph value);

    /**
     * Returns the value of the '<em><b>Is Default</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Is Default</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Is Default</em>' attribute.
     * @see #isSetIsDefault()
     * @see #unsetIsDefault()
     * @see #setIsDefault(boolean)
     * @see org.eclipse.stp.bpmn.BpmnPackage#getSequenceEdge_IsDefault()
     * @model unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
     *        extendedMetaData="kind='attribute' name='isDefault'"
     * @generated
     */
    boolean isIsDefault();

    /**
     * Sets the value of the '{@link org.eclipse.stp.bpmn.SequenceEdge#isIsDefault <em>Is Default</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Is Default</em>' attribute.
     * @see #isSetIsDefault()
     * @see #unsetIsDefault()
     * @see #isIsDefault()
     * @generated
     */
    void setIsDefault(boolean value);

    /**
     * Unsets the value of the '{@link org.eclipse.stp.bpmn.SequenceEdge#isIsDefault <em>Is Default</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetIsDefault()
     * @see #isIsDefault()
     * @see #setIsDefault(boolean)
     * @generated
     */
    void unsetIsDefault();

    /**
     * Returns whether the value of the '{@link org.eclipse.stp.bpmn.SequenceEdge#isIsDefault <em>Is Default</em>}' attribute is set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Is Default</em>' attribute is set.
     * @see #unsetIsDefault()
     * @see #isIsDefault()
     * @see #setIsDefault(boolean)
     * @generated
     */
    boolean isSetIsDefault();

    /**
     * Returns the value of the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Name</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Name</em>' attribute.
     * @see #setName(String)
     * @see org.eclipse.stp.bpmn.BpmnPackage#getSequenceEdge_Name()
     * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
     *        extendedMetaData="kind='attribute' name='name'"
     * @generated
     */
    String getName();

    /**
     * Sets the value of the '{@link org.eclipse.stp.bpmn.SequenceEdge#getName <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     * @generated
     */
    void setName(String value);

    /**
     * Returns the value of the '<em><b>Source</b></em>' reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.stp.bpmn.Vertex#getOutgoingEdges <em>Outgoing Edges</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Source</em>' reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Source</em>' reference.
     * @see #setSource(Vertex)
     * @see org.eclipse.stp.bpmn.BpmnPackage#getSequenceEdge_Source()
     * @see org.eclipse.stp.bpmn.Vertex#getOutgoingEdges
     * @model opposite="outgoingEdges"
     *        extendedMetaData="kind='attribute' name='source'"
     * @generated
     */
    Vertex getSource();

    /**
     * Sets the value of the '{@link org.eclipse.stp.bpmn.SequenceEdge#getSource <em>Source</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Source</em>' reference.
     * @see #getSource()
     * @generated
     */
    void setSource(Vertex value);

    /**
     * Returns the value of the '<em><b>Target</b></em>' reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.stp.bpmn.Vertex#getIncomingEdges <em>Incoming Edges</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Target</em>' reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Target</em>' reference.
     * @see #setTarget(Vertex)
     * @see org.eclipse.stp.bpmn.BpmnPackage#getSequenceEdge_Target()
     * @see org.eclipse.stp.bpmn.Vertex#getIncomingEdges
     * @model opposite="incomingEdges"
     *        extendedMetaData="kind='attribute' name='target'"
     * @generated
     */
    Vertex getTarget();

    /**
     * Sets the value of the '{@link org.eclipse.stp.bpmn.SequenceEdge#getTarget <em>Target</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Target</em>' reference.
     * @see #getTarget()
     * @generated
     */
    void setTarget(Vertex value);

} // SequenceEdge