/******************************************************************************
* Copyright (c) 2006, Intalio Inc.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     Intalio Inc. - initial API and implementation
*******************************************************************************/

package org.eclipse.stp.bpmn.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Graph</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.stp.bpmn.impl.GraphImpl#getVertices <em>Vertices</em>}</li>
 *   <li>{@link org.eclipse.stp.bpmn.impl.GraphImpl#getSequenceEdges <em>Sequence Edges</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class GraphImpl extends IdentifiableImpl implements Graph {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "";

    /**
     * The cached value of the '{@link #getVertices() <em>Vertices</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getVertices()
     * @generated
     * @ordered
     */
    protected EList vertices = null;

    /**
     * The cached value of the '{@link #getSequenceEdges() <em>Sequence Edges</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSequenceEdges()
     * @generated
     * @ordered
     */
    protected EList sequenceEdges = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GraphImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return BpmnPackage.Literals.GRAPH;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getVertices() {
        if (vertices == null) {
            vertices = new EObjectContainmentWithInverseEList(Vertex.class, this, BpmnPackage.GRAPH__VERTICES, BpmnPackage.VERTEX__GRAPH);
        }
        return vertices;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getSequenceEdges() {
        if (sequenceEdges == null) {
            sequenceEdges = new EObjectContainmentWithInverseEList(SequenceEdge.class, this, BpmnPackage.GRAPH__SEQUENCE_EDGES, BpmnPackage.SEQUENCE_EDGE__GRAPH);
        }
        return sequenceEdges;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case BpmnPackage.GRAPH__VERTICES:
                return ((InternalEList)getVertices()).basicAdd(otherEnd, msgs);
            case BpmnPackage.GRAPH__SEQUENCE_EDGES:
                return ((InternalEList)getSequenceEdges()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case BpmnPackage.GRAPH__VERTICES:
                return ((InternalEList)getVertices()).basicRemove(otherEnd, msgs);
            case BpmnPackage.GRAPH__SEQUENCE_EDGES:
                return ((InternalEList)getSequenceEdges()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case BpmnPackage.GRAPH__VERTICES:
                return getVertices();
            case BpmnPackage.GRAPH__SEQUENCE_EDGES:
                return getSequenceEdges();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case BpmnPackage.GRAPH__VERTICES:
                getVertices().clear();
                getVertices().addAll((Collection)newValue);
                return;
            case BpmnPackage.GRAPH__SEQUENCE_EDGES:
                getSequenceEdges().clear();
                getSequenceEdges().addAll((Collection)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(int featureID) {
        switch (featureID) {
            case BpmnPackage.GRAPH__VERTICES:
                getVertices().clear();
                return;
            case BpmnPackage.GRAPH__SEQUENCE_EDGES:
                getSequenceEdges().clear();
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case BpmnPackage.GRAPH__VERTICES:
                return vertices != null && !vertices.isEmpty();
            case BpmnPackage.GRAPH__SEQUENCE_EDGES:
                return sequenceEdges != null && !sequenceEdges.isEmpty();
        }
        return super.eIsSet(featureID);
    }

} //GraphImpl