/******************************************************************************
* Copyright (c) 2006, Intalio Inc.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     Intalio Inc. - initial API and implementation
*******************************************************************************/

package org.eclipse.stp.bpmn.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.stp.bpmn.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.stp.bpmn.BpmnPackage
 * @generated
 */
public class BpmnSwitch {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "";

    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static BpmnPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public BpmnSwitch() {
        if (modelPackage == null) {
            modelPackage = BpmnPackage.eINSTANCE;
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    public Object doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    protected Object doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch((EClass)eSuperTypes.get(0), theEObject);
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    protected Object doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case BpmnPackage.ACTIVITY: {
                Activity activity = (Activity)theEObject;
                Object result = caseActivity(activity);
                if (result == null) result = caseVertex(activity);
                if (result == null) result = caseIdentifiable(activity);
                if (result == null) result = caseEModelElement(activity);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.BPMN_DIAGRAM: {
                BpmnDiagram bpmnDiagram = (BpmnDiagram)theEObject;
                Object result = caseBpmnDiagram(bpmnDiagram);
                if (result == null) result = caseIdentifiable(bpmnDiagram);
                if (result == null) result = caseEModelElement(bpmnDiagram);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.GRAPH: {
                Graph graph = (Graph)theEObject;
                Object result = caseGraph(graph);
                if (result == null) result = caseIdentifiable(graph);
                if (result == null) result = caseEModelElement(graph);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.IDENTIFIABLE: {
                Identifiable identifiable = (Identifiable)theEObject;
                Object result = caseIdentifiable(identifiable);
                if (result == null) result = caseEModelElement(identifiable);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.LANE: {
                Lane lane = (Lane)theEObject;
                Object result = caseLane(lane);
                if (result == null) result = caseIdentifiable(lane);
                if (result == null) result = caseEModelElement(lane);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.MESSAGING_EDGE: {
                MessagingEdge messagingEdge = (MessagingEdge)theEObject;
                Object result = caseMessagingEdge(messagingEdge);
                if (result == null) result = caseIdentifiable(messagingEdge);
                if (result == null) result = caseEModelElement(messagingEdge);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.POOL: {
                Pool pool = (Pool)theEObject;
                Object result = casePool(pool);
                if (result == null) result = caseGraph(pool);
                if (result == null) result = caseIdentifiable(pool);
                if (result == null) result = caseEModelElement(pool);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.SEQUENCE_EDGE: {
                SequenceEdge sequenceEdge = (SequenceEdge)theEObject;
                Object result = caseSequenceEdge(sequenceEdge);
                if (result == null) result = caseIdentifiable(sequenceEdge);
                if (result == null) result = caseEModelElement(sequenceEdge);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.SUB_PROCESS: {
                SubProcess subProcess = (SubProcess)theEObject;
                Object result = caseSubProcess(subProcess);
                if (result == null) result = caseActivity(subProcess);
                if (result == null) result = caseGraph(subProcess);
                if (result == null) result = caseVertex(subProcess);
                if (result == null) result = caseIdentifiable(subProcess);
                if (result == null) result = caseEModelElement(subProcess);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case BpmnPackage.VERTEX: {
                Vertex vertex = (Vertex)theEObject;
                Object result = caseVertex(vertex);
                if (result == null) result = caseIdentifiable(vertex);
                if (result == null) result = caseEModelElement(vertex);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Activity</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Activity</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseActivity(Activity object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Diagram</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Diagram</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseBpmnDiagram(BpmnDiagram object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Graph</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Graph</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseGraph(Graph object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Identifiable</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Identifiable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseIdentifiable(Identifiable object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Lane</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Lane</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseLane(Lane object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Messaging Edge</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Messaging Edge</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseMessagingEdge(MessagingEdge object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Pool</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Pool</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object casePool(Pool object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Sequence Edge</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Sequence Edge</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseSequenceEdge(SequenceEdge object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Sub Process</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Sub Process</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseSubProcess(SubProcess object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Vertex</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Vertex</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseVertex(Vertex object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>EModel Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>EModel Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseEModelElement(EModelElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    public Object defaultCase(EObject object) {
        return null;
    }

} //BpmnSwitch
