/******************************************************************************
* Copyright (c) 2006, Intalio Inc.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     Intalio Inc. - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.MessagingEdge;

/**
 * Constraint on message events, stating that they should be the target
 * of a messaging edge.
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class MessageEventConstraint extends AbstractModelConstraint {

	@Override
	public IStatus validate(IValidationContext ctx) {
		if (ctx.getTarget() instanceof Activity) {
			Activity act = (Activity) ctx.getTarget();
			if (act.getActivityType().getValue() ==
				(ActivityType.EVENT_INTERMEDIATE_MESSAGE)) {
				boolean foundIncomingMessage = false;
				for (Object edge : act.getIncomingEdges()){
					if (edge instanceof MessagingEdge) {
						foundIncomingMessage = true;
					}
				}
				if (!foundIncomingMessage) {
					return ctx.createFailureStatus(new Object[] {
							act.getName() == null ? "" : " named " + act.getName()});
				}
			}
		}
		return ctx.createSuccessStatus();
	}

}
