/******************************************************************************
* Copyright (c) 2006, Intalio Inc.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     Intalio Inc. - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.MessagingEdge;

/**
 * Messaging edges constraints computed from the BPMN specification.
 * See BPMN 1.0 paragraph 8.4.2
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class MessagingEdgeConstraint extends AbstractModelConstraint {

	@Override
	public IStatus validate(IValidationContext ctx) {
		if (ctx.getTarget() instanceof MessagingEdge) {
			if (ctx.getFeature() == null || // batch mode
					ctx.getFeature(). // live mode
						getFeatureID() == BpmnPackage.MESSAGING_EDGE) {
				MessagingEdge edge = (MessagingEdge) ctx.getTarget();
				Activity source = edge.getSource();
				Activity target = edge.getTarget();
				switch (source.getActivityType().getValue()) {
				case ActivityType.EVENT_END_COMPENSATION:
				case ActivityType.EVENT_END_EMPTY:
				case ActivityType.EVENT_END_ERROR:
				case ActivityType.EVENT_END_MESSAGE:
				case ActivityType.EVENT_END_TERMINATE:
					return ctx.createFailureStatus(new Object[]{
				"End event should not be the start point of a messaging edge",
					});
				case ActivityType.EVENT_INTERMEDIATE_COMPENSATION:
				case ActivityType.EVENT_INTERMEDIATE_EMPTY:
				case ActivityType.EVENT_INTERMEDIATE_ERROR:
				case ActivityType.EVENT_INTERMEDIATE_MESSAGE:
				case ActivityType.EVENT_INTERMEDIATE_RULE:
				case ActivityType.EVENT_INTERMEDIATE_TIMER:
					return ctx.createFailureStatus(new Object[]{
				"Intermediate event should not be the start point of a " +
				"messaging edge"});
				case ActivityType.EVENT_START_EMPTY:
				case ActivityType.EVENT_START_MESSAGE:
				case ActivityType.EVENT_START_RULE:
					return ctx.createFailureStatus(new Object[]{
				"Start event should not be the start point of a messaging edge",
					});
					
				}

				switch (target.getActivityType().getValue()) {	
				case ActivityType.EVENT_END_COMPENSATION:
				case ActivityType.EVENT_END_EMPTY:
				case ActivityType.EVENT_END_ERROR:
				case ActivityType.EVENT_END_MESSAGE:
				case ActivityType.EVENT_END_TERMINATE:
					return ctx.createFailureStatus(new Object[]{
				"End event should not be the end point of a messaging edge"
					});
				case ActivityType.EVENT_INTERMEDIATE_COMPENSATION:
				case ActivityType.EVENT_INTERMEDIATE_EMPTY:
				case ActivityType.EVENT_INTERMEDIATE_ERROR:
				case ActivityType.EVENT_INTERMEDIATE_MESSAGE:
				case ActivityType.EVENT_INTERMEDIATE_RULE:
				case ActivityType.EVENT_INTERMEDIATE_TIMER:
					return ctx.createFailureStatus(new Object[]{
				"Intermediate event should not be the end point of a " +
				"messaging edge"});
				case ActivityType.EVENT_START_EMPTY:
				case ActivityType.EVENT_START_MESSAGE:
				case ActivityType.EVENT_START_RULE:
					return ctx.createFailureStatus(new Object[]{
				"Start event should not be the end point of a messaging edge"});
				}
			}
			
		}
		return ctx.createSuccessStatus();
	}

}
