/******************************************************************************
* Copyright (c) 2006, Intalio Inc.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     Intalio Inc. - initial API and implementation
*******************************************************************************/

package org.eclipse.stp.bpmn.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnFactory;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.Vertex;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class BpmnPackageImpl extends EPackageImpl implements BpmnPackage {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "";

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass activityEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass bpmnDiagramEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass graphEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass identifiableEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass laneEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass messagingEdgeEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass poolEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass sequenceEdgeEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass subProcessEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass vertexEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EEnum activityTypeEEnum = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EDataType activityTypeObjectEDataType = null;

    /**
     * Creates an instance of the model <b>Package</b>, registered with
     * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
     * package URI value.
     * <p>Note: the correct way to create the package is via the static
     * factory method {@link #init init()}, which also performs
     * initialization of the package, or returns the registered package,
     * if one already exists.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.ecore.EPackage.Registry
     * @see org.eclipse.stp.bpmn.BpmnPackage#eNS_URI
     * @see #init()
     * @generated
     */
    private BpmnPackageImpl() {
        super(eNS_URI, BpmnFactory.eINSTANCE);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private static boolean isInited = false;

    /**
     * Creates, registers, and initializes the <b>Package</b> for this
     * model, and for any others upon which it depends.  Simple
     * dependencies are satisfied by calling this method on all
     * dependent packages before doing anything else.  This method drives
     * initialization for interdependent packages directly, in parallel
     * with this package, itself.
     * <p>Of this package and its interdependencies, all packages which
     * have not yet been registered by their URI values are first created
     * and registered.  The packages are then initialized in two steps:
     * meta-model objects for all of the packages are created before any
     * are initialized, since one package's meta-model objects may refer to
     * those of another.
     * <p>Invocation of this method will not affect any packages that have
     * already been initialized.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #eNS_URI
     * @see #createPackageContents()
     * @see #initializePackageContents()
     * @generated
     */
    public static BpmnPackage init() {
        if (isInited) return (BpmnPackage)EPackage.Registry.INSTANCE.getEPackage(BpmnPackage.eNS_URI);

        // Obtain or create and register package
        BpmnPackageImpl theBpmnPackage = (BpmnPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof BpmnPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new BpmnPackageImpl());

        isInited = true;

        // Initialize simple dependencies
        EcorePackage.eINSTANCE.eClass();
        XMLTypePackage.eINSTANCE.eClass();

        // Create package meta-data objects
        theBpmnPackage.createPackageContents();

        // Initialize created meta-data
        theBpmnPackage.initializePackageContents();

        // Mark meta-data to indicate it can't be changed
        theBpmnPackage.freeze();

        return theBpmnPackage;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getActivity() {
        return activityEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getActivity_IncomingMessages() {
        return (EReference)activityEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getActivity_OutgoingMessages() {
        return (EReference)activityEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getActivity_OrderedMessages() {
        return (EReference)activityEClass.getEStructuralFeatures().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getActivity_ActivityType() {
        return (EAttribute)activityEClass.getEStructuralFeatures().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getActivity_Documentation() {
        return (EAttribute)activityEClass.getEStructuralFeatures().get(4);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getActivity_EventHandlerFor() {
        return (EReference)activityEClass.getEStructuralFeatures().get(5);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getActivity_Lane() {
        return (EReference)activityEClass.getEStructuralFeatures().get(6);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getActivity_Looping() {
        return (EAttribute)activityEClass.getEStructuralFeatures().get(7);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getActivity_Name() {
        return (EAttribute)activityEClass.getEStructuralFeatures().get(8);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getBpmnDiagram() {
        return bpmnDiagramEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getBpmnDiagram_Pools() {
        return (EReference)bpmnDiagramEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getBpmnDiagram_Messages() {
        return (EReference)bpmnDiagramEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getBpmnDiagram_Author() {
        return (EAttribute)bpmnDiagramEClass.getEStructuralFeatures().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getBpmnDiagram_Documentation() {
        return (EAttribute)bpmnDiagramEClass.getEStructuralFeatures().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getBpmnDiagram_Name() {
        return (EAttribute)bpmnDiagramEClass.getEStructuralFeatures().get(4);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getBpmnDiagram_Title() {
        return (EAttribute)bpmnDiagramEClass.getEStructuralFeatures().get(5);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getGraph() {
        return graphEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getGraph_Vertices() {
        return (EReference)graphEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getGraph_SequenceEdges() {
        return (EReference)graphEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getIdentifiable() {
        return identifiableEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getIdentifiable_ID() {
        return (EAttribute)identifiableEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getLane() {
        return laneEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getLane_Activities() {
        return (EReference)laneEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getLane_Documentation() {
        return (EAttribute)laneEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getLane_Name() {
        return (EAttribute)laneEClass.getEStructuralFeatures().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getLane_Pool() {
        return (EReference)laneEClass.getEStructuralFeatures().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getMessagingEdge() {
        return messagingEdgeEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getMessagingEdge_BpmnDiagram() {
        return (EReference)messagingEdgeEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMessagingEdge_Documentation() {
        return (EAttribute)messagingEdgeEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMessagingEdge_Name() {
        return (EAttribute)messagingEdgeEClass.getEStructuralFeatures().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getMessagingEdge_Source() {
        return (EReference)messagingEdgeEClass.getEStructuralFeatures().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getMessagingEdge_Target() {
        return (EReference)messagingEdgeEClass.getEStructuralFeatures().get(4);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getPool() {
        return poolEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getPool_Lanes() {
        return (EReference)poolEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getPool_BpmnDiagram() {
        return (EReference)poolEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getPool_Documentation() {
        return (EAttribute)poolEClass.getEStructuralFeatures().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getPool_Name() {
        return (EAttribute)poolEClass.getEStructuralFeatures().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getSequenceEdge() {
        return sequenceEdgeEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getSequenceEdge_Documentation() {
        return (EAttribute)sequenceEdgeEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getSequenceEdge_Graph() {
        return (EReference)sequenceEdgeEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getSequenceEdge_IsDefault() {
        return (EAttribute)sequenceEdgeEClass.getEStructuralFeatures().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getSequenceEdge_Name() {
        return (EAttribute)sequenceEdgeEClass.getEStructuralFeatures().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getSequenceEdge_Source() {
        return (EReference)sequenceEdgeEClass.getEStructuralFeatures().get(4);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getSequenceEdge_Target() {
        return (EReference)sequenceEdgeEClass.getEStructuralFeatures().get(5);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getSubProcess() {
        return subProcessEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getSubProcess_EventHandlers() {
        return (EReference)subProcessEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getSubProcess_IsTransaction() {
        return (EAttribute)subProcessEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getVertex() {
        return vertexEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getVertex_OutgoingEdges() {
        return (EReference)vertexEClass.getEStructuralFeatures().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getVertex_IncomingEdges() {
        return (EReference)vertexEClass.getEStructuralFeatures().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getVertex_Graph() {
        return (EReference)vertexEClass.getEStructuralFeatures().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EEnum getActivityType() {
        return activityTypeEEnum;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EDataType getActivityTypeObject() {
        return activityTypeObjectEDataType;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public BpmnFactory getBpmnFactory() {
        return (BpmnFactory)getEFactoryInstance();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private boolean isCreated = false;

    /**
     * Creates the meta-model objects for the package.  This method is
     * guarded to have no affect on any invocation but its first.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void createPackageContents() {
        if (isCreated) return;
        isCreated = true;

        // Create classes and their features
        activityEClass = createEClass(ACTIVITY);
        createEReference(activityEClass, ACTIVITY__INCOMING_MESSAGES);
        createEReference(activityEClass, ACTIVITY__OUTGOING_MESSAGES);
        createEReference(activityEClass, ACTIVITY__ORDERED_MESSAGES);
        createEAttribute(activityEClass, ACTIVITY__ACTIVITY_TYPE);
        createEAttribute(activityEClass, ACTIVITY__DOCUMENTATION);
        createEReference(activityEClass, ACTIVITY__EVENT_HANDLER_FOR);
        createEReference(activityEClass, ACTIVITY__LANE);
        createEAttribute(activityEClass, ACTIVITY__LOOPING);
        createEAttribute(activityEClass, ACTIVITY__NAME);

        bpmnDiagramEClass = createEClass(BPMN_DIAGRAM);
        createEReference(bpmnDiagramEClass, BPMN_DIAGRAM__POOLS);
        createEReference(bpmnDiagramEClass, BPMN_DIAGRAM__MESSAGES);
        createEAttribute(bpmnDiagramEClass, BPMN_DIAGRAM__AUTHOR);
        createEAttribute(bpmnDiagramEClass, BPMN_DIAGRAM__DOCUMENTATION);
        createEAttribute(bpmnDiagramEClass, BPMN_DIAGRAM__NAME);
        createEAttribute(bpmnDiagramEClass, BPMN_DIAGRAM__TITLE);

        graphEClass = createEClass(GRAPH);
        createEReference(graphEClass, GRAPH__VERTICES);
        createEReference(graphEClass, GRAPH__SEQUENCE_EDGES);

        identifiableEClass = createEClass(IDENTIFIABLE);
        createEAttribute(identifiableEClass, IDENTIFIABLE__ID);

        laneEClass = createEClass(LANE);
        createEReference(laneEClass, LANE__ACTIVITIES);
        createEAttribute(laneEClass, LANE__DOCUMENTATION);
        createEAttribute(laneEClass, LANE__NAME);
        createEReference(laneEClass, LANE__POOL);

        messagingEdgeEClass = createEClass(MESSAGING_EDGE);
        createEReference(messagingEdgeEClass, MESSAGING_EDGE__BPMN_DIAGRAM);
        createEAttribute(messagingEdgeEClass, MESSAGING_EDGE__DOCUMENTATION);
        createEAttribute(messagingEdgeEClass, MESSAGING_EDGE__NAME);
        createEReference(messagingEdgeEClass, MESSAGING_EDGE__SOURCE);
        createEReference(messagingEdgeEClass, MESSAGING_EDGE__TARGET);

        poolEClass = createEClass(POOL);
        createEReference(poolEClass, POOL__LANES);
        createEReference(poolEClass, POOL__BPMN_DIAGRAM);
        createEAttribute(poolEClass, POOL__DOCUMENTATION);
        createEAttribute(poolEClass, POOL__NAME);

        sequenceEdgeEClass = createEClass(SEQUENCE_EDGE);
        createEAttribute(sequenceEdgeEClass, SEQUENCE_EDGE__DOCUMENTATION);
        createEReference(sequenceEdgeEClass, SEQUENCE_EDGE__GRAPH);
        createEAttribute(sequenceEdgeEClass, SEQUENCE_EDGE__IS_DEFAULT);
        createEAttribute(sequenceEdgeEClass, SEQUENCE_EDGE__NAME);
        createEReference(sequenceEdgeEClass, SEQUENCE_EDGE__SOURCE);
        createEReference(sequenceEdgeEClass, SEQUENCE_EDGE__TARGET);

        subProcessEClass = createEClass(SUB_PROCESS);
        createEReference(subProcessEClass, SUB_PROCESS__EVENT_HANDLERS);
        createEAttribute(subProcessEClass, SUB_PROCESS__IS_TRANSACTION);

        vertexEClass = createEClass(VERTEX);
        createEReference(vertexEClass, VERTEX__OUTGOING_EDGES);
        createEReference(vertexEClass, VERTEX__INCOMING_EDGES);
        createEReference(vertexEClass, VERTEX__GRAPH);

        // Create enums
        activityTypeEEnum = createEEnum(ACTIVITY_TYPE);

        // Create data types
        activityTypeObjectEDataType = createEDataType(ACTIVITY_TYPE_OBJECT);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private boolean isInitialized = false;

    /**
     * Complete the initialization of the package and its meta-model.  This
     * method is guarded to have no affect on any invocation but its first.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void initializePackageContents() {
        if (isInitialized) return;
        isInitialized = true;

        // Initialize package
        setName(eNAME);
        setNsPrefix(eNS_PREFIX);
        setNsURI(eNS_URI);

        // Obtain other dependent packages
        XMLTypePackage theXMLTypePackage = (XMLTypePackage)EPackage.Registry.INSTANCE.getEPackage(XMLTypePackage.eNS_URI);
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);

        // Add supertypes to classes
        activityEClass.getESuperTypes().add(this.getVertex());
        bpmnDiagramEClass.getESuperTypes().add(this.getIdentifiable());
        graphEClass.getESuperTypes().add(this.getIdentifiable());
        identifiableEClass.getESuperTypes().add(theEcorePackage.getEModelElement());
        laneEClass.getESuperTypes().add(this.getIdentifiable());
        messagingEdgeEClass.getESuperTypes().add(this.getIdentifiable());
        poolEClass.getESuperTypes().add(this.getGraph());
        sequenceEdgeEClass.getESuperTypes().add(this.getIdentifiable());
        subProcessEClass.getESuperTypes().add(this.getActivity());
        subProcessEClass.getESuperTypes().add(this.getGraph());
        vertexEClass.getESuperTypes().add(this.getIdentifiable());

        // Initialize classes and features; add operations and parameters
        initEClass(activityEClass, Activity.class, "Activity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEReference(getActivity_IncomingMessages(), this.getMessagingEdge(), this.getMessagingEdge_Target(), "incomingMessages", null, 0, -1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getActivity_OutgoingMessages(), this.getMessagingEdge(), this.getMessagingEdge_Source(), "outgoingMessages", null, 0, -1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getActivity_OrderedMessages(), this.getMessagingEdge(), null, "orderedMessages", null, 0, -1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getActivity_ActivityType(), this.getActivityType(), "activityType", "Task", 0, 1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getActivity_Documentation(), theXMLTypePackage.getString(), "documentation", null, 0, 1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getActivity_EventHandlerFor(), this.getSubProcess(), this.getSubProcess_EventHandlers(), "eventHandlerFor", null, 0, 1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getActivity_Lane(), this.getLane(), this.getLane_Activities(), "lane", null, 0, 1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getActivity_Looping(), theXMLTypePackage.getBoolean(), "looping", null, 0, 1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getActivity_Name(), theXMLTypePackage.getString(), "name", null, 0, 1, Activity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(bpmnDiagramEClass, BpmnDiagram.class, "BpmnDiagram", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEReference(getBpmnDiagram_Pools(), this.getPool(), this.getPool_BpmnDiagram(), "pools", null, 0, -1, BpmnDiagram.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getBpmnDiagram_Messages(), this.getMessagingEdge(), this.getMessagingEdge_BpmnDiagram(), "messages", null, 0, -1, BpmnDiagram.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getBpmnDiagram_Author(), theXMLTypePackage.getString(), "author", null, 0, 1, BpmnDiagram.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getBpmnDiagram_Documentation(), theXMLTypePackage.getString(), "documentation", null, 0, 1, BpmnDiagram.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getBpmnDiagram_Name(), theXMLTypePackage.getString(), "name", null, 0, 1, BpmnDiagram.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getBpmnDiagram_Title(), theXMLTypePackage.getString(), "title", null, 0, 1, BpmnDiagram.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(graphEClass, Graph.class, "Graph", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEReference(getGraph_Vertices(), this.getVertex(), this.getVertex_Graph(), "vertices", null, 0, -1, Graph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getGraph_SequenceEdges(), this.getSequenceEdge(), this.getSequenceEdge_Graph(), "sequenceEdges", null, 0, -1, Graph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(identifiableEClass, Identifiable.class, "Identifiable", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEAttribute(getIdentifiable_ID(), theXMLTypePackage.getID(), "iD", null, 0, 1, Identifiable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(laneEClass, Lane.class, "Lane", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEReference(getLane_Activities(), this.getActivity(), this.getActivity_Lane(), "activities", null, 0, -1, Lane.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getLane_Documentation(), theXMLTypePackage.getString(), "documentation", null, 0, 1, Lane.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getLane_Name(), theXMLTypePackage.getString(), "name", null, 0, 1, Lane.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getLane_Pool(), this.getPool(), this.getPool_Lanes(), "pool", null, 0, 1, Lane.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(messagingEdgeEClass, MessagingEdge.class, "MessagingEdge", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEReference(getMessagingEdge_BpmnDiagram(), this.getBpmnDiagram(), this.getBpmnDiagram_Messages(), "bpmnDiagram", null, 0, 1, MessagingEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getMessagingEdge_Documentation(), theXMLTypePackage.getString(), "documentation", null, 0, 1, MessagingEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getMessagingEdge_Name(), theXMLTypePackage.getString(), "name", null, 0, 1, MessagingEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getMessagingEdge_Source(), this.getActivity(), this.getActivity_OutgoingMessages(), "source", null, 0, 1, MessagingEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getMessagingEdge_Target(), this.getActivity(), this.getActivity_IncomingMessages(), "target", null, 0, 1, MessagingEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(poolEClass, Pool.class, "Pool", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEReference(getPool_Lanes(), this.getLane(), this.getLane_Pool(), "lanes", null, 0, -1, Pool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getPool_BpmnDiagram(), this.getBpmnDiagram(), this.getBpmnDiagram_Pools(), "bpmnDiagram", null, 0, 1, Pool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getPool_Documentation(), theXMLTypePackage.getString(), "documentation", null, 0, 1, Pool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getPool_Name(), theXMLTypePackage.getString(), "name", null, 0, 1, Pool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(sequenceEdgeEClass, SequenceEdge.class, "SequenceEdge", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEAttribute(getSequenceEdge_Documentation(), theXMLTypePackage.getString(), "documentation", null, 0, 1, SequenceEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getSequenceEdge_Graph(), this.getGraph(), this.getGraph_SequenceEdges(), "graph", null, 0, 1, SequenceEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getSequenceEdge_IsDefault(), theXMLTypePackage.getBoolean(), "isDefault", null, 0, 1, SequenceEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getSequenceEdge_Name(), theXMLTypePackage.getString(), "name", null, 0, 1, SequenceEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getSequenceEdge_Source(), this.getVertex(), this.getVertex_OutgoingEdges(), "source", null, 0, 1, SequenceEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getSequenceEdge_Target(), this.getVertex(), this.getVertex_IncomingEdges(), "target", null, 0, 1, SequenceEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(subProcessEClass, SubProcess.class, "SubProcess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEReference(getSubProcess_EventHandlers(), this.getActivity(), this.getActivity_EventHandlerFor(), "eventHandlers", null, 0, -1, SubProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEAttribute(getSubProcess_IsTransaction(), theXMLTypePackage.getBoolean(), "isTransaction", null, 0, 1, SubProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        initEClass(vertexEClass, Vertex.class, "Vertex", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
        initEReference(getVertex_OutgoingEdges(), this.getSequenceEdge(), this.getSequenceEdge_Source(), "outgoingEdges", null, 0, -1, Vertex.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getVertex_IncomingEdges(), this.getSequenceEdge(), this.getSequenceEdge_Target(), "incomingEdges", null, 0, -1, Vertex.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
        initEReference(getVertex_Graph(), this.getGraph(), this.getGraph_Vertices(), "graph", null, 0, 1, Vertex.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

        // Initialize enums and add enum literals
        initEEnum(activityTypeEEnum, ActivityType.class, "ActivityType");
        addEEnumLiteral(activityTypeEEnum, ActivityType.TASK_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.SUB_PROCESS_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_START_EMPTY_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_START_MESSAGE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_START_RULE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_INTERMEDIATE_EMPTY_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_INTERMEDIATE_MESSAGE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_INTERMEDIATE_TIMER_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_INTERMEDIATE_ERROR_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_INTERMEDIATE_COMPENSATION_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_INTERMEDIATE_RULE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_END_EMPTY_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_END_MESSAGE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_END_ERROR_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_END_COMPENSATION_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.EVENT_END_TERMINATE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.GATEWAY_DATA_BASED_EXCLUSIVE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.GATEWAY_EVENT_BASED_EXCLUSIVE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.GATEWAY_DATA_BASED_INCLUSIVE_LITERAL);
        addEEnumLiteral(activityTypeEEnum, ActivityType.GATEWAY_PARALLEL_LITERAL);

        // Initialize data types
        initEDataType(activityTypeObjectEDataType, ActivityType.class, "ActivityTypeObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS);

        // Create resource
        createResource(eNS_URI);

        // Create annotations
        // http:///org/eclipse/emf/ecore/util/ExtendedMetaData
        createExtendedMetaDataAnnotations();
    }

    /**
     * Initializes the annotations for <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected void createExtendedMetaDataAnnotations() {
        String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";		
        addAnnotation
          (activityEClass, 
           source, 
           new String[] {
             "name", "Activity",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getActivity_IncomingMessages(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "incomingMessages"
           });		
        addAnnotation
          (getActivity_OutgoingMessages(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "outgoingMessages"
           });		
        addAnnotation
          (getActivity_OrderedMessages(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "orderedMessages"
           });		
        addAnnotation
          (getActivity_ActivityType(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "activityType"
           });		
        addAnnotation
          (getActivity_Documentation(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "documentation"
           });		
        addAnnotation
          (getActivity_EventHandlerFor(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "eventHandlerFor"
           });		
        addAnnotation
          (getActivity_Lane(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "lane"
           });		
        addAnnotation
          (getActivity_Looping(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "looping"
           });		
        addAnnotation
          (getActivity_Name(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "name"
           });		
        addAnnotation
          (activityTypeEEnum, 
           source, 
           new String[] {
             "name", "ActivityType"
           });		
        addAnnotation
          (activityTypeObjectEDataType, 
           source, 
           new String[] {
             "name", "ActivityType:Object",
             "baseType", "ActivityType"
           });		
        addAnnotation
          (bpmnDiagramEClass, 
           source, 
           new String[] {
             "name", "BpmnDiagram",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getBpmnDiagram_Pools(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "pools"
           });		
        addAnnotation
          (getBpmnDiagram_Messages(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "messages"
           });		
        addAnnotation
          (getBpmnDiagram_Author(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "author"
           });		
        addAnnotation
          (getBpmnDiagram_Documentation(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "documentation"
           });		
        addAnnotation
          (getBpmnDiagram_Name(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "name"
           });		
        addAnnotation
          (getBpmnDiagram_Title(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "title"
           });		
        addAnnotation
          (graphEClass, 
           source, 
           new String[] {
             "name", "Graph",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getGraph_Vertices(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "vertices"
           });		
        addAnnotation
          (getGraph_SequenceEdges(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "sequenceEdges"
           });		
        addAnnotation
          (identifiableEClass, 
           source, 
           new String[] {
             "name", "Identifiable",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getIdentifiable_ID(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "ID"
           });		
        addAnnotation
          (laneEClass, 
           source, 
           new String[] {
             "name", "Lane",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getLane_Activities(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "activities"
           });		
        addAnnotation
          (getLane_Documentation(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "documentation"
           });		
        addAnnotation
          (getLane_Name(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "name"
           });		
        addAnnotation
          (getLane_Pool(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "pool"
           });		
        addAnnotation
          (messagingEdgeEClass, 
           source, 
           new String[] {
             "name", "MessagingEdge",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getMessagingEdge_BpmnDiagram(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "bpmnDiagram"
           });		
        addAnnotation
          (getMessagingEdge_Documentation(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "documentation"
           });		
        addAnnotation
          (getMessagingEdge_Name(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "name"
           });		
        addAnnotation
          (getMessagingEdge_Source(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "source"
           });		
        addAnnotation
          (getMessagingEdge_Target(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "target"
           });		
        addAnnotation
          (poolEClass, 
           source, 
           new String[] {
             "name", "Pool",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getPool_Lanes(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "lanes"
           });		
        addAnnotation
          (getPool_BpmnDiagram(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "bpmnDiagram"
           });		
        addAnnotation
          (getPool_Documentation(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "documentation"
           });		
        addAnnotation
          (getPool_Name(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "name"
           });		
        addAnnotation
          (sequenceEdgeEClass, 
           source, 
           new String[] {
             "name", "SequenceEdge",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getSequenceEdge_Documentation(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "documentation"
           });		
        addAnnotation
          (getSequenceEdge_Graph(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "graph"
           });		
        addAnnotation
          (getSequenceEdge_IsDefault(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "isDefault"
           });		
        addAnnotation
          (getSequenceEdge_Name(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "name"
           });		
        addAnnotation
          (getSequenceEdge_Source(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "source"
           });		
        addAnnotation
          (getSequenceEdge_Target(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "target"
           });		
        addAnnotation
          (subProcessEClass, 
           source, 
           new String[] {
             "name", "SubProcess",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getSubProcess_EventHandlers(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "eventHandlers"
           });		
        addAnnotation
          (getSubProcess_IsTransaction(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "isTransaction"
           });		
        addAnnotation
          (vertexEClass, 
           source, 
           new String[] {
             "name", "Vertex",
             "kind", "elementOnly"
           });		
        addAnnotation
          (getVertex_OutgoingEdges(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "outgoingEdges"
           });		
        addAnnotation
          (getVertex_IncomingEdges(), 
           source, 
           new String[] {
             "kind", "element",
             "name", "incomingEdges"
           });		
        addAnnotation
          (getVertex_Graph(), 
           source, 
           new String[] {
             "kind", "attribute",
             "name", "graph"
           });
    }

} //BpmnPackageImpl
