/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.create.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class RootSCAModelCreationOperation
extends AbstractScribblerOperation {
    public RootSCAModelCreationOperation() {
    }

    public RootSCAModelCreationOperation(IDataModel model) {
        super(model);
    }

    public IStatus doExecute(IProgressMonitor monitor) throws ExecutionException {
        URI uri = this.getResourceURI();
        IEditModelScribbler scribbler = this.getEditModelScribbler();
        Assert.isNotNull((Object)scribbler);
        Resource resource = scribbler.getResource(uri);
        if (resource != null) {
            SCACoreRoot root = null;
            root = resource.getContents() == null || resource.getContents().isEmpty() ? SCAPackage.eINSTANCE.getSCAFactory().createSCACoreRoot() : (SCACoreRoot)resource.getContents().get(0);
            SCAObject addedObject = this.createAndAddSCAModelToRoot(root);
            resource.getContents().add((Object)root);
            this.model.setProperty("IAbstractScribblerDataModelProperties.RESULT", (Object)addedObject);
        }
        return OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
        return null;
    }

    protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
        return null;
    }

    protected abstract URI getResourceURI();

    protected abstract SCAObject createAndAddSCAModelToRoot(SCACoreRoot var1);
}

