/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.ComponentWireHandle;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;
import org.eclipse.stp.core.sca.impl.ComponentWireSourceHandle;
import org.eclipse.stp.core.sca.impl.ComponentWireTargetHandle;

public abstract class ComponentImpl
extends SCAInternalObjectImpl
implements Component {
    public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved.";
    protected PropertyValuesSet propertyValuesSet = null;
    protected ReferenceValuesSet referenceValuesSet = null;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    private static final String EMPTY_STRING = "";
    private Map sourceWireHandles;
    private Map targetWireHandles;
    static /* synthetic */ Class class$0;

    protected ComponentImpl() {
    }

    protected EClass eStaticClass() {
        return SCAPackage.eINSTANCE.getComponent();
    }

    public PropertyValuesSet getPropertyValuesSet() {
        return this.propertyValuesSet;
    }

    public NotificationChain basicSetPropertyValuesSet(PropertyValuesSet newPropertyValuesSet, NotificationChain msgs) {
        PropertyValuesSet oldPropertyValuesSet = this.propertyValuesSet;
        this.propertyValuesSet = newPropertyValuesSet;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPropertyValuesSet, (Object)newPropertyValuesSet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setPropertyValuesSet(PropertyValuesSet newPropertyValuesSet) {
        if (newPropertyValuesSet != this.propertyValuesSet) {
            NotificationChain msgs = null;
            if (this.propertyValuesSet != null) {
                msgs = ((InternalEObject)this.propertyValuesSet).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newPropertyValuesSet != null) {
                msgs = ((InternalEObject)newPropertyValuesSet).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetPropertyValuesSet(newPropertyValuesSet, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newPropertyValuesSet, (Object)newPropertyValuesSet));
        }
    }

    public ReferenceValuesSet getReferenceValuesSet() {
        return this.referenceValuesSet;
    }

    public NotificationChain basicSetReferenceValuesSet(ReferenceValuesSet newReferenceValuesSet, NotificationChain msgs) {
        ReferenceValuesSet oldReferenceValuesSet = this.referenceValuesSet;
        this.referenceValuesSet = newReferenceValuesSet;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldReferenceValuesSet, (Object)newReferenceValuesSet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setReferenceValuesSet(ReferenceValuesSet newReferenceValuesSet) {
        if (newReferenceValuesSet != this.referenceValuesSet) {
            NotificationChain msgs = null;
            if (this.referenceValuesSet != null) {
                InternalEObject internalEObject = (InternalEObject)this.referenceValuesSet;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.stp.core.sca.ReferenceValuesSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseRemove((InternalEObject)this, 2, (Class)clazz, msgs);
            }
            if (newReferenceValuesSet != null) {
                InternalEObject internalEObject = (InternalEObject)newReferenceValuesSet;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.stp.core.sca.ReferenceValuesSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 2, (Class)clazz, msgs);
            }
            if ((msgs = this.basicSetReferenceValuesSet(newReferenceValuesSet, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newReferenceValuesSet, (Object)newReferenceValuesSet));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 1: {
                    if (this.referenceValuesSet != null) {
                        msgs = ((InternalEObject)this.referenceValuesSet).eInverseRemove((InternalEObject)this, -2, null, msgs);
                    }
                    return this.basicSetReferenceValuesSet((ReferenceValuesSet)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return this.basicSetPropertyValuesSet(null, msgs);
                }
                case 1: {
                    return this.basicSetReferenceValuesSet(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getPropertyValuesSet();
            }
            case 1: {
                return this.getReferenceValuesSet();
            }
            case 2: {
                return this.getName();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setPropertyValuesSet((PropertyValuesSet)newValue);
                return;
            }
            case 1: {
                this.setReferenceValuesSet((ReferenceValuesSet)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setPropertyValuesSet(null);
                return;
            }
            case 1: {
                this.setReferenceValuesSet(null);
                return;
            }
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.propertyValuesSet != null;
            }
            case 1: {
                return this.referenceValuesSet != null;
            }
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    public Composite getComposite() {
        return (Composite)this.eContainer();
    }

    public void setReferenceValue(Reference reference, WireTarget target) {
        ReferenceValue wire = SCAFactory.eINSTANCE.createReferenceValue();
        wire.setReference(reference);
        wire.setTarget(target);
        this.getReferenceValues().add(wire);
    }

    public List getReferenceValues() {
        if (this.getReferenceValuesSet() != null) {
            return this.getReferenceValuesSet().getReferenceValues();
        }
        return new ReferenceValuesListDelegate(this);
    }

    public List getReferenceValues(String referenceName) {
        Assert.isNotNullOrEmtpy((String)referenceName, null);
        List refValues = this.getReferenceValues();
        if (refValues.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ReferenceValue singleRefValue = null;
        ArrayList<ReferenceValue> multipleRefValues = null;
        int i = 0;
        while (i < refValues.size()) {
            ReferenceValue refValue = (ReferenceValue)refValues.get(i);
            if (referenceName.equals(refValue.getName())) {
                if (singleRefValue == null) {
                    singleRefValue = refValue;
                } else {
                    if (multipleRefValues == null) {
                        multipleRefValues = new ArrayList<ReferenceValue>(refValues.size());
                        multipleRefValues.add(singleRefValue);
                    }
                    multipleRefValues.add(refValue);
                }
            }
            ++i;
        }
        if (multipleRefValues != null) {
            return Collections.unmodifiableList(multipleRefValues);
        }
        if (singleRefValue != null) {
            return Collections.singletonList(singleRefValue);
        }
        return Collections.EMPTY_LIST;
    }

    public List getReferenceValues(Reference reference) {
        Assert.isNotNull((Object)reference);
        List refValues = this.getReferenceValues();
        if (refValues.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ReferenceValue singleRefValue = null;
        ArrayList<ReferenceValue> multipleRefValues = null;
        int i = 0;
        while (i < refValues.size()) {
            ReferenceValue refValue = (ReferenceValue)refValues.get(i);
            if (reference.equals(refValue.getReference())) {
                if (singleRefValue == null) {
                    singleRefValue = refValue;
                } else {
                    if (multipleRefValues == null) {
                        multipleRefValues = new ArrayList<ReferenceValue>(refValues.size());
                        multipleRefValues.add(singleRefValue);
                    }
                    multipleRefValues.add(refValue);
                }
            }
            ++i;
        }
        if (multipleRefValues != null) {
            return Collections.unmodifiableList(multipleRefValues);
        }
        if (singleRefValue != null) {
            return Collections.singletonList(singleRefValue);
        }
        return Collections.EMPTY_LIST;
    }

    public WireTarget getWireTarget(String serviceName) {
        Assert.isNotNullOrEmtpy((String)serviceName, null);
        WireTarget target = null;
        if (this.hasValidAbstractType()) {
            ComponentType type = this.resolveComponentType();
            List services = type.getServices();
            int size = services.size();
            int i = 0;
            while (i < size) {
                Service service = (Service)services.get(i);
                if (serviceName.equals(service.getName())) {
                    target = this.getWireTargetFromComponentType(service);
                    break;
                }
                ++i;
            }
        }
        if (target == null) {
            target = this.createUnresolvedWireTargetHandle(serviceName);
        }
        return target;
    }

    public WireSource getWireSource(String referenceName) {
        Assert.isNotNullOrEmtpy((String)referenceName, null);
        WireSource source = null;
        if (this.hasValidAbstractType()) {
            ComponentType type = this.resolveComponentType();
            List references = type.getReferences();
            int size = references.size();
            int i = 0;
            while (i < size) {
                Reference reference = (Reference)references.get(i);
                if (referenceName.equals(reference.getName())) {
                    source = this.getWireSourceFromComponentType(reference);
                    break;
                }
                ++i;
            }
            source = source == null ? this.createUnresolvedWireSourceHandle(referenceName) : source;
        }
        return source;
    }

    public WireSource getWireSource(Reference reference) {
        Assert.isNotNull((Object)reference);
        WireSource source = null;
        if (this.hasValidAbstractType()) {
            ComponentType type = this.resolveComponentType();
            List references = type.getReferences();
            source = references.contains(reference) ? this.getWireSourceFromComponentType(reference) : this.createUnresolvedWireSourceHandle(reference.getName());
        }
        return source;
    }

    public WireSource getSingleWireSource() {
        WireSource source = null;
        if (this.hasValidAbstractType()) {
            ComponentType type = this.resolveComponentType();
            List references = type.getReferences();
            if (references.isEmpty() || references.size() > 1) {
                source = this.createUnresolvedWireSourceHandle(EMPTY_STRING);
            } else {
                Reference reference = (Reference)references.get(0);
                source = this.getWireSourceFromComponentType(reference);
            }
        }
        return source;
    }

    public Collection getWireSourcesWiredToTarget(WireTarget wireTarget) {
        ArrayList<WireSource> result = null;
        if (this.getReferenceValuesSet() != null && !this.getReferenceValues().isEmpty()) {
            Iterator it = this.getReferenceValues().iterator();
            while (it.hasNext()) {
                ReferenceValue refValue = (ReferenceValue)it.next();
                if (!refValue.targets(wireTarget)) continue;
                if (result == null) {
                    result = new ArrayList<WireSource>();
                }
                result.add(this.getWireSource(refValue.getReference()));
            }
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public WireTarget getWireTarget(Service service) {
        Assert.isNotNull((Object)service);
        WireTarget target = null;
        if (this.hasValidAbstractType()) {
            ComponentType type = this.resolveComponentType();
            target = type.getServices().contains(service) ? this.getWireTargetFromComponentType(service) : this.createUnresolvedWireTargetHandle(service.getName());
        }
        return target;
    }

    public WireTarget getSingleWireTarget() {
        WireTarget target = null;
        if (this.hasValidAbstractType()) {
            ComponentType type = this.resolveComponentType();
            List services = type.getServices();
            if (services.isEmpty() || services.size() > 1) {
                target = this.createUnresolvedWireTargetHandle(EMPTY_STRING);
            } else {
                Service service = (Service)type.getServices().get(0);
                target = this.getWireTargetFromComponentType(service);
            }
        }
        return target;
    }

    private WireTarget getWireTargetFromComponentType(Service service) {
        String key = service.getName();
        ComponentWireTargetHandle handle = (ComponentWireTargetHandle)this.getExistingWireHandle(this.targetWireHandles, key);
        if (handle == null) {
            handle = new ComponentWireTargetHandle((Component)this, service);
            if (this.targetWireHandles == null) {
                this.targetWireHandles = new WeakHashMap();
            }
            this.targetWireHandles.put(key, handle);
        }
        return handle;
    }

    private ComponentWireSourceHandle createUnresolvedWireSourceHandle(String referenceName) {
        ComponentWireSourceHandle handle = (ComponentWireSourceHandle)this.getExistingWireHandle(this.sourceWireHandles, referenceName);
        if (handle == null) {
            handle = new ComponentWireSourceHandle((Component)this, referenceName);
            this.createdComponentWireSourceHandle(handle, referenceName);
        }
        return handle;
    }

    private WireSource getWireSourceFromComponentType(Reference reference) {
        String key = reference.getName();
        ComponentWireSourceHandle handle = (ComponentWireSourceHandle)this.getExistingWireHandle(this.sourceWireHandles, key);
        if (handle == null) {
            handle = new ComponentWireSourceHandle((Component)this, reference);
            this.createdComponentWireSourceHandle(handle, key);
        }
        return handle;
    }

    private ComponentWireHandle getExistingWireHandle(Map map, String key) {
        return map == null ? null : map.get(key);
    }

    private void createdComponentWireSourceHandle(ComponentWireSourceHandle handle, String referenceName) {
        if (this.sourceWireHandles == null) {
            this.sourceWireHandles = new WeakHashMap();
        }
        this.sourceWireHandles.put(referenceName, handle);
    }

    private void createdComponentWireTargetHandle(ComponentWireTargetHandle handle, String serviceName) {
        if (this.targetWireHandles == null) {
            this.targetWireHandles = new WeakHashMap();
        }
        this.targetWireHandles.put(serviceName, handle);
    }

    private ComponentWireTargetHandle createUnresolvedWireTargetHandle(String serviceName) {
        ComponentWireTargetHandle handle = (ComponentWireTargetHandle)this.getExistingWireHandle(this.targetWireHandles, serviceName);
        if (handle == null) {
            handle = new ComponentWireTargetHandle((Component)this, serviceName);
            this.createdComponentWireTargetHandle(handle, serviceName);
        }
        return handle;
    }

    public boolean hasValidAbstractType() {
        return this.resolveComponentType() != null;
    }

    private static class ReferenceValuesListDelegate
    implements List {
        private ComponentImpl component;
        private ReferenceValuesSet set;

        ReferenceValuesListDelegate(ComponentImpl component) {
            this.component = component;
            this.set = component.getReferenceValuesSet();
        }

        private void initializeReferenceValuesSet() {
            this.set = SCAFactory.eINSTANCE.createReferenceValuesSet();
            this.component.setReferenceValuesSet(this.set);
        }

        public int size() {
            return this.set == null ? 0 : this.set.getReferenceValues().size();
        }

        public boolean isEmpty() {
            return this.set == null ? true : this.set.getReferenceValues().isEmpty();
        }

        public boolean contains(Object o) {
            return this.set == null ? false : this.set.getReferenceValues().contains(o);
        }

        public Iterator iterator() {
            return this.set == null ? null : this.set.getReferenceValues().iterator();
        }

        public Object[] toArray() {
            return this.set == null ? new Object[]{} : this.set.getReferenceValues().toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.set == null ? new Object[]{} : this.set.getReferenceValues().toArray(a);
        }

        public boolean add(Object o) {
            if (this.set == null) {
                this.initializeReferenceValuesSet();
            }
            return this.set.getReferenceValues().add(o);
        }

        public boolean remove(Object o) {
            return this.set == null ? false : this.set.getReferenceValues().remove(o);
        }

        public boolean containsAll(Collection c) {
            return this.set == null ? false : this.set.getReferenceValues().containsAll(c);
        }

        public boolean addAll(Collection c) {
            if (this.set == null) {
                this.initializeReferenceValuesSet();
            }
            return this.set.getReferenceValues().addAll(c);
        }

        public boolean addAll(int index, Collection c) {
            if (this.set == null) {
                this.initializeReferenceValuesSet();
            }
            return this.set.getReferenceValues().addAll(index, c);
        }

        public boolean removeAll(Collection c) {
            return this.set == null ? false : this.set.getReferenceValues().removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.set == null ? false : this.set.getReferenceValues().retainAll(c);
        }

        public void clear() {
            if (this.set != null) {
                this.set.getReferenceValues().clear();
            }
        }

        public Object get(int index) {
            return this.set == null ? null : this.set.getReferenceValues().get(index);
        }

        public Object set(int index, Object element) {
            return this.set == null ? null : this.set.getReferenceValues().set(index, element);
        }

        public void add(int index, Object element) {
            if (this.set == null) {
                this.initializeReferenceValuesSet();
            }
            this.set.getReferenceValues().add(index, element);
        }

        public Object remove(int index) {
            return this.set == null ? null : this.set.getReferenceValues().remove(index);
        }

        public int indexOf(Object o) {
            return this.set == null ? -1 : this.set.getReferenceValues().indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.set == null ? -1 : this.set.getReferenceValues().lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.set == null ? null : this.set.getReferenceValues().listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.set == null ? null : this.set.getReferenceValues().listIterator(index);
        }

        public List subList(int fromIndex, int toIndex) {
            return this.set == null ? Collections.EMPTY_LIST : this.set.getReferenceValues().subList(fromIndex, toIndex);
        }
    }
}

