/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.introspection;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.UnknownImplementation;

public abstract class AbstractComponentTypeIntrospector
implements IComponentTypeIntrospector {
    private ComponentType componentType;
    private URI implementationURI;
    private boolean updatingEMFModel = false;
    private boolean updatingUnderlyingModel = false;
    private Implementation implementation;

    public final void init(Implementation theImplementation) {
        Assert.isNotNull((Object)theImplementation);
        if (SCAPackage.eINSTANCE.getUnknownImplementation().equals(theImplementation.getEObject().eClass())) {
            UnknownImplementation unknownImplementation = (UnknownImplementation)theImplementation;
            this.implementationURI = URI.createURI((String)unknownImplementation.getUri());
        } else {
            this.implementation = theImplementation;
        }
        this.doInit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void notifyChanged(Notification notification) {
        if (this.updatingEMFModel) {
            return;
        }
        this.updatingUnderlyingModel = true;
        try {
            if (notification.getFeature() == SCAPackage.eINSTANCE.getComponentType_Services()) {
                switch (notification.getEventType()) {
                    case 3: {
                        Service service = (Service)notification.getNewValue();
                        this.onModelChange(0, 3, service);
                        break;
                    }
                    case 5: {
                        List services = (List)notification.getNewValue();
                        int i = 0;
                        while (i < services.size()) {
                            Service service = (Service)services.get(i);
                            this.onModelChange(0, 3, service);
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        Service service = (Service)notification.getOldValue();
                        this.onModelChange(0, 4, service);
                        break;
                    }
                    case 6: {
                        List services = (List)notification.getOldValue();
                        int i = 0;
                        while (i < services.size()) {
                            Service service = (Service)services.get(i);
                            this.onModelChange(0, 4, service);
                            ++i;
                        }
                        break block2;
                    }
                }
            } else if (notification.getFeature() == SCAPackage.eINSTANCE.getComponentType_References()) {
                switch (notification.getEventType()) {
                    case 3: {
                        Reference reference = (Reference)notification.getNewValue();
                        this.onModelChange(1, 3, reference);
                        break;
                    }
                    case 5: {
                        List references = (List)notification.getNewValue();
                        int i = 0;
                        while (i < references.size()) {
                            Reference reference = (Reference)references.get(i);
                            this.onModelChange(1, 3, reference);
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        Reference reference = (Reference)notification.getOldValue();
                        this.onModelChange(1, 4, reference);
                        break;
                    }
                    case 6: {
                        List references = (List)notification.getOldValue();
                        int i = 0;
                        while (i < references.size()) {
                            Reference reference = (Reference)references.get(i);
                            this.onModelChange(1, 4, reference);
                            ++i;
                        }
                        break block8;
                    }
                }
            } else if (notification.getFeature() == SCAPackage.eINSTANCE.getComponentType_Properties()) {
                switch (notification.getEventType()) {
                    case 3: {
                        Property property = (Property)notification.getNewValue();
                        this.onModelChange(2, 3, property);
                        break;
                    }
                    case 5: {
                        List properties = (List)notification.getNewValue();
                        int i = 0;
                        while (i < properties.size()) {
                            Property property = (Property)properties.get(i);
                            this.onModelChange(2, 3, property);
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        Property property = (Property)notification.getOldValue();
                        this.onModelChange(2, 4, property);
                        break;
                    }
                    case 6: {
                        List properties = (List)notification.getOldValue();
                        int i = 0;
                        while (i < properties.size()) {
                            Property property = (Property)properties.get(i);
                            this.onModelChange(2, 4, property);
                            ++i;
                        }
                        break;
                    }
                }
            }
            this.doNotifyChanged(notification);
        }
        catch (Throwable throwable) {
            Object var5_27 = null;
            this.updatingUnderlyingModel = false;
            throw throwable;
        }
        {
            Object var5_28 = null;
            this.updatingUnderlyingModel = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IStatus introspect(int theFieldType, List theCurrentValues) {
        IStatus result = Status.OK_STATUS;
        this.updatingEMFModel = true;
        try {
            try {
                result = this.doIntrospection(theFieldType, theCurrentValues);
            }
            catch (RuntimeException rex) {
                String message = rex.getMessage();
                if (message == null) {
                    message = rex.toString();
                }
                result = STPCorePlugin.createErrorStatus(message, rex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.updatingEMFModel = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.updatingEMFModel = false;
            return result;
        }
    }

    public final Notifier getTarget() {
        if (this.componentType != null) {
            return this.componentType.getEObject();
        }
        return null;
    }

    public final ComponentType getComponentType() {
        return this.componentType;
    }

    public final URI getImplementationURI() {
        return this.implementationURI;
    }

    public final Implementation getImplementation() {
        return this.implementation;
    }

    public final void setTarget(Notifier newTarget) {
        Assert.isTrue((newTarget == null || newTarget instanceof ComponentType ? 1 : 0) != 0);
        this.componentType = newTarget == null ? null : (ComponentType)newTarget;
    }

    public final boolean isAdapterForType(Object type) {
        return type == IComponentTypeIntrospector.ADAPTER_TYPE;
    }

    protected void doInit() {
    }

    protected void doNotifyChanged(Notification notification) {
        Assert.isTrue((boolean)notification.equals(notification));
    }

    protected abstract IStatus doIntrospection(int var1, List var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doUpdateModel(int theFieldType, int theChangeType, List theValues) {
        if (this.updatingUnderlyingModel) {
            return;
        }
        this.updatingEMFModel = true;
        try {
            switch (theFieldType) {
                case 0: {
                    Service service = null;
                    int i = 0;
                    while (i < theValues.size()) {
                        service = (Service)theValues.get(i);
                        if (theChangeType == 3) {
                            this.getComponentType().getServices().add(service);
                        } else if (theChangeType == 4) {
                            this.getComponentType().getServices().remove(service);
                        }
                        ++i;
                    }
                    break;
                }
                case 2: {
                    Property property = null;
                    int i = 0;
                    while (i < theValues.size()) {
                        property = (Property)theValues.get(i);
                        if (theChangeType == 3) {
                            this.getComponentType().getProperties().add(property);
                        } else if (theChangeType == 4) {
                            this.getComponentType().getProperties().remove(property);
                        }
                        ++i;
                    }
                    break;
                }
                case 1: {
                    Reference reference = null;
                    int i = 0;
                    while (i < theValues.size()) {
                        reference = (Reference)theValues.get(i);
                        if (theChangeType == 3) {
                            this.getComponentType().getReferences().add(reference);
                        } else if (theChangeType == 4) {
                            this.getComponentType().getReferences().remove(reference);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.updatingEMFModel = false;
            throw throwable;
        }
        {
            Object var8_12 = null;
            this.updatingEMFModel = false;
            return;
        }
    }
}

