/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;
import org.eclipse.stp.core.sca.impl.UnresolvedWireHandle;

public class CompositeImpl
extends SCAInternalObjectImpl
implements Composite {
    public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved.";
    protected EList entryPoints = null;
    protected FeatureMap componentsGroup = null;
    protected EList externalServices = null;
    protected static final String NAME_EDEFAULT = null;
    private static final String URI_SCHEME_SEP = "://";
    protected String name = NAME_EDEFAULT;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected CompositeImpl() {
    }

    protected EClass eStaticClass() {
        return SCAPackage.eINSTANCE.getComposite();
    }

    public List getEntryPoints() {
        if (this.entryPoints == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.stp.core.sca.EntryPoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.entryPoints = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 0);
        }
        return this.entryPoints;
    }

    public FeatureMap getComponentsGroup() {
        if (this.componentsGroup == null) {
            this.componentsGroup = new BasicFeatureMap((InternalEObject)this, 1);
        }
        return this.componentsGroup;
    }

    public List getExternalServices() {
        if (this.externalServices == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.stp.core.sca.ExternalService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.externalServices = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 3);
        }
        return this.externalServices;
    }

    public List getComponentsGen() {
        return this.getComponentsGroup().list((EStructuralFeature)SCAPackage.eINSTANCE.getComposite_Components());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldName, (Object)this.name));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEntryPoints()).basicRemove((Object)otherEnd, msgs);
                }
                case 1: {
                    return ((InternalEList)this.getComponentsGroup()).basicRemove((Object)otherEnd, msgs);
                }
                case 2: {
                    return ((InternalEList)this.getComponents()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return ((InternalEList)this.getExternalServices()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEntryPoints();
            }
            case 1: {
                return this.getComponentsGroup();
            }
            case 2: {
                return this.getComponents();
            }
            case 3: {
                return this.getExternalServices();
            }
            case 4: {
                return this.getName();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEntryPoints().clear();
                this.getEntryPoints().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getComponentsGroup().clear();
                this.getComponentsGroup().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getComponents().clear();
                this.getComponents().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getExternalServices().clear();
                this.getExternalServices().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEntryPoints().clear();
                return;
            }
            case 1: {
                this.getComponentsGroup().clear();
                return;
            }
            case 2: {
                this.getComponents().clear();
                return;
            }
            case 3: {
                this.getExternalServices().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.entryPoints != null && !this.entryPoints.isEmpty();
            }
            case 1: {
                return this.componentsGroup != null && !this.componentsGroup.isEmpty();
            }
            case 2: {
                return !this.getComponents().isEmpty();
            }
            case 3: {
                return this.externalServices != null && !this.externalServices.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (componentsGroup: ");
        result.append(this.componentsGroup);
        result.append(", name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    public Component getComponent(String componentName) {
        Assert.isNotNullOrEmtpy((String)componentName, null);
        Component component = null;
        List comps = this.getComponents();
        if (!comps.isEmpty()) {
            int size = comps.size();
            int i = 0;
            while (i < size) {
                component = (Component)comps.get(i);
                if (componentName.equals(component.getName())) break;
                component = null;
                ++i;
            }
        }
        return component;
    }

    public List getAllMatchingTargets(WireSource wireSource) {
        return null;
    }

    public List getAllMatchingSources(WireTarget wireTarget) {
        return null;
    }

    public ExternalService getExternalService(String name) {
        Assert.isNotNullOrEmtpy((String)name, null);
        ExternalService extService = null;
        List extServices = this.getExternalServices();
        if (!extServices.isEmpty()) {
            int size = extServices.size();
            int i = 0;
            while (i < size) {
                extService = (ExternalService)extServices.get(i);
                if (name.equals(extService.getName())) break;
                extService = null;
                ++i;
            }
        }
        return extService;
    }

    public WireTarget resolveWireTarget(String targetURI) {
        Assert.isNotNullOrEmtpy((String)targetURI, null);
        WireTarget target = null;
        if (targetURI.indexOf(URI_SCHEME_SEP) <= 0) {
            int sepIndex = targetURI.indexOf(47);
            if (sepIndex > 0) {
                String componentName = targetURI.substring(0, sepIndex);
                String serviceName = targetURI.substring(sepIndex + 1);
                target = this.resolveTargetForComponentService(componentName, serviceName);
            } else {
                target = this.getExternalService(targetURI);
                if (target == null) {
                    target = this.resolveTargetComponentWithSingleService(targetURI);
                }
            }
        }
        if (target == null) {
            target = this.createUnresolvedWireHandle(targetURI);
        }
        return target;
    }

    private WireTarget resolveTargetComponentWithSingleService(String name) {
        WireTarget target = null;
        Component component = this.getComponent(name);
        target = component == null ? this.createUnresolvedWireHandle(name) : component.getSingleWireTarget();
        return target;
    }

    private WireTarget resolveTargetForComponentService(String configurableName, String serviceName) {
        Component component = this.getComponent(configurableName);
        WireTarget target = null;
        if (component != null) {
            target = component.getWireTarget(serviceName);
        }
        return target;
    }

    public WireSource resolveWireSource(String sourceURI) {
        Assert.isNotNullOrEmtpy((String)sourceURI, null);
        WireSource source = null;
        int sepIndex = sourceURI.indexOf(47);
        if (sepIndex > 0) {
            String componentName = sourceURI.substring(0, sepIndex);
            String referenceName = sourceURI.substring(sepIndex + 1);
            source = this.resolveSourceForComponentReference(componentName, referenceName);
        } else {
            source = this.getEntryPoint(sourceURI);
            if (source == null) {
                source = this.resolveSourceComponentWithSingleReference(sourceURI);
            }
        }
        return source;
    }

    private WireSource resolveSourceForComponentReference(String configurableName, String referenceName) {
        Component component = this.getComponent(configurableName);
        WireSource source = null;
        if (component != null) {
            source = component.getWireSource(referenceName);
        }
        return source;
    }

    private WireSource resolveSourceComponentWithSingleReference(String name) {
        WireSource source = null;
        Component component = this.getComponent(name);
        source = component == null ? this.createUnresolvedWireHandle(name) : component.getSingleWireSource();
        return source;
    }

    private UnresolvedWireHandle createUnresolvedWireHandle(String handleName) {
        return new UnresolvedWireHandle(handleName);
    }

    public EntryPoint getEntryPoint(String name) {
        Assert.isNotNullOrEmtpy((String)name, null);
        EntryPoint entPoint = null;
        List entPoints = this.getEntryPoints();
        if (!entPoints.isEmpty()) {
            int size = entPoints.size();
            int i = 0;
            while (i < size) {
                entPoint = (EntryPoint)entPoints.get(i);
                if (name.equals(entPoint.getName())) break;
                entPoint = null;
                ++i;
            }
        }
        return entPoint;
    }

    public Collection getAllWiredSources(WireTarget wireTarget) {
        List components;
        Assert.isNotNull((Object)wireTarget);
        HashSet<EntryPoint> sources = null;
        List entries = this.getEntryPoints();
        if (!entries.isEmpty()) {
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                EntryPoint ep = (EntryPoint)it.next();
                if (!ep.hasWireToTarget(wireTarget)) continue;
                if (sources == null) {
                    sources = new HashSet<EntryPoint>();
                }
                sources.add(ep);
            }
        }
        if (!(components = this.getComponents()).isEmpty()) {
            Iterator it = components.iterator();
            while (it.hasNext()) {
                Component component = (Component)it.next();
                Collection componentSources = component.getWireSourcesWiredToTarget(wireTarget);
                if (componentSources.isEmpty()) continue;
                if (sources == null) {
                    sources = new HashSet();
                }
                sources.addAll(componentSources);
            }
        }
        return sources == null ? Collections.EMPTY_LIST : sources;
    }

    public List getComponents() {
        return this.getComponentsGroup().list((EStructuralFeature)SCAPackage.eINSTANCE.getSCACoreRoot_Component());
    }
}

