/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.resources.ComponentTypeScribblerDomain;
import org.eclipse.stp.core.resources.CompositeScribblerDomain;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.util.IModelLifecycle;
import org.eclipse.stp.core.util.ModelLifecycleException;
import org.eclipse.stp.core.util.SCAType;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class SCAArtifactEdit
implements IModelLifecycle {
    private static final String EDIT_MODEL_SUFFIX = ".soaeditmodel";
    private IEditModelScribbler scribbler = null;
    private boolean isArtifactEditModelSelfManaged;
    private CompositeScribblerDomain compositeDomain;
    private ComponentTypeScribblerDomain componentTypeDomain;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public SCAArtifactEdit(IEditModelScribbler aScribbler) {
        this.scribbler = aScribbler;
        this.isArtifactEditModelSelfManaged = false;
    }

    protected SCAArtifactEdit(IProject aProject, CompositeScribblerDomain aCompositeDomain, ComponentTypeScribblerDomain aComponentTypeDomain, boolean toAccessAsReadOnly) {
        Assert.isNotNull((Object)((Object)aCompositeDomain));
        this.compositeDomain = aCompositeDomain;
        this.componentTypeDomain = aComponentTypeDomain;
        String editModelLabel = String.valueOf(aProject.getName()) + EDIT_MODEL_SUFFIX;
        try {
            this.scribbler = toAccessAsReadOnly ? IEditModelFactory.eINSTANCE.createScribblerForRead(aProject, editModelLabel, new IScribblerDomain[]{aCompositeDomain, aComponentTypeDomain}) : IEditModelFactory.eINSTANCE.createScribblerForWrite(aProject, editModelLabel, new IScribblerDomain[]{aCompositeDomain, aComponentTypeDomain});
        }
        catch (EditModelException editModelException) {}
        this.isArtifactEditModelSelfManaged = true;
    }

    public static SCAArtifactEdit createArtifactEditForRead(IProject aProject, CompositeScribblerDomain aCompositeDomain, ComponentTypeScribblerDomain aComponentTypeDomain) {
        SCAArtifactEdit scaArtifactEdit = null;
        try {
            scaArtifactEdit = new SCAArtifactEdit(aProject, aCompositeDomain, aComponentTypeDomain, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            scaArtifactEdit = null;
        }
        return scaArtifactEdit;
    }

    public static SCAArtifactEdit createArtifactEditForWrite(IProject aProject, CompositeScribblerDomain aCompositeDomain, ComponentTypeScribblerDomain aComponentTypeDomain) {
        SCAArtifactEdit scaArtifactEdit = null;
        try {
            scaArtifactEdit = new SCAArtifactEdit(aProject, aCompositeDomain, aComponentTypeDomain, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            scaArtifactEdit = null;
        }
        return scaArtifactEdit;
    }

    public void save(int options, IProgressMonitor aMonitor) throws ModelLifecycleException {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        }
        try {
            this.scribbler.save(true, aMonitor);
        }
        catch (EditModelException e) {
            throw new ModelLifecycleException(e);
        }
    }

    public void close(int options, IProgressMonitor aMonitor) throws ModelLifecycleException {
        try {
            if (this.isArtifactEditModelSelfManaged) {
                this.scribbler.close(aMonitor);
            }
        }
        catch (EditModelException e) {
            e.printStackTrace();
        }
    }

    public void discard(IProgressMonitor aMonitor) throws ModelLifecycleException {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        }
        try {
            this.scribbler.revert(aMonitor);
        }
        catch (EditModelException e) {
            throw new ModelLifecycleException(e);
        }
    }

    public void revert(int options, IProgressMonitor aMonitor) throws ModelLifecycleException {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        }
        try {
            this.scribbler.revert(aMonitor);
        }
        catch (EditModelException e) {
            throw new ModelLifecycleException(e);
        }
    }

    public boolean isReadOnly() {
        return this.scribbler.isReadOnly();
    }

    private void throwAttemptedReadOnlyModification() {
        throw new IllegalStateException(Messages.Attempt_to_modify_an_SCA_);
    }

    public static IDataModel getDataModelForCreation(String type, IProject aProject) {
        Class dataModelClass = null;
        if (type.equals(SCAType.COMPONENT_TYPE)) {
            Class clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.stp.core.create.operations.ComponentTypeCreationDataModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dataModelClass = clazz;
        } else if (type.equals("COMPOSITE")) {
            Class clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.stp.core.create.operations.CompositeCreationDataModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dataModelClass = clazz;
        } else if (type.equals("MODULE")) {
            Class clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.stp.core.create.operations.ModuleCreationDataModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dataModelClass = clazz;
        } else if (type.equals("COMPONENT")) {
            Class clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.stp.core.create.operations.ComponentCreationDataModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dataModelClass = clazz;
        } else if (type.equals("REFERENCE")) {
            Class clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.stp.core.create.operations.ReferenceCreationDataModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dataModelClass = clazz;
        } else if (type.equals("INTERFACE")) {
            Class clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.stp.core.create.operations.ServiceCreationDataModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dataModelClass = clazz;
        } else if (type.equals("PROPERTY")) {
            Class clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.eclipse.stp.core.create.operations.PropertyCreationDataModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dataModelClass = clazz;
        }
        if (dataModelClass != null) {
            IDataModel model = DataModelFactory.createDataModel((Class)dataModelClass);
            Assert.isNotNull((Object)model, (String)Messages.DataModel_could_not_be_c_);
            return model;
        }
        return null;
    }

    public ComponentType getComponentType() {
        Resource resource = this.scribbler.getResource((IResourceDescriptor)this.componentTypeDomain.getComponentTypeDescriptor());
        return (ComponentType)this.getFirstInstanceOfEObjectFromResource(SCAPackage.eINSTANCE.getComponentType(), resource);
    }

    public Composite getComposite() {
        Resource resource = this.scribbler.getResource(this.compositeDomain.getCompositeDescriptor());
        return (Composite)this.getFirstInstanceOfEObjectFromResource(SCAPackage.eINSTANCE.getComposite(), resource);
    }

    public EObject getRootSCAObject(URI scaObjectURI) {
        Assert.isNotNull((Object)this.scribbler);
        Resource resource = this.scribbler.getResource(scaObjectURI);
        return this.getRootSCAObject(resource);
    }

    public EObject getRootSCAObject(Resource rootResource) {
        SCAPackage scdlPkg = SCAPackage.eINSTANCE;
        EClass eClass = null;
        String ext = rootResource.getURI().fileExtension();
        Assert.isNotNull((Object)ext);
        if (ext.equals("componentType")) {
            eClass = scdlPkg.getComponent();
        } else if (ext.equals("composite")) {
            eClass = scdlPkg.getComposite();
        }
        Assert.isNotNull((Object)this.scribbler);
        return this.getFirstInstanceOfEObjectFromResource(eClass, rootResource);
    }

    public EObject getFirstInstanceOfEObjectFromResource(EClass eClass, Resource resource) {
        if (resource == null) {
            return null;
        }
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!element.eClass().equals(eClass)) continue;
            return element;
        }
        return null;
    }
}

