/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EditModelDisposedException;
import org.eclipse.stp.core.infrastructure.emf.EditModelEvent;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModel;
import org.eclipse.stp.core.infrastructure.emf.IEditModelErrorHandler;
import org.eclipse.stp.core.infrastructure.emf.IEditModelListener;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.stp.core.internal.infrastructure.emf.EditModelScribbler;
import org.eclipse.stp.core.internal.infrastructure.emf.ListenerList;
import org.eclipse.stp.core.internal.infrastructure.emf.LoggerErrorHandler;
import org.eclipse.stp.core.internal.infrastructure.emf.Messages;
import org.eclipse.stp.core.internal.infrastructure.emf.ResourceUtilities;
import org.eclipse.stp.core.internal.infrastructure.emf.ScribblerAdapter;
import org.eclipse.stp.core.internal.infrastructure.emf.ScribblerTracker;
import org.eclipse.stp.core.internal.infrastructure.emf.UnreleasedScribblerException;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public final class EditModel
implements IEditModel,
CommandStackListener {
    public static final int OPEN_FOR_BUSINESS = 0;
    public static final int DISPOSED = 2;
    private final String editModelID;
    private int state;
    private final ListenerList listeners = new ListenerList();
    private final Set resources = new HashSet();
    private final ScribblerTracker scribblerTracker;
    private IEditModelErrorHandler errorHandler;
    private final EMFWorkbenchContext emfContext;
    private IOperationHistory operationHistory;
    private ResourceAdapter resourceAdapter = new ResourceAdapter();
    private boolean reverting;

    public EditModel(String anEditModelID, EMFWorkbenchContext context) {
        this.editModelID = anEditModelID;
        this.emfContext = context;
        this.state = 0;
        this.scribblerTracker = new ScribblerTracker(anEditModelID);
        this.errorHandler = LoggerErrorHandler.INSTANCE;
        this.processLoadedResources();
    }

    public void addListener(IEditModelListener aListener) throws EditModelException {
        this.complainIfDisposed();
        this.listeners.add(aListener);
    }

    public void removeListener(IEditModelListener aListener) {
        this.listeners.remove(aListener);
    }

    public boolean isInterrestedInResource(Resource aResource) {
        if (this.isDisposed()) {
            return false;
        }
        IScribblerDomain[] domains = this.scribblerTracker.getScribblerDomains();
        int i = 0;
        while (i < domains.length) {
            try {
                if (domains[i].isContained(aResource)) {
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
        return false;
    }

    public boolean isDisposed() {
        return this.state == 2;
    }

    public IEditModelScribbler createScribbler(IScribblerDomain[] theDomains, boolean makeReadOnly) throws EditModelException {
        this.complainIfDisposed();
        EditModelScribbler scribbler = new EditModelScribbler(this, theDomains, makeReadOnly);
        this.addScribbler(scribbler);
        return scribbler;
    }

    public EMFWorkbenchContext getEmfContext() throws EditModelException {
        this.complainIfDisposed();
        return this.emfContext;
    }

    public IOperationHistory getOperationHistory() throws EditModelException {
        this.complainIfDisposed();
        if (this.operationHistory == null) {
            this.operationHistory = new DefaultOperationHistory();
        }
        return this.operationHistory;
    }

    public void setErrorHandler(IEditModelErrorHandler anErrorHandler) {
        this.errorHandler = anErrorHandler != null ? anErrorHandler : LoggerErrorHandler.INSTANCE;
    }

    public String getEditModelLabel() {
        return this.editModelID;
    }

    public void commandStackChanged(EventObject event) {
    }

    public IEditModelErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public int getReferenceCount() {
        return this.scribblerTracker.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EditModel editModel = this;
        synchronized (editModel) {
            if (this.isDisposed()) {
                return;
            }
            this.state = 2;
            EditModelEvent event = new EditModelEvent(5);
            this.notifyListeners(event);
            ListenerList listenerList = this.listeners;
            synchronized (listenerList) {
                Object[] theListeners = this.listeners.getListeners();
                this.listeners.remove(theListeners);
            }
        }
    }

    public final ListenerList getListeners() {
        return this.listeners;
    }

    public boolean isReverting() {
        return this.reverting;
    }

    public boolean isManagingResource(Resource resource) {
        return this.resources.contains(resource);
    }

    public void resourceChanged(EditModelEvent anEvent) {
        int code = anEvent.getEventCode();
        switch (code) {
            case 3: {
                List changedResources = anEvent.getChangedResources();
                int i = 0;
                while (i < changedResources.size()) {
                    Resource resource = (Resource)changedResources.get(i);
                    if (resource != null && this.isInterrestedInResource(resource)) {
                        this.resources.remove(resource);
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                List changedResources = anEvent.getChangedResources();
                int i = 0;
                while (i < changedResources.size()) {
                    Resource resource = (Resource)changedResources.get(i);
                    if (resource != null && this.isInterrestedInResource(resource)) {
                        this.enableResourceTracking(resource);
                    }
                    ++i;
                }
                break;
            }
        }
        if (this.hasListeners()) {
            this.notifyListeners(anEvent);
        }
    }

    void processLoadedResources() {
        try {
            ResourceSet[] sets = this.getEmfContext().getResourceSets();
            int setIndx = 0;
            while (setIndx < sets.length) {
                EList loaded = sets[setIndx].getResources();
                if (!loaded.isEmpty()) {
                    int size = loaded.size();
                    int i = 0;
                    while (i < size) {
                        Resource resource = (Resource)loaded.get(i);
                        Assert.isNotNull(resource);
                        if (!this.resources.contains(resource) && this.isInterrestedInResource(resource)) {
                            this.enableResourceTracking(resource);
                        }
                        ++i;
                    }
                }
                ++setIndx;
            }
        }
        catch (EditModelException e) {
            EMFInfrastructurePlugin.log(EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e));
        }
    }

    void enableResourceTracking(Resource aResource) {
        Assert.isNotNull(aResource);
        if (!this.resources.contains(aResource)) {
            this.adaptForTracking(aResource);
            if (aResource instanceof ReferencedResource) {
                ((ReferencedResource)aResource).setFormat(1);
            } else if (aResource instanceof CompatibilityXMIResource) {
                ((CompatibilityXMIResource)aResource).setFormat(1);
            }
            this.resources.add(aResource);
            ResourceAdapter rAdapter = (ResourceAdapter)EcoreUtil.getAdapter((List)aResource.eAdapters(), (Object)((Object)this.resourceAdapter));
            if (rAdapter == null) {
                aResource.eAdapters().add((Object)this.resourceAdapter);
            }
        }
    }

    void removeScribbler(IEditModelScribbler scribbler) {
        this.scribblerTracker.release(scribbler);
    }

    boolean isShared(IEditModelScribbler aScribbler) {
        IEditModelScribbler[] scribblers = this.scribblerTracker.getScribblers().toArray(new IEditModelScribbler[this.scribblerTracker.getScribblers().size()]);
        int i = 0;
        while (i < scribblers.length) {
            if (!scribblers[i].isReadOnly() && aScribbler != scribblers[i] && scribblers[i].matches(aScribbler)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Set getResources() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Resource getResource(URI aUri, boolean localOnly, boolean requestLoad) throws EditModelException {
        this.complainIfDisposed();
        if (aUri == null || aUri.segmentCount() == 0) {
            return null;
        }
        IFile platformFile = null;
        if (ResourceUtilities.isPlatformResourceURI(aUri)) {
            platformFile = ResourceUtilities.getPlatformFile(aUri);
            if (platformFile == null) {
                return null;
            }
            if (platformFile.exists()) {
                try {
                    platformFile.refreshLocal(1, null);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
        }
        Resource foundResource = null;
        EditModel editModel = this;
        synchronized (editModel) {
            try {
                Set set = this.resources;
                synchronized (set) {
                    Resource resource = null;
                    Iterator resourcesItr = this.resources.iterator();
                    while (resourcesItr.hasNext() && foundResource == null) {
                        resource = (Resource)resourcesItr.next();
                        if (!ExtendedEcoreUtil.endsWith((URI)resource.getURI(), (URI)aUri)) continue;
                        foundResource = resource;
                    }
                    if (foundResource == null) {
                        ResourceSet[] sets = this.getEmfContext().getResourceSets();
                        int i = 0;
                        while (i < sets.length && foundResource == null) {
                            EList loadedResources = sets[i].getResources();
                            Iterator loadedResourcesItr = loadedResources.iterator();
                            while (loadedResourcesItr.hasNext() && foundResource == null) {
                                resource = (Resource)loadedResourcesItr.next();
                                if (!ExtendedEcoreUtil.endsWith((URI)resource.getURI(), (URI)aUri)) continue;
                                foundResource = resource;
                            }
                            ++i;
                        }
                    }
                    if (localOnly) {
                        if (foundResource != null) {
                            this.enableResourceTracking(foundResource);
                        }
                        return foundResource;
                    }
                    if (foundResource == null) {
                        foundResource = this.getResourceSet().getResource(aUri, false);
                    }
                    if (foundResource == null) {
                        foundResource = this.getResourceSet().createResource(aUri);
                    }
                    if (foundResource != null) {
                        this.enableResourceTracking(foundResource);
                    }
                    if (requestLoad && foundResource != null && !foundResource.isLoaded() && (platformFile == null || platformFile.exists())) {
                        foundResource.load(Collections.EMPTY_MAP);
                    }
                }
            }
            catch (RuntimeException e) {
                this.errorHandler.handleLoadFailed(aUri, (Exception)e);
            }
            catch (IOException e) {
                this.errorHandler.handleLoadFailed(aUri, (Exception)e);
            }
        }
        return foundResource;
    }

    void removeResource(Resource resource) {
        this.resources.remove(resource);
        this.getResourceSet().getResources().remove((Object)resource);
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void handleDelete(Resource aResource) {
        EditModel editModel = this;
        // MONITORENTER : editModel
        // MONITOREXIT : editModel
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleRevert(Resource[] theResources, IProgressMonitor monitor) {
        EditModel editModel = this;
        synchronized (editModel) {
            this.reverting = true;
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(Messages.Reverting_contents_of_editor, theResources.length + 2);
                monitor.worked(1);
                int i = 0;
                while (i < theResources.length) {
                    monitor.subTask(NLS.bind((String)Messages.Reverting_resource, (Object)theResources[i].getURI()));
                    try {
                        if (theResources[i].isModified()) {
                            theResources[i].unload();
                            theResources[i].load(Collections.EMPTY_MAP);
                        }
                    }
                    catch (IOException e) {
                        this.errorHandler.handleRevertFailed(theResources[i], e);
                    }
                    monitor.worked(1);
                    ++i;
                }
                monitor.subTask(Messages.Notifying_interested_lis_);
                if (this.listeners.size() > 0) {
                    EditModelEvent event = new EditModelEvent(10, Arrays.asList(theResources));
                    this.notifyListeners(event);
                }
                monitor.worked(1);
                monitor.subTask(Messages.Done_reverting_contents_of_editor);
                monitor.done();
                Object var6_9 = null;
                this.reverting = false;
                return;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.reverting = false;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSave(Resource[] theResources, IProgressMonitor monitor) {
        EditModel editModel = this;
        synchronized (editModel) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(Messages.Saving_contents_of_editor, theResources.length + 2);
            monitor.worked(1);
            int i = 0;
            while (i < theResources.length) {
                monitor.subTask(NLS.bind((String)Messages.Saving_resource, (Object)theResources[i].getURI()));
                try {
                    if (theResources[i].isLoaded() && theResources[i].isModified()) {
                        theResources[i].save(Collections.EMPTY_MAP);
                    }
                }
                catch (IOException e) {
                    this.errorHandler.handleSaveFailed(theResources[i], e);
                }
                monitor.worked(1);
                ++i;
            }
            monitor.subTask(Messages.Notifying_interested_lis_);
            if (this.listeners.size() > 0) {
                EditModelEvent event = new EditModelEvent(1, Arrays.asList(theResources));
                this.notifyListeners(event);
            }
            monitor.worked(1);
            monitor.subTask(Messages.Done_saving_contents_of_editor);
            monitor.done();
        }
    }

    void handleDelete(Resource[] resourcesToDelete, IProgressMonitor monitor) throws EditModelException {
        int i = 0;
        while (i < resourcesToDelete.length) {
            this.removeResource(resourcesToDelete[i]);
            if (resourcesToDelete[i].isLoaded()) {
                resourcesToDelete[i].unload();
            }
            try {
                IFile ifile = WorkbenchResourceHelper.getFile(resourcesToDelete[i]);
                if (ifile.exists()) {
                    ifile.delete(true, true, monitor);
                }
            }
            catch (CoreException e) {
                EMFInfrastructurePlugin.logError(0, e.getLocalizedMessage(), e);
                throw new EditModelException(e.getLocalizedMessage());
            }
            ++i;
        }
    }

    UnreleasedScribblerException[] computeUnreleasedScribblers() {
        return this.scribblerTracker.computeUnreleasedScribblers();
    }

    private void notifyListeners(EditModelEvent event) {
        Object[] notificationList = this.listeners.getListeners();
        int i = 0;
        while (i < notificationList.length) {
            ((IEditModelListener)notificationList[i]).editModelChanged(this, event);
            ++i;
        }
    }

    private ResourceSet getResourceSet() {
        try {
            if (this.getEmfContext() != null) {
                return this.getEmfContext().getResourceSet();
            }
        }
        catch (EditModelException e) {
            EMFInfrastructurePlugin.log(EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScribblerAdapter adaptForTracking(Resource aResource) {
        ScribblerAdapter adapter = null;
        Resource resource = aResource;
        synchronized (resource) {
            adapter = ScribblerAdapter.findAdapter(aResource);
            if (adapter == null) {
                adapter = new ScribblerAdapter(this);
                aResource.eAdapters().add((Object)adapter);
            }
        }
        return adapter;
    }

    private void complainIfDisposed() throws EditModelException {
        if (this.state == 2) {
            throw new EditModelDisposedException();
        }
    }

    private void addScribbler(IEditModelScribbler scribbler) {
        this.scribblerTracker.track(scribbler);
    }

    private boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    protected class ResourceAdapter
    extends AdapterImpl {
        protected ResourceAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == EditModel.this.resourceAdapter;
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 1 && notification.getFeatureID(null) == 4) {
                this.resourceIsLoadedChanged((Resource)notification.getNotifier(), notification.getOldBooleanValue(), notification.getNewBooleanValue());
            }
            if (notification.getEventType() == 1 && notification.getFeatureID(null) == 3) {
                this.resourceIsModified((Resource)notification.getNotifier(), notification.getOldBooleanValue(), notification.getNewBooleanValue());
            }
        }

        private void resourceIsLoadedChanged(Resource aResource, boolean wasLoaded, boolean isLoaded) {
            if (isLoaded) {
                EditModel.this.adaptForTracking(aResource);
            }
            if (EditModel.this.hasListeners()) {
                int eventCode = isLoaded ? 6 : 7;
                EditModelEvent evt = new EditModelEvent(eventCode, Collections.singletonList(aResource));
                EditModel.this.notifyListeners(evt);
            }
        }

        private void resourceIsModified(Resource aResource, boolean wasModified, boolean isModified) {
            if (isModified && !wasModified && EditModel.this.hasListeners()) {
                EditModel.this.notifyListeners(new EditModelEvent(2, Collections.singletonList(aResource)));
            }
        }
    }
}

