/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.infrastructure.emf.Messages;
import org.eclipse.stp.core.internal.infrastructure.emf.UnreleasedScribblerException;

class ScribblerTracker {
    private static final UnreleasedScribblerException[] NO_UNRELEASED_SCRIBBLERS = new UnreleasedScribblerException[0];
    private final WeakHashMap scribblerRegistry = new WeakHashMap();
    protected final Set accessedScribblers = new HashSet();
    private final Set scribblerDomains = new HashSet();
    private final Set resourceDescriptors = new HashSet();
    private IScribblerDomain[] domainsArray;
    public IResourceDescriptor[] descriptorsArray;
    private final Map referenceCounts = new HashMap();
    private final String editModelLabel;

    public ScribblerTracker(String anEditModelLabel) {
        this.editModelLabel = anEditModelLabel;
    }

    public synchronized void track(IEditModelScribbler scribbler) {
        Assert.isNotNull(scribbler);
        UnreleasedScribblerException exception = new UnreleasedScribblerException(this.editModelLabel);
        if (!this.scribblerRegistry.containsKey(scribbler)) {
            this.scribblerRegistry.put(scribbler, exception);
            this.accessedScribblers.add(exception);
        }
        this.updateDomainSet(this.scribblerRegistry.keySet());
    }

    public synchronized void release(IEditModelScribbler scribbler) {
        Assert.isNotNull(scribbler);
        if (this.scribblerRegistry.containsKey(scribbler)) {
            UnreleasedScribblerException exception = (UnreleasedScribblerException)this.scribblerRegistry.remove(scribbler);
            this.accessedScribblers.remove(exception);
        }
        this.updateDomainSet(this.scribblerRegistry.keySet());
    }

    public UnreleasedScribblerException[] computeUnreleasedScribblers() {
        HashSet<UnreleasedScribblerException> results = new HashSet<UnreleasedScribblerException>();
        UnreleasedScribblerException[] goodScribblers = this.scribblerRegistry.values().toArray(new UnreleasedScribblerException[results.size()]);
        UnreleasedScribblerException[] badScribblers = this.accessedScribblers.toArray(new UnreleasedScribblerException[results.size()]);
        boolean found = false;
        int j = 0;
        while (j < badScribblers.length) {
            found = false;
            int i = 0;
            while (i < goodScribblers.length && !found) {
                if (goodScribblers[i] == badScribblers[j]) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                results.add(badScribblers[j]);
                this.accessedScribblers.remove(badScribblers[j]);
            }
            ++j;
        }
        if (results.size() == 0) {
            return NO_UNRELEASED_SCRIBBLERS;
        }
        return results.toArray(new UnreleasedScribblerException[results.size()]);
    }

    public synchronized Set getScribblers() {
        return Collections.unmodifiableSet(this.scribblerRegistry.keySet());
    }

    public int getSize() {
        this.scribblerRegistry.remove(null);
        return this.scribblerRegistry.keySet().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScribblerDomain[] getScribblerDomains() {
        ScribblerTracker scribblerTracker = this;
        synchronized (scribblerTracker) {
            if (this.domainsArray == null) {
                this.domainsArray = this.scribblerDomains.toArray(new IScribblerDomain[this.scribblerDomains.size()]);
            }
            return this.domainsArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResourceDescriptor[] getResourceDescriptors() {
        ScribblerTracker scribblerTracker = this;
        synchronized (scribblerTracker) {
            if (this.descriptorsArray == null) {
                this.descriptorsArray = this.resourceDescriptors.toArray(new IResourceDescriptor[this.resourceDescriptors.size()]);
            }
            return this.descriptorsArray;
        }
    }

    public int size() {
        return this.scribblerRegistry.size();
    }

    public String toString() {
        return NLS.bind((String)Messages.ScribblerTracker_tracking_, (Object)new Integer(this.size()));
    }

    public boolean isShared(IScribblerDomain aDomain) {
        int[] reference = (int[])this.referenceCounts.get(aDomain);
        return reference != null ? reference[0] > 1 : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void updateDomainSet(Set scribblers) {
        ScribblerTracker scribblerTracker = this;
        synchronized (scribblerTracker) {
            this.domainsArray = null;
            this.descriptorsArray = null;
            boolean done = false;
            int iterationCount = 0;
            this.scribblerDomains.clear();
            this.referenceCounts.clear();
            while (!done) {
                Object var10_10;
                if (iterationCount >= 3) {
                    return;
                }
                try {
                    try {
                        Iterator itr = scribblers.iterator();
                        block9: while (true) {
                            if (!itr.hasNext()) break;
                            IEditModelScribbler scribbler = (IEditModelScribbler)itr.next();
                            Iterator iter = scribbler.getScribblerDomains().iterator();
                            while (true) {
                                if (!iter.hasNext()) {
                                    this.scribblerDomains.addAll(scribbler.getScribblerDomains());
                                    continue block9;
                                }
                                IScribblerDomain element = (IScribblerDomain)iter.next();
                                int[] referenceCount = (int[])this.referenceCounts.get(element);
                                if (referenceCount != null) {
                                    referenceCount[0] = referenceCount[0] + 1;
                                    continue;
                                }
                                this.referenceCounts.put(element, new int[]{1});
                            }
                            break;
                        }
                        Iterator iter = this.scribblerDomains.iterator();
                        while (true) {
                            if (!iter.hasNext()) {
                                done = true;
                            }
                            IScribblerDomain element = (IScribblerDomain)iter.next();
                            IResourceDescriptor[] descriptors = element.getResourceDescriptors();
                            this.resourceDescriptors.addAll(Arrays.asList(descriptors));
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        this.scribblerDomains.clear();
                        this.referenceCounts.clear();
                    }
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    ++iterationCount;
                    throw throwable;
                }
                {
                    var10_10 = null;
                    ++iterationCount;
                }
            }
            return;
        }
    }
}

