/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.saf.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.internal.saf.impl.Messages;
import org.eclipse.stp.core.internal.saf.impl.SAFActivator;
import org.eclipse.stp.core.internal.saf.impl.SAFManagerUtils;
import org.eclipse.stp.core.saf.Context;
import org.eclipse.stp.core.saf.ISAFManager;
import org.eclipse.stp.core.saf.handler.AbstractHandler;
import org.eclipse.stp.core.saf.handler.IComponentHandler;
import org.eclipse.stp.core.saf.handler.IEntryPointHandler;
import org.eclipse.stp.core.saf.handler.IExternalServiceHandler;
import org.eclipse.stp.core.saf.handler.IHandler;
import org.eclipse.stp.core.saf.handler.IInterfaceHandler;
import org.eclipse.stp.core.sca.Binding;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.SCAPackage;
import org.osgi.framework.Bundle;

public class SAFManager
implements ISAFManager {
    private static SAFManager instance = null;
    private Hashtable componentHandlers = null;
    private Hashtable externalServiceHandlers = null;
    private Hashtable entryPointHandlers = null;
    private Hashtable interfaceHandlers = null;
    private Hashtable componentKindFilters = null;
    private Hashtable externalServiceKindFilters = null;
    private Hashtable entryPointKindFilters = null;
    static String defaultComponentImplementation = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private SAFManager() {
        this.initialize();
    }

    public static ISAFManager getInstance() {
        if (instance == null) {
            instance = new SAFManager();
        }
        return instance;
    }

    private void initialize() {
        IConfigurationElement element;
        IConfigurationElement[] elements;
        IExtension extension;
        this.componentHandlers = new Hashtable();
        this.externalServiceHandlers = new Hashtable();
        this.entryPointHandlers = new Hashtable();
        this.interfaceHandlers = new Hashtable();
        IExtension[] extensions = SAFActivator.getDefault().getHandlerContributions();
        int extensionCount = extensions.length;
        int i = 0;
        while (i < extensionCount) {
            IExtension extension2 = extensions[i];
            IConfigurationElement[] elements2 = extension2.getConfigurationElements();
            int j = 0;
            while (j < elements2.length) {
                IConfigurationElement element2 = elements2[j];
                String kind = element2.getAttribute("kind");
                if (kind == null || kind.equals("")) {
                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeKindMissing, (Object)element2.getName(), (Object)extension2.getNamespace()));
                } else {
                    String descKindName = element2.getAttribute("descriptiveKindName");
                    if (descKindName == null || descKindName.equals("")) {
                        SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeDescriptiveKindNameMissing, (Object)element2.getName(), (Object)extension2.getNamespace()));
                    } else {
                        String name = element2.getAttribute("name");
                        if (name == null || name.equals("")) {
                            SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeNameMissing, (Object)element2.getName(), (Object)extension2.getNamespace()));
                        } else {
                            String description = element2.getAttribute("description");
                            String smallIconURI = element2.getAttribute("smallIcon");
                            URL smallIconURL = null;
                            if (smallIconURI != null) {
                                try {
                                    smallIconURL = this.getImageURL(smallIconURI, extension2);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeIconInvalid, (Object[])new Object[]{smallIconURI, "smallIcon", element2.getName(), extension2.getNamespace()}));
                                }
                            }
                            String largeIconURI = element2.getAttribute("largeIcon");
                            URL largeIconURL = null;
                            if (largeIconURI != null) {
                                try {
                                    largeIconURL = this.getImageURL(largeIconURI, extension2);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeIconInvalid, (Object[])new Object[]{largeIconURI, "largeIcon", element2.getName(), extension2.getNamespace()}));
                                }
                            }
                            IHandler handler = null;
                            try {
                                handler = (IHandler)element2.createExecutableExtension("class");
                            }
                            catch (Exception exception) {}
                            if (handler == null) {
                                SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_cannotLoadHandlerClass, (Object)element2.getName(), (Object)extension2.getNamespace()));
                            } else {
                                ((AbstractHandler)handler).initialize(kind, descKindName, name, description, smallIconURL, largeIconURL);
                                if (element2.getName().equals("componentHandler")) {
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.stp.core.saf.handler.AbstractComponentHandler");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.checkAndAddToHandlerMap(handler, element2, this.componentHandlers, clazz, extension2, Messages.stp_core_saf_componentHandlerAlreadyExists);
                                } else if (element2.getName().equals("externalServiceHandler")) {
                                    Class<?> clazz = class$1;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.stp.core.saf.handler.AbstractExternalServiceHandler");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.checkAndAddToHandlerMap(handler, element2, this.externalServiceHandlers, clazz, extension2, Messages.stp_core_saf_externalServiceHandlerAlreadyExists);
                                } else if (element2.getName().equals("entryPointHandler")) {
                                    Class<?> clazz = class$2;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.stp.core.saf.handler.AbstractEntryPointHandler");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.checkAndAddToHandlerMap(handler, element2, this.entryPointHandlers, clazz, extension2, Messages.stp_core_saf_entryPointHandlerAlreadyExists);
                                } else if (element2.getName().equals("interfaceHandler")) {
                                    Class<?> clazz = class$3;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.stp.core.saf.handler.AbstractInterfaceHandler");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.checkAndAddToHandlerMap(handler, element2, this.interfaceHandlers, clazz, extension2, Messages.stp_core_saf_interfaceHandlerAlreadyExists);
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        Hashtable<String, KindConstraint> stagingComponentConstraints = new Hashtable<String, KindConstraint>();
        Hashtable<String, KindConstraint> stagingEntryPointConstraints = new Hashtable<String, KindConstraint>();
        Hashtable<String, KindConstraint> stagingExternalServiceConstraints = new Hashtable<String, KindConstraint>();
        extensions = SAFActivator.getDefault().getContextContibutions();
        extensionCount = extensions.length;
        int i2 = 0;
        while (i2 < extensionCount) {
            extension = extensions[i2];
            elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                element = elements[j];
                String extensible = element.getAttribute("extensible");
                if (extensible == null || extensible.equals("")) {
                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeMissing, (Object[])new Object[]{"extensible", element.getName(), extension.getNamespace()}));
                } else {
                    boolean isExtensible = Boolean.valueOf(extensible);
                    ContextParserOutput parserOutput = this.parseContextChildren(false, element, extension, isExtensible);
                    List contextKeys = parserOutput.getContextKeys();
                    KindConstraint componentConstraint = parserOutput.getCompKindConstraint();
                    KindConstraint entryPointConstraint = parserOutput.getEpKindConstraint();
                    KindConstraint externalServiceConstraint = parserOutput.getEsKindConstraint();
                    if (!contextKeys.isEmpty()) {
                        Iterator iter = contextKeys.iterator();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            if (componentConstraint != null) {
                                if (stagingComponentConstraints.containsKey(key)) {
                                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_contextAlreadyDefinedForComponent, (Object[])new Object[]{key, extension.getNamespace()}));
                                } else {
                                    stagingComponentConstraints.put(key, componentConstraint);
                                }
                            }
                            if (entryPointConstraint != null) {
                                if (stagingEntryPointConstraints.containsKey(key)) {
                                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_contextAlreadyDefinedForEntryPoint, (Object[])new Object[]{key, extension.getNamespace()}));
                                } else {
                                    stagingEntryPointConstraints.put(key, entryPointConstraint);
                                }
                            }
                            if (externalServiceConstraint == null) continue;
                            if (stagingExternalServiceConstraints.containsKey(key)) {
                                SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_contextAlreadyDefinedForExternalService, (Object[])new Object[]{key, extension.getNamespace()}));
                                continue;
                            }
                            stagingExternalServiceConstraints.put(key, externalServiceConstraint);
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        extensions = SAFActivator.getDefault().getContextExtensionContibutions();
        extensionCount = extensions.length;
        i2 = 0;
        while (i2 < extensionCount) {
            extension = extensions[i2];
            elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                element = elements[j];
                ContextParserOutput parserOutput = this.parseContextChildren(true, element, extension, false);
                List contextKeys = parserOutput.getContextKeys();
                KindConstraint componentConstraint = parserOutput.getCompKindConstraint();
                KindConstraint entryPointConstraint = parserOutput.getEpKindConstraint();
                KindConstraint externalServiceConstraint = parserOutput.getEsKindConstraint();
                if (!contextKeys.isEmpty()) {
                    Iterator iter = contextKeys.iterator();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        if (componentConstraint != null) {
                            this.mergeContextExtensions(key, componentConstraint, stagingComponentConstraints, extension, Messages.stp_core_saf_contextComponentConstraintInvalid, Messages.stp_core_saf_contextExtensionConflictForComponent);
                        }
                        if (entryPointConstraint != null) {
                            this.mergeContextExtensions(key, entryPointConstraint, stagingEntryPointConstraints, extension, Messages.stp_core_saf_contextEntryPointConstraintInvalid, Messages.stp_core_saf_contextExtensionConflictForEntryPoint);
                        }
                        if (externalServiceConstraint == null) continue;
                        this.mergeContextExtensions(key, externalServiceConstraint, stagingExternalServiceConstraints, extension, Messages.stp_core_saf_contextExternalServiceConstraintInvalid, Messages.stp_core_saf_contextExtensionConflictForExternalService);
                    }
                }
                ++j;
            }
            ++i2;
        }
        this.componentKindFilters = this.generateKindsList(stagingComponentConstraints, this.componentHandlers);
        this.entryPointKindFilters = this.generateKindsList(stagingEntryPointConstraints, this.entryPointHandlers);
        this.externalServiceKindFilters = this.generateKindsList(stagingExternalServiceConstraints, this.externalServiceHandlers);
    }

    private void mergeContextExtensions(String contextExtensionKey, KindConstraint extConstraint, Hashtable stagingConstraintMap, IExtension extension, String contextConstraintInvalid_msg, String contextExtensionConflict_msg) {
        if (!stagingConstraintMap.containsKey(contextExtensionKey)) {
            SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)contextConstraintInvalid_msg, (Object[])new Object[]{contextExtensionKey, extension.getNamespace()}));
        } else {
            KindConstraint contextConstraint = (KindConstraint)stagingConstraintMap.get(contextExtensionKey);
            if (contextConstraint != null && !contextConstraint.isExtensible()) {
                SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_contextNotExtensible, (Object[])new Object[]{contextExtensionKey, extension.getNamespace()}));
            } else {
                boolean success = false;
                if (!(extConstraint.includes() ^ contextConstraint.includes())) {
                    Iterator iter = extConstraint.getKinds().iterator();
                    while (iter.hasNext()) {
                        String constraint = (String)iter.next();
                        if (contextConstraint.getKinds().contains(constraint)) continue;
                        contextConstraint.getKinds().add(constraint);
                    }
                    success = true;
                }
                if (!success) {
                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)contextExtensionConflict_msg, (Object[])new Object[]{contextExtensionKey, extension.getNamespace()}));
                }
            }
        }
    }

    private ContextParserOutput parseContextChildren(boolean processingExtension, IConfigurationElement context, IExtension extension, boolean isExtensible) {
        ArrayList<String> contextKeys = new ArrayList<String>();
        KindConstraint componentConstraint = null;
        KindConstraint entryPointConstraint = null;
        KindConstraint externalServiceConstraint = null;
        IConfigurationElement[] children = context.getChildren();
        int k = 0;
        while (k < children.length) {
            IConfigurationElement child = children[k];
            if (child.getName().equals("contextKey")) {
                String namespace = child.getAttribute("namespace");
                if (namespace == null || namespace.equals("")) {
                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeMissing, (Object[])new Object[]{"namespace", child.getName(), extension.getNamespace()}));
                } else {
                    String rootType = child.getAttribute("rootType");
                    if (rootType == null || rootType.equals("")) {
                        SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeMissing, (Object[])new Object[]{"rootType", child.getName(), extension.getNamespace()}));
                    } else {
                        String subType = child.getAttribute("subType");
                        contextKeys.add(this.createFilterKey(namespace, rootType, subType));
                    }
                }
            } else if (child.getName().equals("componentKindConstraint") && componentConstraint != null || child.getName().equals("entryPointKindConstraint") && entryPointConstraint != null || child.getName().equals("externalServiceKindConstraint") && externalServiceConstraint != null) {
                SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_duplicateElement, (Object[])new Object[]{child.getName(), context.getName(), extension.getNamespace()}));
            } else {
                String kindsIncluded = child.getAttribute("includeKinds");
                if (kindsIncluded == null || kindsIncluded.equals("")) {
                    SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeMissing, (Object[])new Object[]{"includeKinds", child.getName(), extension.getNamespace()}));
                } else {
                    boolean kindsInc = Boolean.valueOf(kindsIncluded);
                    String kinds = child.getAttribute("kinds");
                    if (kinds == null || kinds.equals("")) {
                        SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_attributeMissing, (Object[])new Object[]{"kinds", child.getName(), extension.getNamespace()}));
                    } else {
                        ArrayList<String> kindsList = new ArrayList<String>();
                        kinds = kinds.replaceAll("[*]", ".*");
                        StringTokenizer tokenizer = new StringTokenizer(kinds, ",");
                        while (tokenizer.hasMoreTokens()) {
                            kindsList.add(tokenizer.nextToken());
                        }
                        if (child.getName().equals("componentKindConstraint")) {
                            componentConstraint = this.expandKindsList(isExtensible, kindsInc, kindsList, this.componentHandlers);
                        } else if (child.getName().equals("entryPointKindConstraint")) {
                            entryPointConstraint = this.expandKindsList(isExtensible, kindsInc, kindsList, this.entryPointHandlers);
                        } else if (child.getName().equals("externalServiceKindConstraint")) {
                            externalServiceConstraint = this.expandKindsList(isExtensible, kindsInc, kindsList, this.externalServiceHandlers);
                        }
                    }
                }
            }
            ++k;
        }
        if (!processingExtension) {
            if (componentConstraint == null) {
                componentConstraint = new KindConstraint(true, isExtensible);
                componentConstraint.getKinds().addAll(this.componentHandlers.keySet());
            }
            if (entryPointConstraint == null) {
                entryPointConstraint = new KindConstraint(true, isExtensible);
                entryPointConstraint.getKinds().addAll(this.entryPointHandlers.keySet());
            }
            if (externalServiceConstraint == null) {
                externalServiceConstraint = new KindConstraint(true, isExtensible);
                externalServiceConstraint.getKinds().addAll(this.externalServiceHandlers.keySet());
            }
        }
        return new ContextParserOutput(contextKeys, componentConstraint, entryPointConstraint, externalServiceConstraint);
    }

    private KindConstraint expandKindsList(boolean isExtensible, boolean kindsInc, List kindsList, Hashtable handlersMap) {
        KindConstraint result = new KindConstraint(kindsInc, isExtensible);
        if (kindsList.contains(".*")) {
            result.getKinds().addAll(Arrays.asList(handlersMap.keySet().toArray()));
            return result;
        }
        Iterator iterator = handlersMap.keySet().iterator();
        block0: while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Iterator iter = kindsList.iterator();
            while (iter.hasNext()) {
                String kind = (String)iter.next();
                if (!key.matches(kind)) continue;
                result.addKind(key);
                continue block0;
            }
        }
        return result;
    }

    private Hashtable generateKindsList(Hashtable stagedMap, Hashtable handlersMap) {
        Hashtable result = new Hashtable();
        Iterator iter = stagedMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry stagedEntry = iter.next();
            Hashtable handlers = new Hashtable();
            KindConstraint constraint = (KindConstraint)stagedEntry.getValue();
            boolean include = constraint.includes();
            Iterator iterator = handlersMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry handlersEntry = iterator.next();
                if ((!include || !constraint.getKinds().contains(handlersEntry.getKey())) && (include || constraint.getKinds().contains(handlersEntry.getKey()))) continue;
                handlers.put(handlersEntry.getKey(), handlersEntry.getValue());
            }
            result.put(stagedEntry.getKey(), handlers);
        }
        return result;
    }

    private Collection getFilteredKinds(Context context, Hashtable handlers, Hashtable filters) {
        Hashtable map = null;
        if (context != null) {
            String key = this.createFilterKey(context);
            map = (Hashtable)filters.get(key);
        }
        if (map == null) {
            map = handlers;
        }
        return map.values();
    }

    private String createFilterKey(Context context) {
        return this.createFilterKey(context.getNamespace(), context.getRootType(), context.getSubType());
    }

    private String createFilterKey(String namespace, String rootType, String subType) {
        if (namespace == null && rootType == null) {
            return null;
        }
        String key = String.valueOf(namespace) + ":" + rootType;
        if (subType != null) {
            key = String.valueOf(key) + "#" + subType;
        }
        return key;
    }

    private URL getImageURL(String uri, IExtension extension) throws MalformedURLException {
        String pluginId = extension.getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL baseURL = bundle.getEntry("/");
        return new URL(baseURL, uri);
    }

    private void checkAndAddToHandlerMap(IHandler handler, IConfigurationElement element, Hashtable handlerMap, Class handlerClass, IExtension extension, String dupHandlerKey) {
        if (!handlerClass.isInstance(handler)) {
            SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)Messages.stp_core_saf_classDoesNotExtendAbstractHandler, (Object[])new Object[]{element.getAttribute("class"), extension.getNamespace(), handlerClass.getName()}));
            return;
        }
        String kind = handler.getKind();
        Object oldHandler = handlerMap.get(kind);
        if (oldHandler != null && !oldHandler.equals(handler)) {
            SAFActivator.log((Object)this, "initialize", 2, NLS.bind((String)dupHandlerKey, (Object[])new Object[]{kind, extension.getNamespace(), element.getAttribute("class")}));
        }
        handlerMap.put(kind, handler);
    }

    public IComponentHandler[] getAllComponentHandlers(Context context) {
        Collection handlers = this.getFilteredKinds(context, this.componentHandlers, this.componentKindFilters);
        return handlers.toArray(new IComponentHandler[handlers.size()]);
    }

    public IExternalServiceHandler[] getAllExternalServiceHandlers(Context context) {
        Collection handlers = this.getFilteredKinds(context, this.externalServiceHandlers, this.externalServiceKindFilters);
        return handlers.toArray(new IExternalServiceHandler[handlers.size()]);
    }

    public IEntryPointHandler[] getAllEntryPointHandlers(Context context) {
        Collection handlers = this.getFilteredKinds(context, this.entryPointHandlers, this.entryPointKindFilters);
        return handlers.toArray(new IEntryPointHandler[handlers.size()]);
    }

    public IInterfaceHandler[] getAllInterfaceHandlers() {
        Collection handlers = this.getFilteredKinds(null, this.interfaceHandlers, null);
        return handlers.toArray(new IInterfaceHandler[handlers.size()]);
    }

    public IComponentHandler[] getComponentHandlersFor(Context context, Object implementationObj) {
        ArrayList<IComponentHandler> result = new ArrayList<IComponentHandler>();
        Collection handlers = this.getFilteredKinds(context, this.componentHandlers, this.componentKindFilters);
        Iterator iter = handlers.iterator();
        while (iter.hasNext()) {
            IComponentHandler handler = (IComponentHandler)iter.next();
            try {
                if (!handler.canCreateComponentFor(implementationObj)) continue;
                result.add(handler);
            }
            catch (Exception exc) {
                SAFActivator.log((Object)this, "getComponentKindsFor", 2, exc);
            }
        }
        return result.toArray(new IComponentHandler[result.size()]);
    }

    public String getDefaultComponentKind() {
        if (defaultComponentImplementation == null) {
            defaultComponentImplementation = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract());
        }
        return defaultComponentImplementation;
    }

    private String getComponentKindOf(Component theComponent) {
        return theComponent.getType();
    }

    public IComponentHandler getHandlerFor(Component theComponent) {
        if (theComponent == null) {
            return null;
        }
        String componentKind = this.getComponentKindOf(theComponent);
        return (IComponentHandler)this.componentHandlers.get(componentKind);
    }

    public IExternalServiceHandler[] getExternalServiceHandlersFor(Context context, Object service) {
        ArrayList<IExternalServiceHandler> result = new ArrayList<IExternalServiceHandler>();
        Collection handlers = this.getFilteredKinds(context, this.externalServiceHandlers, this.externalServiceKindFilters);
        Iterator iter = handlers.iterator();
        while (iter.hasNext()) {
            IExternalServiceHandler handler = (IExternalServiceHandler)iter.next();
            try {
                if (!handler.canCreateExternalServiceFor(service)) continue;
                result.add(handler);
            }
            catch (Exception exc) {
                SAFActivator.log((Object)this, "getImportTypesFor", 2, exc);
            }
        }
        return result.toArray(new IExternalServiceHandler[result.size()]);
    }

    private List getExternalServiceKindOf(ExternalService theExternalService) {
        ArrayList<String> kinds = new ArrayList<String>();
        if (theExternalService != null && theExternalService.getBindings() != null && !theExternalService.getBindings().isEmpty()) {
            List bindings = theExternalService.getBindings();
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                Binding binding = (Binding)iter.next();
                kinds.add(SAFManagerUtils.getSubstitutionGroupName((SCAObject)binding));
            }
        }
        return kinds;
    }

    public IExternalServiceHandler[] getHandlersFor(ExternalService theExternalService) {
        if (theExternalService == null) {
            return null;
        }
        ArrayList<IExternalServiceHandler> descriptors = new ArrayList<IExternalServiceHandler>();
        List bindingTypes = this.getExternalServiceKindOf(theExternalService);
        Iterator iter = bindingTypes.iterator();
        while (iter.hasNext()) {
            String bindingType = (String)iter.next();
            IExternalServiceHandler descriptor = (IExternalServiceHandler)this.externalServiceHandlers.get(bindingType);
            if (descriptors == null || descriptors.contains(descriptor)) continue;
            descriptors.add(descriptor);
        }
        return descriptors.toArray(new IExternalServiceHandler[descriptors.size()]);
    }

    public IEntryPointHandler[] getEntryPointHandlersFor(Context context, Object service) {
        ArrayList<IEntryPointHandler> result = new ArrayList<IEntryPointHandler>();
        Collection handlers = this.getFilteredKinds(context, this.entryPointHandlers, this.entryPointKindFilters);
        Iterator iter = handlers.iterator();
        while (iter.hasNext()) {
            IEntryPointHandler handler = (IEntryPointHandler)iter.next();
            try {
                if (!handler.canCreateEntryPointFor(service)) continue;
                result.add(handler);
            }
            catch (Exception exc) {
                SAFActivator.log((Object)this, "getEntryPointKindsFor", 2, exc);
            }
        }
        return result.toArray(new IEntryPointHandler[result.size()]);
    }

    private List getEntryPointKindOf(EntryPoint theEntryPoint) {
        ArrayList<String> kinds = new ArrayList<String>();
        if (theEntryPoint != null && theEntryPoint.getBindings() != null && !theEntryPoint.getBindings().isEmpty()) {
            List bindings = theEntryPoint.getBindings();
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                Binding binding = (Binding)iter.next();
                kinds.add(SAFManagerUtils.getSubstitutionGroupName((SCAObject)binding));
            }
        }
        return kinds;
    }

    public IEntryPointHandler[] getHandlersFor(EntryPoint theEntryPoint) {
        if (theEntryPoint == null) {
            return null;
        }
        ArrayList<IEntryPointHandler> descriptors = new ArrayList<IEntryPointHandler>();
        List bindingTypes = this.getEntryPointKindOf(theEntryPoint);
        Iterator iter = bindingTypes.iterator();
        while (iter.hasNext()) {
            String bindingType = (String)iter.next();
            IEntryPointHandler handler = (IEntryPointHandler)this.entryPointHandlers.get(bindingType);
            if (handler == null || descriptors.contains(handler)) continue;
            descriptors.add(handler);
        }
        return descriptors.toArray(new IEntryPointHandler[descriptors.size()]);
    }

    private String getInterfaceKindOf(Interface theInterface) {
        return SAFManagerUtils.getSubstitutionGroupName((SCAObject)theInterface);
    }

    public IInterfaceHandler getHandlerFor(Interface theInterface) {
        if (theInterface == null) {
            return null;
        }
        String interfaceKind = this.getInterfaceKindOf(theInterface);
        return (IInterfaceHandler)this.interfaceHandlers.get(interfaceKind);
    }

    public IInterfaceHandler[] getInterfaceHandlersFor(Object interfaceObj) {
        ArrayList<IInterfaceHandler> result = new ArrayList<IInterfaceHandler>();
        Collection handlers = this.getFilteredKinds(null, this.interfaceHandlers, null);
        Iterator iter = handlers.iterator();
        while (iter.hasNext()) {
            IInterfaceHandler handler = (IInterfaceHandler)iter.next();
            try {
                if (!handler.canCreateInterfaceFor(interfaceObj)) continue;
                result.add(handler);
            }
            catch (Exception exc) {
                SAFActivator.log((Object)this, "getInterfaceKindsFor", 2, exc);
            }
        }
        return result.toArray(new IInterfaceHandler[result.size()]);
    }

    private class KindConstraint {
        private boolean includes = true;
        private boolean extensible = true;
        private List kinds = null;

        public KindConstraint(boolean include, boolean extensible) {
            this.includes = include;
            this.extensible = extensible;
            this.kinds = new ArrayList();
        }

        public boolean isExtensible() {
            return this.extensible;
        }

        public boolean includes() {
            return this.includes;
        }

        public void addKind(String kind) {
            this.kinds.add(kind);
        }

        public List getKinds() {
            return this.kinds;
        }
    }

    private class ContextParserOutput {
        private List contextKeys;
        private KindConstraint compKindConstraint;
        private KindConstraint epKindConstraint;
        private KindConstraint esKindConstraint;

        public ContextParserOutput(List contextKeys, KindConstraint compKindConstraint, KindConstraint epKindConstraint, KindConstraint esKindConstraint) {
            this.contextKeys = contextKeys;
            this.compKindConstraint = compKindConstraint;
            this.epKindConstraint = epKindConstraint;
            this.esKindConstraint = esKindConstraint;
        }

        public KindConstraint getCompKindConstraint() {
            return this.compKindConstraint;
        }

        public List getContextKeys() {
            return this.contextKeys;
        }

        public KindConstraint getEpKindConstraint() {
            return this.epKindConstraint;
        }

        public KindConstraint getEsKindConstraint() {
            return this.esKindConstraint;
        }
    }
}

