/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.saf.handler;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.internal.saf.impl.Messages;
import org.eclipse.stp.core.saf.ISAFManager;
import org.eclipse.stp.core.saf.IUIContext;
import org.eclipse.stp.core.saf.exception.InvalidOperationException;
import org.eclipse.stp.core.saf.exception.SAFException;
import org.eclipse.stp.core.saf.handler.AbstractHandler;
import org.eclipse.stp.core.saf.handler.IComponentHandler;
import org.eclipse.stp.core.saf.handler.IInterfaceHandler;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public abstract class AbstractComponentHandler
extends AbstractHandler
implements IComponentHandler {
    static /* synthetic */ Class class$0;

    public boolean canCreateComponent() {
        return true;
    }

    public boolean canAddReference() {
        return true;
    }

    public boolean canAddService() {
        return true;
    }

    public boolean canSetInterface() {
        return true;
    }

    public boolean canCreateComponentFor(Object implementationObj) {
        return false;
    }

    public SCAObject[] createComponentFor(Object implementationObj, IContainer container, IUIContext callback) throws SAFException, InterruptedException {
        throw new SAFException(Messages.stp_core_saf_operationNotSupportedForComponentKind);
    }

    public boolean canCreateImplementation() {
        return true;
    }

    public boolean canSetImplementation() {
        return false;
    }

    public IDataModelOperation setImplementation(Component component, Object implementationFile, IUIContext callback) throws SAFException, InterruptedException {
        throw new SAFException(Messages.stp_core_saf_operationNotSupportedForComponentKind);
    }

    public boolean isInterfaceKindSupported(IInterfaceHandler interfaceHandler, boolean interfaceSet) throws SAFException {
        return true;
    }

    public final IDataModelOperation setKind(Component theComponent) throws SAFException, InvalidOperationException {
        Class<?> clazz;
        if (theComponent == null) {
            throw new SAFException(Messages.stp_core_saf_componentMustNotBeNull);
        }
        ComponentType compType = theComponent.resolveComponentType();
        if (compType != null && !compType.getServices().isEmpty()) {
            String unsupportedKinds = null;
            Iterator iter = compType.getServices().iterator();
            while (iter.hasNext()) {
                Interface interfaceObj = ((Service)iter.next()).getInterface();
                IInterfaceHandler interfaceHandler = ISAFManager.INSTANCE.getHandlerFor(interfaceObj);
                if (interfaceHandler == null || this.isInterfaceKindSupported(interfaceHandler, true)) continue;
                unsupportedKinds = unsupportedKinds == null ? interfaceHandler.getKind() : ", " + interfaceHandler.getKind();
            }
            if (unsupportedKinds != null) {
                String message = NLS.bind((String)Messages.stp_core_saf_unableToSetComponentKind, (Object)this.getKind(), unsupportedKinds);
                throw new InvalidOperationException(message);
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.stp.core.internal.operations.ComponentTypingDataModelProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDataModel model = DataModelFactory.createDataModel((Class)clazz);
        model.setStringProperty("IComponentTypingDataModelProperties.TYPE", this.getKind());
        model.setBooleanProperty("IComponentTypingDataModelProperties.SET_TYPE", true);
        model.setProperty("IComponentTypingDataModelProperties.COMPONENT", (Object)theComponent);
        IStatus status = model.validate();
        if (status.isOK()) {
            return model.getDefaultOperation();
        }
        if (status.getException() instanceof InvalidOperationException) {
            throw (InvalidOperationException)status.getException();
        }
        throw new SAFException(status.getMessage(), status.getException());
    }

    public final IDataModelOperation resetKind(Component theComponent) throws SAFException, InvalidOperationException {
        if (theComponent == null) {
            throw new SAFException(Messages.stp_core_saf_componentMustNotBeNull);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.stp.core.internal.operations.ComponentTypingDataModelProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDataModel model = DataModelFactory.createDataModel((Class)clazz);
        model.setProperty("IComponentTypingDataModelProperties.COMPONENT", (Object)theComponent);
        IStatus status = model.validate();
        if (status.isOK()) {
            return model.getDefaultOperation();
        }
        throw new SAFException(status.getMessage());
    }
}

