/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.saf.ui.contribution;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.core.internal.saf.ui.Activator;
import org.eclipse.stp.core.internal.saf.ui.Messages;
import org.eclipse.stp.core.saf.ui.contribution.ISOAPropertiesEntry;
import org.eclipse.stp.core.saf.ui.contribution.SOAPropertiesEntry;

public class SOAPropertiesRegistry {
    private static final String EXTENSION_POINT_PROPERTIES_CONTRIBUTION = "propertiesContribution";
    private static SOAPropertiesRegistry _registry = null;
    private Hashtable _entries = null;

    public static SOAPropertiesRegistry getRegistry() {
        if (_registry == null) {
            _registry = new SOAPropertiesRegistry();
            SOAPropertiesRegistry.init(_registry);
        }
        return _registry;
    }

    private static void init(SOAPropertiesRegistry registry) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_PROPERTIES_CONTRIBUTION);
        if (extensionPoint != null) {
            IConfigurationElement[] policyExtensions = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < policyExtensions.length) {
                IConfigurationElement element = policyExtensions[i];
                try {
                    SOAPropertiesEntry entry = new SOAPropertiesEntry(element);
                    registry.addEntry(entry);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++i;
            }
        }
    }

    public void addEntry(ISOAPropertiesEntry entry) {
        QName key = new QName(entry.getNamespaceURI(), entry.getTypeName());
        Enumeration enum1 = this.getEntries().elements();
        while (enum1.hasMoreElements()) {
            ISOAPropertiesEntry contribution = (ISOAPropertiesEntry)enum1.nextElement();
            if (!contribution.getId().equals(entry.getId())) continue;
            Activator.internalReportConfigurationError(Messages.Duplicate_id, new String[]{entry.getId(), entry.getContributorPluginID(), contribution.getContributorPluginID()});
            return;
        }
        ISOAPropertiesEntry existingEntry = (ISOAPropertiesEntry)this.getEntries().get(key);
        if (existingEntry != null) {
            Activator.internalReportConfigurationError(Messages.Duplicate_name, new String[]{entry.getId(), existingEntry.getId(), entry.getNamespaceURI(), entry.getTypeName()});
            return;
        }
        this.getEntries().put(key, entry);
    }

    public ISOAPropertiesEntry getEntry(String namespaceURI, String typeName) {
        QName key = new QName(namespaceURI, typeName);
        return (ISOAPropertiesEntry)this.getEntries().get(key);
    }

    public Enumeration getEntryEnumeration() {
        return this.getEntries().elements();
    }

    private Hashtable getEntries() {
        if (this._entries == null) {
            this._entries = new Hashtable();
        }
        return this._entries;
    }

    private class QName {
        private String _nameSpace;
        private String _localName;
        private final String TOSTRING_OPEN_BRACE = "{";
        private final String TOSTRING_CLOSE_BRACE = "}";

        public QName(String nameSpace, String localName) {
            Assert.isNotNull((Object)nameSpace);
            Assert.isNotNull((Object)localName);
            this._nameSpace = nameSpace;
            this._localName = localName;
        }

        public String getNamespace() {
            return this._nameSpace;
        }

        public String getLocalName() {
            return this._localName;
        }

        public boolean equals(Object obj) {
            QName qname;
            boolean isEquals = false;
            if (obj instanceof QName && this._localName.equals((qname = (QName)obj).getLocalName()) && this._nameSpace.equals(qname.getNamespace())) {
                isEquals = true;
            }
            return isEquals;
        }

        public int hashCode() {
            int hash = 0;
            hash += this._localName.hashCode();
            return hash += this._nameSpace.hashCode();
        }

        public String toString() {
            return "{" + this._nameSpace + "}" + this._localName;
        }
    }
}

