/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ComponentCreationOperation extends AbstractScribblerOperation {
   public ComponentCreationOperation(IDataModel model) {
      super(model);
   }

   protected IStatus doExecute(IProgressMonitor monitor)
         throws ExecutionException {
      Component createdComponent = null;

      createdComponent = SCAFactory.eINSTANCE.createImplementationComponent();
      createdComponent.setName(model
            .getStringProperty(IComponentCreationDataModelProperties.NAME));
      // TODO Fix to setup the correct implementation
      // createdComponent.setImplementationURI(model.getStringProperty(IComponentCreationDataModelProperties.IMPLEMENTATION_URI));

      // TODO Deal with PropertyValuesSet and ReferenceValuesSet

      Composite composite = (Composite) model
            .getProperty(IComponentCreationDataModelProperties.COMPOSITE);
      if (composite != null)
         composite.getComponents().add(createdComponent);

      model.setProperty(IAbstractScribblerDataModelProperties.RESULT,
            createdComponent);
      return OK_STATUS;
   }

   protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }

   protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }
}
