/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stp.core.resources.SOAConstants;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ComponentTypeCreationOperation extends
      RootSCAModelCreationOperation {
   public ComponentTypeCreationOperation(IDataModel model) {
      super(model);
   }

   protected URI getResourceURI() {
      // Buld the component resource URI and return it.
      String componentTypeName = model
            .getStringProperty(IComponentTypeCreationDataModelProperties.NAME);
      IContainer container = (IContainer) model
            .getProperty(IComponentTypeCreationDataModelProperties.CONTAINER);
      return URI.createPlatformResourceURI(container.getFullPath().append(
            componentTypeName + '.' + SOAConstants.COMPONENT_TYPE_EXT)
            .toString());
   }

   protected void setAdditionalProperties(ComponentType componentType) {
      componentType.setName(model
            .getStringProperty(IComponentTypeCreationDataModelProperties.NAME));
      setProperties(componentType);
      setReferences(componentType);
      setServices(componentType);
   }

   private void setServices(ComponentType componentType) {
      List services = (List) model
            .getProperty(IComponentTypeCreationDataModelProperties.SERVICES);
      for (int i = 0; i < services.size(); i++) {
         Service service = (Service) services.get(i);
         if (service != null) {
            Service newService = SCAFactory.eINSTANCE.createService();
            newService.setName(service.getName());
            Interface interface_ = null;
            // JavaInterface?
            interface_ = SCAFactory.eINSTANCE.createJavaInterface();
            ((JavaInterface) interface_).setInterface(((JavaInterface) service
                  .getInterface()).getInterface());

            // WSDLPortType?
            // TODO

            newService.setInterface(interface_);
            componentType.getServices().add(newService);
         }
      }
   }

   private void setReferences(ComponentType componentType) {
      List references = (List) model
            .getProperty(IComponentTypeCreationDataModelProperties.REFERENCES);
      for (int i = 0; i < references.size(); i++) {
         Reference reference = (Reference) references.get(i);
         if (reference != null) {
            Reference newReference = SCAFactory.eINSTANCE.createReference();
            newReference.setName(reference.getName());
            Interface interface_ = null;
            // JavInterface?
            interface_ = SCAFactory.eINSTANCE.createJavaInterface();
            ((JavaInterface) interface_)
                  .setInterface(((JavaInterface) reference.getInterface())
                        .getInterface());

            // WSDLPortType?
            // TODO

            newReference.setInterface(interface_);
            newReference.setMultiplicity(reference.getMultiplicity());
            componentType.getReferences().add(newReference);
         }
      }
   }

   private void setProperties(ComponentType componentType) {
      List properties = (List) model
            .getProperty(IComponentTypeCreationDataModelProperties.PROPERTIES);
      for (int i = 0; i < properties.size(); i++) {
         Property property = (Property) properties.get(i);
         if (property != null) {
            Property newProperty = SCAFactory.eINSTANCE.createProperty();
            newProperty.setName(property.getName());
            newProperty.setDefault(property.getDefault());
            newProperty.setMany(property.isMany());
            newProperty.setRequired(property.isRequired());
            newProperty.setType(property.getType());

            componentType.getProperties().add(newProperty);
         }
      }
   }

   protected SCAObject createAndAddSCAModelToRoot(SCACoreRoot root) {
      if (root != null) {
         ComponentType componentType = SCAPackage.eINSTANCE.getSCAFactory()
               .createComponentType();

         setAdditionalProperties(componentType);

         if (componentType != null)
            root.setComponentType(componentType);

         return componentType;
      }

      return null;
   }
}
