/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection;

import java.io.IOException;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.introspection.IModelIntrospectionManager;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;

/**
 * 
 * We need some further definition around what this lifecycle should look like.
 * 
 * Clients currently have no need to access this resource directly.
 * 
 * @since 1.0
 * 
 */
public class AbstractComponentTypeResource extends ResourceImpl {

   protected AbstractComponentTypeResource(URI uri) {
      super(uri);
   }

   public void load(Map options) {

      SCACoreRoot root = SCAFactory.eINSTANCE.createSCACoreRoot();
      ComponentType componentType = SCAFactory.eINSTANCE.createComponentType();
      root.setComponentType(componentType);
      getContents().add(root);

      IModelIntrospectionManager.eINSTANCE.bind(componentType, getURI());
   }

   public void save(Map options) throws IOException {
      if (getContents().size() == 1) {
         SCACoreRoot root = (SCACoreRoot) getContents().get(0);
         ComponentType cType = root.getComponentType();
         if (cType != null) {
            IComponentTypeIntrospector introspector = (IComponentTypeIntrospector) EcoreUtil
                  .getAdapter(cType.getEObject().eAdapters(),
                        IComponentTypeIntrospector.ADAPTER_TYPE);
            if (introspector != null) {
               IStatus status = introspector.save();
               if (status.isOK())
                  setModified(false);
               else {
                  throw new IOException(status.getMessage());
               }
            }
         }
      }
   }

   protected void doUnload() {
      // System.err.println("Unloading " + getURI()); //$NON-NLS-1$
      // we test directly instead of calling getConents() to make
      // sure we never trip any "load on demand" logic
      if (contents != null && contents.size() > 0) {

         SCACoreRoot root = (SCACoreRoot) contents.get(0);
         if (root.getComponentType() != null) {
            IModelIntrospectionManager.eINSTANCE
                  .unbind(root.getComponentType());
         }
      }
      super.doUnload();
   }

}
