/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca.impl;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.stp.core.internal.introspection.ISafeIntrospector;

public class EObjectContainmentIntrospectingEList extends
      EObjectContainmentEList {

   /**
    * 
    */
   private static final long serialVersionUID = -3924988299001627583L;

   private ISafeIntrospector introspector;

   public EObjectContainmentIntrospectingEList(Class dataClass,
         InternalEObject owner, int featureID, ISafeIntrospector anIntrospector) {
      super(dataClass, owner, featureID);
      introspector = anIntrospector;
      introspector.setTargetList(this);
      introspect();
   }

   public void refresh() {
      introspect();
   }

   private void introspect() {
      Platform.run(introspector);
   }
}
