/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;

/**
 * This wire target represents a target that is just a simple URI to an external
 * service such as a web service.
 * 
 * @since 1.0
 * 
 */
public class SimplifiedExternalWireTargetImpl extends SCAObjectImpl implements
      WireTarget {
   private String    targetURI;

   private Interface interfaze;

   SimplifiedExternalWireTargetImpl(String targetURI, Interface interfaze) {
      Assert.isNotNullOrEmtpy(targetURI, null);
      Assert.isNotNull(interfaze);
      this.targetURI = targetURI;
      this.interfaze = interfaze;
   }

   public Interface getInterface() {
      return interfaze;
   }

   public boolean matches(WireSource wireSource) {
      Assert.isNotNull(wireSource);
      if (getInterface() != null)
         return getInterface().equals(wireSource.getInterface());
      return false;
   }

   public int getFlags() {
      return IConstants.F_DEFAULT;
   }

   public EObject getEObject() {
      // Assert.isNotSupported("SimplifiedExternalWireTargetImpl#getEObject()");
      return null;
   }

   public void setName(String name) {
      Assert.isNotSupported("SimplifiedExternalWireTargetImpl#setName(String)"); //$NON-NLS-1$
   }

   public String getName() {
      return targetURI;
   }

   public String toString() {
      return targetURI;
   }

   public boolean isResolved() {
      // TODO What does this mean?
      return true;
   }

   public boolean isComponentOwned() {
      return false;
   }
}
