/**
 * <copyright> </copyright>
 * 
 * $Id: ModuleComponentItemProvider.java,v 1.2 2006/04/05 14:26:13 melder Exp $
 */
package org.eclipse.stp.core.sca.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ModuleComponent;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * This is the item provider adapter for a
 * {@link org.eclipse.stp.core.sca.ModuleComponent} object. <!-- begin-user-doc
 * --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class ModuleComponentItemProvider extends ComponentItemProvider
      implements IEditingDomainItemProvider, IStructuredItemContentProvider,
      ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * This constructs an instance from a factory and a notifier. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ModuleComponentItemProvider(AdapterFactory adapterFactory) {
      super(adapterFactory);
   }

   /**
    * This returns the property descriptors for the adapted class. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getPropertyDescriptors(Object object) {
      if (itemPropertyDescriptors == null) {
         super.getPropertyDescriptors(object);

         addModulePropertyDescriptor(object);
         addUriPropertyDescriptor(object);
      }
      return itemPropertyDescriptors;
   }

   /**
    * This adds a property descriptor for the Module feature. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void addModulePropertyDescriptor(Object object) {
      itemPropertyDescriptors
            .add(createItemPropertyDescriptor(
                  ((ComposeableAdapterFactory) adapterFactory)
                        .getRootAdapterFactory(),
                  getResourceLocator(),
                  getString("_UI_ModuleComponent_module_feature"), //$NON-NLS-1$
                  getString(
                        "_UI_PropertyDescriptor_description", "_UI_ModuleComponent_module_feature", "_UI_ModuleComponent_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                  SCAPackage.eINSTANCE.getModuleComponent_Module(), true,
                  ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
   }

   /**
    * This adds a property descriptor for the Uri feature. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void addUriPropertyDescriptor(Object object) {
      itemPropertyDescriptors
            .add(createItemPropertyDescriptor(
                  ((ComposeableAdapterFactory) adapterFactory)
                        .getRootAdapterFactory(),
                  getResourceLocator(),
                  getString("_UI_ModuleComponent_uri_feature"), //$NON-NLS-1$
                  getString(
                        "_UI_PropertyDescriptor_description", "_UI_ModuleComponent_uri_feature", "_UI_ModuleComponent_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                  SCAPackage.eINSTANCE.getModuleComponent_Uri(), true,
                  ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
   }

   /**
    * This specifies how to implement {@link #getChildren} and is used to deduce
    * an appropriate feature for an
    * {@link org.eclipse.emf.edit.command.AddCommand},
    * {@link org.eclipse.emf.edit.command.RemoveCommand} or
    * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Collection getChildrenFeatures(Object object) {
      if (childrenFeatures == null) {
         super.getChildrenFeatures(object);
         childrenFeatures.add(SCAPackage.eINSTANCE.getModuleComponent_Any());
         childrenFeatures.add(SCAPackage.eINSTANCE
               .getModuleComponent_AnyAttribute());
      }
      return childrenFeatures;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EStructuralFeature getChildFeature(Object object, Object child) {
      // Check the type of the specified child object and return the proper
      // feature to use for
      // adding (see {@link AddCommand}) it as a child.

      return super.getChildFeature(object, child);
   }

   /**
    * This returns ModuleComponent.gif. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public Object getImage(Object object) {
      return getResourceLocator().getImage("full/obj16/ModuleComponent"); //$NON-NLS-1$
   }

   /**
    * This returns the label text for the adapted class. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getText(Object object) {
      String label = ((ModuleComponent) object).getName();
      return label == null || label.length() == 0 ? getString("_UI_ModuleComponent_type") : //$NON-NLS-1$
            getString("_UI_ModuleComponent_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
   }

   /**
    * This handles model notifications by calling {@link #updateChildren} to
    * update any cached children and by creating a viewer notification, which it
    * passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public void notifyChanged(Notification notification) {
      updateChildren(notification);

      switch (notification.getFeatureID(ModuleComponent.class)) {
         case SCAPackage.MODULE_COMPONENT__MODULE:
         case SCAPackage.MODULE_COMPONENT__URI:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), false, true));
            return;
         case SCAPackage.MODULE_COMPONENT__ANY:
         case SCAPackage.MODULE_COMPONENT__ANY_ATTRIBUTE:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), true, false));
            return;
      }
      super.notifyChanged(notification);
   }

   /**
    * This adds to the collection of
    * {@link org.eclipse.emf.edit.command.CommandParameter}s describing all of
    * the children that can be created under this object. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void collectNewChildDescriptors(Collection newChildDescriptors,
         Object object) {
      super.collectNewChildDescriptors(newChildDescriptors, object);
   }

   /**
    * Return the resource locator for this item provider's resources. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ResourceLocator getResourceLocator() {
      return STPCorePlugin.INSTANCE;
   }

}
