/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.util;

import java.io.Serializable;

import javax.wsdl.PortType;

import org.eclipse.jdt.core.IType;

public class InterfaceField implements Serializable {
   private static final long serialVersionUID = 1L;

   private Object            interfaceObject  = null;

   public InterfaceField(Object interfaceObject) {
      this.interfaceObject = interfaceObject;
   }

   public Object getInterfaceObject() {
      return interfaceObject;
   }

   public String toString() {
      StringBuffer s = new StringBuffer();
      s.append(" "); //$NON-NLS-1$
      if (interfaceObject instanceof IType)
         s.append(((IType) interfaceObject).getFullyQualifiedName());
      else
         s.append(((PortType) interfaceObject).getQName().getLocalPart());

      return s.toString();
   }
}
