/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.ui.contribution;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.stp.core.internal.saf.ui.Activator;
import org.eclipse.stp.core.internal.saf.ui.Messages;

 
/**
 * An entry in the {@link SOAPropertiesRegistry}
 */
public class SOAPropertiesEntry implements ISOAPropertiesEntry {
	
	private static final String ATTR_ID			 		= "id";												//$NON-NLS-1$
	private static final String ATTR_NAMESPACE_URI 		= "namespaceURI";									//$NON-NLS-1$
	private static final String ATTR_TYPE_NAME			= "typeName";										//$NON-NLS-1$
	private static final String ATTR_CLASS				= "class";											//$NON-NLS-1$
	
	private IConfigurationElement _element;
	private String _id;
	private String _namespaceURI;
	private String _typeName;
	private String _className;
	
	private ISOAPropertiesContribution 		_contributor;
	
	private String										_contributorPluginID = null;
	
	/**
	 * @param element the configuration element
	 * 
	 * @throws IllegalArgumentException
	 */
	public SOAPropertiesEntry(IConfigurationElement element) throws IllegalArgumentException {
		_element = element;
		
		String value;

		value = element.getAttribute(ATTR_ID);
		if (value == null || value.length() == 0) {
			String error = Activator.internalReportConfigurationError(Messages.Missing_id, new String[] {getContributorPluginID()});
			throw new IllegalArgumentException(error);
		}
		_id = value;

		value = element.getAttribute(ATTR_NAMESPACE_URI);
		if (value == null || value.length() == 0) {
			String error = Activator.internalReportConfigurationError(Messages.Missing_attribute,
					new String[] {getId(), ATTR_NAMESPACE_URI});
			throw new IllegalArgumentException(error);
		}
		_namespaceURI = value;

		value = element.getAttribute(ATTR_TYPE_NAME);
		if (value == null || value.length() == 0) {
			String error = Activator.internalReportConfigurationError(Messages.Missing_attribute,
					new String[] {getId(), ATTR_TYPE_NAME});
			throw new IllegalArgumentException(error);
		}
		_typeName = value;

		value = element.getAttribute(ATTR_CLASS);
		if (value == null || value.length() == 0) {
			String error = Activator.internalReportConfigurationError(Messages.Missing_attribute,
					new String[] {getId(), ATTR_CLASS});
			throw new IllegalArgumentException(error);
		}
		_className = value;
		
	}
	
	public ISOAPropertiesContribution getContributor() {
		// TODO: remove call to tracing after debugging is finished
		if (_contributor == null) {
			_contributor = newContributor();
		}
		return _contributor;
	}
	
	/**
	 * Creates a new contribution
	 * 
	 * @return the new contribution
	 */
	public ISOAPropertiesContribution newContributor() {
		ISOAPropertiesContribution contributor = null;
		try {
			contributor = (ISOAPropertiesContribution)_element.createExecutableExtension(ATTR_CLASS);
		} catch (CoreException exc) {
			Activator.internalReportConfigurationError(Messages.Cannot_create_instance,
					new String[] {getId(), getTypeName(), exc.getLocalizedMessage()});
		} catch (ClassCastException exc) {
			Activator.internalReportConfigurationError(Messages.Class_must_implement,
					new String[] {getId(), getTypeName()});
		}
		return contributor;
	}
	
	/**
	 * Identifies the contributing plugin
	 * @return the bundle
	 */
	public String getContributorPluginID() {
		if (_contributorPluginID == null) {
			IExtension extension = _element.getDeclaringExtension();
			_contributorPluginID = extension.getNamespaceIdentifier();
		}
		return _contributorPluginID;
	}
	
	/**
	 * Identifies the ID
	 * @return the ID
	 */
	public String getId() {
		return _id;
	}
	
	/**
	 * Identifies the typeName
	 * @return the type name
	 */
	public String getTypeName() {
		return _typeName;
	}
	
	/**
	 * Identifies the className
	 * @return the class name
	 */
	public String getClassName() {
		return _className;
	}

	/**
	 * Identifies the namespaceURI of the type
	 * @return the namespaceURI of the type
	 */
	public String getNamespaceURI() {
		return _namespaceURI;
	}
}
