/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.exception;

/**
 * This exception can be thrown by methods in ISAFManager to report errors.
 */
public class SAFException extends Exception {

	/**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = -5037325510775193492L;
	/**
	 * Default constructor
	 */
	public SAFException() {
    	super();
    }

    /**
     * Creates an exception object from an error message.
     * 
     * @param message translated text describing the error
     */
    public SAFException(String message) {
    	super(message);
    }

    /**
     * Creates an exception object from an error message and another exception.
     * 
     * @param message translated text describing the error
     * @param cause the base exception object
     */
    public SAFException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates an exception object from another exception.
     * 
	 * @param cause the base exception object
     */
    public SAFException(Throwable cause) {
        super(cause);
    }
    
}
