/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.emf.controls;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class EMFControl {
    private Control mControl;
    private EObject mOwner;
    private EStructuralFeature mFeature;
    private Adapter mModelListener;

    public EMFControl(Control control, EStructuralFeature feature) {
        this.mControl = control;
        this.mOwner = null;
        this.mFeature = feature;
        this.mModelListener = new ModelListener();
        this.addDisposeListener();
    }

    public Control getControl() {
        return this.mControl;
    }

    public EObject getOwner() {
        return this.mOwner;
    }

    public void setOwner(EObject owner) {
        this.removeModelListener();
        this.mOwner = owner;
        this.addModelListener();
        this.setControlValue(this.getModelValue());
    }

    public EStructuralFeature getFeature() {
        return this.mFeature;
    }

    public abstract Object getControlValue();

    public abstract void setControlValue(Object var1);

    public Object getModelValue() {
        Object retVal = this.mOwner == null ? null : this.mOwner.eGet(this.mFeature);
        return retVal;
    }

    public void setModelValue(Object value) {
        Object curValue = this.getControlValue();
        if (this.mOwner != null && (curValue != null && !curValue.equals(value) || curValue == null && value != null)) {
            EditingDomain domain = this.getEditingDomain();
            if (domain == null) {
                this.mOwner.eSet(this.mFeature, value);
            } else {
                domain.getCommandStack().execute(SetCommand.create((EditingDomain)domain, (Object)this.mOwner, (Object)this.mFeature, (Object)value));
            }
        }
    }

    public EditingDomain getEditingDomain() {
        EditingDomain retVal = this.mOwner == null ? null : AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.mOwner);
        return retVal;
    }

    private void addModelListener() {
        if (this.mOwner != null) {
            this.mOwner.eAdapters().add((Object)this.mModelListener);
        }
    }

    private void removeModelListener() {
        if (this.mOwner != null) {
            this.mOwner.eAdapters().remove((Object)this.mModelListener);
        }
    }

    private void addDisposeListener() {
        this.mControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EMFControl.this.removeModelListener();
            }
        });
    }

    private class ModelListener
    extends AdapterImpl {
        ModelListener() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (!notification.isTouch()) {
                Object controlValue = EMFControl.this.getControlValue();
                Object modelValue = EMFControl.this.getModelValue();
                if (controlValue != null && !controlValue.equals(modelValue) || controlValue == null && modelValue != null) {
                    EMFControl.this.setControlValue(modelValue);
                }
            }
        }
    }
}

