/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.emf.refactoring;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.stp.soas.internal.deploy.emf.refactoring.IReferenceNameChangeExtension;
import org.eclipse.ui.PlatformUI;

public class ResourceNameChangeAdapter
extends EContentAdapter {
    private IResourceChangeListener mResourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            ResourceNameChangeAdapter.this.handleResourceChanged(event);
        }
    };
    private Map mIResourceToObjectListMap = new HashMap();
    private Map mEReferenceToExtension = new HashMap();
    private boolean mProcessingNameChange = false;

    public static IResource getWorkspaceResource(URI uri) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(FileLocator.toFileURL((URL)new URL(uri.toString())).getFile()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ResourceNameChangeAdapter() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.mResourceChangeListener, 1);
    }

    public ResourceNameChangeAdapter(List extensions) {
        this();
        this.addReferenceExtensions(extensions);
    }

    public void addReferenceExtension(IReferenceNameChangeExtension extension) {
        this.mEReferenceToExtension.put(extension.getFeature(), extension);
    }

    public void addReferenceExtensions(List extensions) {
        if (extensions != null) {
            Iterator it = extensions.iterator();
            while (it.hasNext()) {
                this.addReferenceExtension((IReferenceNameChangeExtension)it.next());
            }
        }
    }

    public void notifyChanged(Notification msg) {
        block16: {
            try {
                if (this.mProcessingNameChange) break block16;
                if (!this.mEReferenceToExtension.isEmpty()) {
                    super.notifyChanged(msg);
                }
                if (msg.getNotifier() instanceof ResourceSet) {
                    this.handleResourceSetChanged(msg);
                    break block16;
                }
                if (this.mEReferenceToExtension.containsKey(msg.getFeature())) {
                    this.handleExtensionReferenceChanged(msg);
                    break block16;
                }
                if (!(msg.getFeature() instanceof EReference)) break block16;
                switch (msg.getEventType()) {
                    case 1: {
                        if (msg.getOldValue() instanceof EObject) {
                            this.unregisterExistingObject((EObject)msg.getOldValue());
                        }
                        if (!(msg.getNewValue() instanceof EObject)) break;
                        this.registerExistingObject((EObject)msg.getNewValue());
                        break;
                    }
                    case 2: {
                        if (!(msg.getOldValue() instanceof EObject)) break;
                        this.unregisterExistingObject((EObject)msg.getOldValue());
                        break;
                    }
                    case 3: {
                        if (!(msg.getNewValue() instanceof EObject)) break;
                        this.registerExistingObject((EObject)msg.getNewValue());
                        break;
                    }
                    case 5: {
                        Iterator it = ((List)msg.getNewValue()).iterator();
                        while (it.hasNext()) {
                            Object next = it.next();
                            if (!(next instanceof EObject)) continue;
                            this.registerExistingObject((EObject)next);
                        }
                        break;
                    }
                    case 4: {
                        if (!(msg.getOldValue() instanceof EObject)) break;
                        this.unregisterExistingObject((EObject)msg.getOldValue());
                        break;
                    }
                    case 6: {
                        Iterator it = ((List)msg.getOldValue()).iterator();
                        while (it.hasNext()) {
                            Object next = it.next();
                            if (!(next instanceof EObject)) continue;
                            this.unregisterExistingObject((EObject)next);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.mResourceChangeListener);
        Iterator it = this.mIResourceToObjectListMap.values().iterator();
        while (it.hasNext()) {
            ((List)it.next()).clear();
        }
        this.mIResourceToObjectListMap.clear();
    }

    protected void handleResourceSetChanged(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                this.registerResource((Resource)msg.getNewValue());
                break;
            }
            case 5: {
                Iterator it = ((List)msg.getNewValue()).iterator();
                while (it.hasNext()) {
                    this.registerResource((Resource)it.next());
                }
                break;
            }
            case 4: {
                this.unregisterResource((Resource)msg.getOldValue());
                break;
            }
            case 6: {
                Iterator it = ((List)msg.getOldValue()).iterator();
                while (it.hasNext()) {
                    this.unregisterResource((Resource)it.next());
                }
                break;
            }
        }
    }

    protected void handleExtensionReferenceChanged(Notification msg) {
        IReferenceNameChangeExtension extension = (IReferenceNameChangeExtension)this.mEReferenceToExtension.get(msg.getFeature());
        switch (msg.getEventType()) {
            case 1: {
                this.unregisterObject(extension, (EObject)msg.getNotifier(), msg.getOldValue());
                this.registerObject(extension, (EObject)msg.getNotifier(), msg.getNewValue());
                break;
            }
            case 2: {
                this.unregisterObject(extension, (EObject)msg.getNotifier(), msg.getOldValue());
                break;
            }
            case 3: {
                this.registerObject(extension, (EObject)msg.getNotifier(), msg.getNewValue());
                break;
            }
            case 5: {
                Iterator it = ((List)msg.getNewValue()).iterator();
                while (it.hasNext()) {
                    this.registerObject(extension, (EObject)msg.getNotifier(), it.next());
                }
                break;
            }
            case 4: {
                this.unregisterObject(extension, (EObject)msg.getNotifier(), msg.getOldValue());
                break;
            }
            case 6: {
                Iterator it = ((List)msg.getOldValue()).iterator();
                while (it.hasNext()) {
                    this.unregisterObject(extension, (EObject)msg.getNotifier(), it.next());
                }
                break;
            }
        }
    }

    protected void registerResource(Resource resource) {
        IResource file = ResourceNameChangeAdapter.getWorkspaceResource(resource.getURI());
        if (file != null) {
            this.addObjectReference(file, resource);
        }
    }

    protected void unregisterResource(Resource resource) {
        IResource file = ResourceNameChangeAdapter.getWorkspaceResource(resource.getURI());
        if (file != null) {
            this.removeObjectReference(file, resource);
        }
    }

    protected void registerObject(IReferenceNameChangeExtension extension, EObject object, Object value) {
        IResource file = extension.getReferencedResource(object, value);
        if (file != null) {
            this.addObjectReference(file, new ObjectExtensionEntry(extension, object));
        }
    }

    protected void unregisterObject(IReferenceNameChangeExtension extension, EObject object, Object value) {
        IResource file = extension.getReferencedResource(object, value);
        if (file != null) {
            this.removeObjectReference(file, new ObjectExtensionEntry(extension, object));
        }
    }

    protected void registerExistingObject(EObject object) {
        Iterator it = object.eClass().getEAllStructuralFeatures().iterator();
        while (it.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)it.next();
            if (!this.mEReferenceToExtension.containsKey(feature)) continue;
            this.registerObject((IReferenceNameChangeExtension)this.mEReferenceToExtension.get(feature), object, object.eGet(feature));
        }
    }

    protected void unregisterExistingObject(EObject object) {
        Iterator it = object.eClass().getEAllStructuralFeatures().iterator();
        while (it.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)it.next();
            if (!this.mEReferenceToExtension.containsKey(feature)) continue;
            this.unregisterObject((IReferenceNameChangeExtension)this.mEReferenceToExtension.get(feature), object, object.eGet(feature));
        }
    }

    protected void addObjectReference(IResource file, Object object) {
        ArrayList<Object> references = (ArrayList<Object>)this.mIResourceToObjectListMap.get(file);
        if (references == null) {
            references = new ArrayList<Object>();
            this.mIResourceToObjectListMap.put(file, references);
        }
        references.add(object);
    }

    protected void removeObjectReference(IResource file, Object object) {
        List references = (List)this.mIResourceToObjectListMap.get(file);
        if (references != null) {
            references.remove(object);
            if (references.isEmpty()) {
                this.mIResourceToObjectListMap.remove(file);
            }
        } else {
            this.mIResourceToObjectListMap.remove(file);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleResourceChanged(IResourceChangeEvent event) {
        if (event.getDelta() == null) {
            return;
        }
        try {
            try {
                this.mProcessingNameChange = true;
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            if (delta.getKind() == 2 && (delta.getFlags() & 0x2000) == 8192) {
                                IFile changed = (IFile)delta.getResource();
                                if (ResourceNameChangeAdapter.this.mIResourceToObjectListMap.containsKey(changed)) {
                                    List references = (List)ResourceNameChangeAdapter.this.mIResourceToObjectListMap.get(changed);
                                    ResourceNameChangeAdapter.this.mIResourceToObjectListMap.remove(changed);
                                    Iterator it = references.iterator();
                                    while (it.hasNext()) {
                                        Object object = it.next();
                                        if (object instanceof Resource) {
                                            ResourceNameChangeAdapter.this.updateResourceReference((Resource)object, delta);
                                            continue;
                                        }
                                        ResourceNameChangeAdapter.this.updateObjectReference((ObjectExtensionEntry)object, delta);
                                    }
                                    ResourceNameChangeAdapter.this.mIResourceToObjectListMap.put(ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath()), references);
                                }
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.mProcessingNameChange = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.mProcessingNameChange = false;
            return;
        }
    }

    protected void updateResourceReference(Resource resource, IResourceDelta delta) {
        resource.setURI(URI.createPlatformResourceURI((String)delta.getMovedToPath().toString()));
    }

    protected void updateObjectReference(final ObjectExtensionEntry entry, final IResourceDelta delta) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    entry.getExtension().updateReference(entry.getObject(), delta);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected static class ObjectExtensionEntry {
        private IReferenceNameChangeExtension mExtension;
        private EObject mObject;

        public ObjectExtensionEntry(IReferenceNameChangeExtension extension, EObject object) {
            this.mExtension = extension;
            this.mObject = object;
        }

        public EObject getObject() {
            return this.mObject;
        }

        public IReferenceNameChangeExtension getExtension() {
            return this.mExtension;
        }

        public int hashCode() {
            return this.mObject.hashCode();
        }

        public boolean equals(Object object) {
            return this.mObject.equals(object);
        }
    }
}

