/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension;
import org.eclipse.stp.soas.deploy.core.IDeployDriverExtension;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.ILogicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IPackageExtension;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.IServerDefinition;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.internal.deploy.core.ConfigurablePackageExtension;
import org.eclipse.stp.soas.internal.deploy.core.DeployDriverExtension;
import org.eclipse.stp.soas.internal.deploy.core.LogicalPackageExtension;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;
import org.eclipse.stp.soas.internal.deploy.core.PhysicalPackageExtension;
import org.eclipse.stp.soas.internal.deploy.core.ServerDefinition;
import org.eclipse.stp.soas.internal.deploy.core.TechnologyDefinition;
import org.eclipse.stp.soas.internal.deploy.core.TechnologyMap;
import org.eclipse.stp.soas.internal.deploy.ui.properties.DeployOutputFolderPropertyPage;

public class DeploymentExtensionManager {
    public static final QualifiedName sPackageExtensionPropertyKey = new QualifiedName(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), "packageExtensionID");
    public static final String EXTENSION_ID = "deploymentExtension";
    public static final String EXT_ELEM_LOGICAL_PACKAGE = "logicalPackage";
    public static final String EXT_ELEM_CONFIGURABLE_PACKAGE = "configurablePackage";
    public static final String EXT_ELEM_PHYSICAL_PACKAGE = "physicalPackage";
    public static final String EXT_ELEM_DEPLOY_DRIVER = "deployDriver";
    public static final String EXT_ELEM_SUPPORTED_SERVER = "supportedServer";
    public static final String EXT_ELEM_SUPPORTED_TECHNOLOGY = "supportedTechnology";
    public static final String EXT_ELEM_TECHNOLOGY_DEFINITION = "technologyDefinition";
    public static final String EXT_ELEM_SERVER_DEFINITION = "serverDefinition";
    public static final String EXT_ELEM_TECHNOLOGY_MAP = "technologyMap";
    public static boolean DEBUG_DEPLOYMENT_EXTENSION = false;
    private static final String OPTION_DEBUG_DEPLOYMENT_EXTENSION = "org.eclipse.stp.soas.deploy.core/deploymentextension";
    private static DeploymentExtensionManager sInstance;
    private Map mTechnologyDefsByID;
    private Map mServerDefsByID;
    private Map mIdToLogicalExtension;
    private SortedSet mLogicalExtensionByFileExtension;
    private Map mIdToConfigurableExtension;
    private SortedSet mConfigurableExtensionByFileExtension;
    private Map mIdToPhysicalExtension;
    private SortedSet mPhysicalExtensionByFileExtension;
    private Map mIdToDeployDriver;
    private Map mProfileIdToDeployDriverList;

    public static DeploymentExtensionManager getInstance() {
        if (sInstance == null) {
            String debug = Platform.getDebugOption((String)OPTION_DEBUG_DEPLOYMENT_EXTENSION);
            DEBUG_DEPLOYMENT_EXTENSION = debug == null ? false : debug.equalsIgnoreCase("true");
            sInstance = new DeploymentExtensionManager();
            sInstance.init();
        }
        return sInstance;
    }

    private DeploymentExtensionManager() {
    }

    public boolean isPackage(IFile file) {
        return this.getPackageExtension(file) != null;
    }

    public boolean isLogicalPackage(IFile file) {
        return this.getLogicalPackageExtension(file) != null;
    }

    public boolean isConfigurablePackage(IFile file) {
        return this.getConfigurablePackageExtension(file) != null;
    }

    public boolean isPhysicalPackage(IFile file) {
        return this.getPhysicalPackageExtension(file) != null;
    }

    public IPackage getPackage(IFile file) {
        IPackage pkg;
        IPackageExtension ipe = this.getPackageExtension(file);
        if (ipe == null) {
            pkg = null;
        } else if (ipe instanceof IConfigurablePackageExtension) {
            pkg = ((IConfigurablePackageExtension)ipe).adaptFile(file);
        } else if (ipe instanceof ILogicalPackageExtension) {
            pkg = ((ILogicalPackageExtension)ipe).adaptFile(file);
        } else if (ipe instanceof IPhysicalPackageExtension) {
            pkg = ((IPhysicalPackageExtension)ipe).adaptFile(file);
        } else {
            if (DeployCorePlugin.getDefault().isDebugging()) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.unknownPackageExtension", new Object[]{ipe.getClass()}));
            }
            pkg = null;
        }
        return pkg;
    }

    public IPhysicalPackage getPhysicalPackage(IFile file) {
        IPackage pkg = this.getPackage(file);
        if (pkg != null && pkg instanceof IPhysicalPackage) {
            return (IPhysicalPackage)pkg;
        }
        return null;
    }

    public IFolder getOutputFolder(ILogicalPackage pkg, DeployConfiguration deployConfig) {
        Path outputFolderPath;
        IWorkspaceRoot wsRoot = pkg.getFile().getWorkspace().getRoot();
        IDeployTarget target = Utilities.adaptToIDeployTarget((EObject)deployConfig);
        IPackageConfiguration pkgConfig = this.getPackageConfiguration(pkg, deployConfig);
        if (pkgConfig == null) {
            IFile pkgFile = pkg.getFile();
            IPath pkgFilePath = pkgFile.getProjectRelativePath();
            outputFolderPath = new Path(DeployOutputFolderPropertyPage.getOutputContainerPath(pkgFile.getProject()));
            outputFolderPath = outputFolderPath.append(pkgFilePath);
            outputFolderPath = outputFolderPath.append(target.getDeployDriver().getName());
        } else {
            IFile deployFile = wsRoot.getFile(new Path(deployConfig.eResource().getURI().path()).removeFirstSegments(1));
            outputFolderPath = new Path(DeployOutputFolderPropertyPage.getOutputContainerPath(deployFile.getProject()));
            outputFolderPath = outputFolderPath.append(deployFile.getProjectRelativePath());
            outputFolderPath = outputFolderPath.append(target.getConnectionProfile().getName());
        }
        return wsRoot.getFolder((IPath)outputFolderPath);
    }

    public IFolder getOutputFolder(ILogicalPackage pkg, IDeployDriverExtension deployDriver) {
        IFile pkgFile = pkg.getFile();
        IPath pkgFilePath = pkgFile.getProjectRelativePath();
        Path outputFolderPath = new Path(DeployOutputFolderPropertyPage.getOutputContainerPath(pkgFile.getProject()));
        outputFolderPath = outputFolderPath.append(pkgFilePath);
        outputFolderPath = outputFolderPath.append(deployDriver.getName());
        return pkgFile.getWorkspace().getRoot().getFolder((IPath)outputFolderPath);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IPackageConfiguration getPackageConfiguration(ILogicalPackage ilp, DeployConfiguration deployConfig) {
        byte[] configData = deployConfig.getConfigOverride();
        if (ilp instanceof IConfigurablePackage) {
            IPackageConfiguration retVal;
            if (configData == null) return null;
            if (configData.length == 0) {
                return null;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(configData);
            try {
                try {
                    retVal = ((IConfigurablePackageExtension)ilp.getExtension()).getPackageConfigurationManager().createPackageConfiguration(ilp, bais);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    retVal = ((IConfigurablePackageExtension)ilp.getExtension()).getPackageConfigurationManager().createPackageConfiguration(ilp);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    bais.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var7_9 = null;
                try {}
                catch (IOException iOException) {
                    return retVal;
                }
                bais.close();
                return retVal;
            }
        }
        if (configData == null) return null;
        if (configData.length != 0) return null;
        System.err.println(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.configurationSpecifiedForLogicalPackage"));
        return null;
    }

    public IConfigurablePackage getConfigurablePackage(IFile file) {
        IPackage pkg = this.getPackage(file);
        if (pkg != null && pkg instanceof IConfigurablePackage) {
            return (IConfigurablePackage)pkg;
        }
        return null;
    }

    public ILogicalPackage getLogicalPackage(IFile file) {
        IPackage pkg = this.getPackage(file);
        if (pkg != null && pkg instanceof ILogicalPackage) {
            return (ILogicalPackage)pkg;
        }
        return null;
    }

    public IPackageExtension getPackageExtension(IFile file) {
        IPackageExtension ipe = this.getConfigurablePackageExtension(file);
        if (ipe == null && (ipe = this.getLogicalPackageExtension(file)) == null) {
            ipe = this.getPhysicalPackageExtension(file);
        }
        return ipe;
    }

    public ILogicalPackageExtension getLogicalPackageExtension(IFile file) {
        ILogicalPackageExtension ilpe = null;
        String extensionID = null;
        try {
            extensionID = file.getPersistentProperty(sPackageExtensionPropertyKey);
            if (extensionID != null) {
                ilpe = this.getLogicalPackageExtension(extensionID);
            }
        }
        catch (CoreException coreException) {}
        if (ilpe == null) {
            String fileExt = file.getFileExtension();
            if (fileExt != null) {
                List extensions = this.getLogicalExtensions(fileExt);
                Iterator it = extensions.iterator();
                while (ilpe == null && it.hasNext()) {
                    ILogicalPackageExtension extension = (ILogicalPackageExtension)it.next();
                    if (!extension.supportsFile(file)) continue;
                    ilpe = extension;
                }
            }
            if (ilpe != null && extensionID == null) {
                try {
                    file.setPersistentProperty(sPackageExtensionPropertyKey, ilpe.getID());
                }
                catch (CoreException coreException) {}
            }
        }
        return ilpe;
    }

    public IConfigurablePackageExtension getConfigurablePackageExtension(IFile file) {
        IConfigurablePackageExtension icpe = null;
        String extensionID = null;
        try {
            extensionID = file.getPersistentProperty(sPackageExtensionPropertyKey);
            if (extensionID != null) {
                icpe = this.getConfigurablePackageExtension(extensionID);
            }
        }
        catch (CoreException coreException) {}
        if (icpe == null) {
            String fileExt = file.getFileExtension();
            if (fileExt != null) {
                List extensions = this.getConfigurableExtensions(fileExt);
                Iterator it = extensions.iterator();
                while (icpe == null && it.hasNext()) {
                    IConfigurablePackageExtension extension = (IConfigurablePackageExtension)it.next();
                    if (!extension.supportsFile(file)) continue;
                    icpe = extension;
                }
            }
            if (icpe != null && extensionID == null) {
                try {
                    file.setPersistentProperty(sPackageExtensionPropertyKey, icpe.getID());
                }
                catch (CoreException coreException) {}
            }
        }
        return icpe;
    }

    public IPhysicalPackageExtension getPhysicalPackageExtension(IFile file) {
        IPhysicalPackageExtension ippe = null;
        String extensionID = null;
        try {
            extensionID = file.getPersistentProperty(sPackageExtensionPropertyKey);
            if (extensionID != null) {
                ippe = this.getPhysicalPackageExtension(extensionID);
            }
        }
        catch (CoreException coreException) {}
        if (ippe == null) {
            String fileExt = file.getFileExtension();
            List extensions = this.getPhysicalPackageExtensions(fileExt);
            Iterator it = extensions.iterator();
            while (ippe == null && it.hasNext()) {
                IPhysicalPackageExtension extension = (IPhysicalPackageExtension)it.next();
                if (!extension.supportsFile(file)) continue;
                ippe = extension;
            }
            if (ippe != null) {
                try {
                    file.setPersistentProperty(sPackageExtensionPropertyKey, ippe.getID());
                }
                catch (CoreException coreException) {}
            }
        }
        return ippe;
    }

    public ILogicalPackageExtension getLogicalPackageExtension(String id) {
        ILogicalPackageExtension ilpe = id == null || !this.mIdToLogicalExtension.containsKey(id) ? null : (ILogicalPackageExtension)this.mIdToLogicalExtension.get(id);
        return ilpe;
    }

    public List getLogicalExtensions(String fileExtension) {
        return new ArrayList<String>(this.mLogicalExtensionByFileExtension.subSet(fileExtension, String.valueOf(fileExtension) + '\u0000'));
    }

    public IConfigurablePackageExtension getConfigurablePackageExtension(String id) {
        IConfigurablePackageExtension icpe = id == null || !this.mIdToLogicalExtension.containsKey(id) ? null : (IConfigurablePackageExtension)this.mIdToConfigurableExtension.get(id);
        return icpe;
    }

    public List getConfigurableExtensions(String fileExtension) {
        return new ArrayList<String>(this.mConfigurableExtensionByFileExtension.subSet(fileExtension, String.valueOf(fileExtension) + '\u0000'));
    }

    public IPhysicalPackageExtension getPhysicalPackageExtension(String id) {
        IPhysicalPackageExtension ippe = id == null || !this.mIdToPhysicalExtension.containsKey(id) ? null : (IPhysicalPackageExtension)this.mIdToPhysicalExtension.get(id);
        return ippe;
    }

    public List getPhysicalPackageExtensions(String fileExtension) {
        ArrayList<Object> retVal = fileExtension == null ? new ArrayList() : new ArrayList<String>(this.mPhysicalExtensionByFileExtension.subSet(fileExtension, String.valueOf(fileExtension) + '\u0000'));
        return retVal;
    }

    public ITechnologyDefinition getTechnologyDefinition(String type) {
        ITechnologyDefinition itd = type == null || !this.mTechnologyDefsByID.containsKey(type) ? null : (ITechnologyDefinition)this.mTechnologyDefsByID.get(type);
        return itd;
    }

    public IServerDefinition getServerDefinition(String type) {
        IServerDefinition isd = type == null || !this.mServerDefsByID.containsKey(type) ? null : (IServerDefinition)this.mServerDefsByID.get(type);
        return isd;
    }

    public List getDeployDrivers() {
        return new ArrayList(this.mIdToDeployDriver.values());
    }

    public List getDeployDrivers(String profileID) {
        ArrayList drivers = profileID == null || !this.mProfileIdToDeployDriverList.containsKey(profileID) ? new ArrayList() : new ArrayList((List)this.mProfileIdToDeployDriverList.get(profileID));
        return drivers;
    }

    public IDeployDriverExtension getDeployDriver(IPackage pkg, String profileID) {
        IDeployDriverExtension idde = null;
        if (pkg != null) {
            if (pkg instanceof ILogicalPackage) {
                idde = this.getDeployDriver((ILogicalPackage)pkg, profileID);
            } else if (pkg instanceof IPhysicalPackage) {
                idde = this.getDeployDriver((IPhysicalPackage)pkg, profileID);
            } else {
                throw new IllegalArgumentException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.unknownPackageType", new Object[]{pkg.getClass()}));
            }
        }
        return idde;
    }

    public IDeployDriverExtension getDeployDriver(IPhysicalPackage pkg, String profileID) {
        IDeployDriverExtension idde = null;
        IServerType serverType = pkg.getServerType();
        Iterator it = this.getDeployDrivers(profileID).iterator();
        while (idde == null && it.hasNext()) {
            IDeployDriverExtension tmp = (IDeployDriverExtension)it.next();
            if (!tmp.supportsServer(serverType)) continue;
            idde = tmp;
        }
        return idde;
    }

    public IDeployDriverExtension getDeployDriver(ILogicalPackage pkg, String profileID) {
        IDeployDriverExtension idde = null;
        ITechnologyType technologyType = pkg.getTechnologyType();
        Iterator it = this.getDeployDrivers(profileID).iterator();
        while (idde == null && it.hasNext()) {
            IDeployDriverExtension tmp = (IDeployDriverExtension)it.next();
            IPackageConstructorExtension constructor = tmp.getPackageConstructor(technologyType);
            if (constructor == null || !constructor.supportsPackage(pkg)) continue;
            idde = tmp;
        }
        return idde;
    }

    private void init() {
        this.mTechnologyDefsByID = new TreeMap();
        this.mServerDefsByID = new TreeMap();
        this.mIdToLogicalExtension = new TreeMap(new IDComparator());
        this.mLogicalExtensionByFileExtension = new TreeSet(new FileExtensionComparator());
        this.mIdToConfigurableExtension = new TreeMap(new IDComparator());
        this.mConfigurableExtensionByFileExtension = new TreeSet(new FileExtensionComparator());
        this.mIdToPhysicalExtension = new TreeMap(new IDComparator());
        this.mPhysicalExtensionByFileExtension = new TreeSet(new FileExtensionComparator());
        this.mIdToDeployDriver = new TreeMap();
        this.mProfileIdToDeployDriverList = new TreeMap();
        this.processExtensions();
    }

    private void processExtensions() {
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_ID);
        IExtension[] exts = exp.getExtensions();
        ArrayList<IConfigurationElement> logicalPackages = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> configurablePackages = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> physicalPackages = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> deployDrivers = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> technologyDefs = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> serverDefs = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> technologyMaps = new ArrayList<IConfigurationElement>();
        Iterator<IExtension> xit = Arrays.asList(exts).iterator();
        while (xit.hasNext()) {
            IExtension ext = xit.next();
            IConfigurationElement[] elems = ext.getConfigurationElements();
            Iterator<IConfigurationElement> eit = Arrays.asList(elems).iterator();
            while (eit.hasNext()) {
                IConfigurationElement elem = eit.next();
                String elemName = elem.getName();
                if (EXT_ELEM_LOGICAL_PACKAGE.equals(elemName)) {
                    logicalPackages.add(elem);
                    continue;
                }
                if (EXT_ELEM_CONFIGURABLE_PACKAGE.equals(elemName)) {
                    configurablePackages.add(elem);
                    continue;
                }
                if (EXT_ELEM_PHYSICAL_PACKAGE.equals(elemName)) {
                    physicalPackages.add(elem);
                    continue;
                }
                if (EXT_ELEM_DEPLOY_DRIVER.equals(elemName)) {
                    deployDrivers.add(elem);
                    continue;
                }
                if (EXT_ELEM_TECHNOLOGY_DEFINITION.equals(elemName)) {
                    technologyDefs.add(elem);
                    continue;
                }
                if (EXT_ELEM_SERVER_DEFINITION.equals(elemName)) {
                    serverDefs.add(elem);
                    continue;
                }
                if (EXT_ELEM_TECHNOLOGY_MAP.equals(elemName)) {
                    technologyMaps.add(elem);
                    continue;
                }
                if (!DEBUG_DEPLOYMENT_EXTENSION) continue;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.unknownElement", new Object[]{elemName, ext.getContributor().getName()}));
                System.err.flush();
            }
        }
        this.processTechnologyDefs(technologyDefs);
        this.processServerDefs(serverDefs);
        this.processTechnologyMaps(technologyMaps);
        this.processLogicalPackages(logicalPackages);
        this.processConfigurablePackages(configurablePackages);
        this.processPhysicalPackages(physicalPackages);
        this.processDeployDrivers(deployDrivers);
    }

    private void processTechnologyDefs(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processTechnologyDef((IConfigurationElement)it.next());
        }
    }

    private void processTechnologyDef(IConfigurationElement element) {
        block3: {
            try {
                TechnologyDefinition itd = new TechnologyDefinition(element);
                if (this.mTechnologyDefsByID.containsKey(itd.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateTechnologyDefinitionId"));
                }
                this.mTechnologyDefsByID.put(itd.getID(), itd);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.technologyDefinitionParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processServerDefs(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processServerDef((IConfigurationElement)it.next());
        }
    }

    private void processServerDef(IConfigurationElement element) {
        block3: {
            try {
                ServerDefinition isd = new ServerDefinition(element);
                if (this.mServerDefsByID.containsKey(isd.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateServerDefinitionId"));
                }
                this.mServerDefsByID.put(isd.getID(), isd);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.serverDefinitionParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processTechnologyMaps(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processTechnologyMap((IConfigurationElement)it.next());
        }
    }

    private void processTechnologyMap(IConfigurationElement element) {
        block2: {
            try {
                new TechnologyMap(element);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block2;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.technologyMapParseError", new Object[]{element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processLogicalPackages(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processLogicalPackage((IConfigurationElement)it.next());
        }
    }

    private void processLogicalPackage(IConfigurationElement element) {
        block3: {
            try {
                LogicalPackageExtension lpp = new LogicalPackageExtension(element);
                if (this.mIdToLogicalExtension.containsKey(lpp.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateLogicalPackageId"));
                }
                this.mIdToLogicalExtension.put(lpp.getID(), lpp);
                this.mLogicalExtensionByFileExtension.add(lpp);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.logicalPackageParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processConfigurablePackages(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processConfigurablePackage((IConfigurationElement)it.next());
        }
    }

    private void processConfigurablePackage(IConfigurationElement element) {
        block3: {
            try {
                ConfigurablePackageExtension cpe = new ConfigurablePackageExtension(element);
                if (this.mIdToConfigurableExtension.containsKey(cpe.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateConfigurablePackageId"));
                }
                this.mIdToConfigurableExtension.put(cpe.getID(), cpe);
                this.mConfigurableExtensionByFileExtension.add(cpe);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.configurablePackageParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processPhysicalPackages(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processPhysicalPackage((IConfigurationElement)it.next());
        }
    }

    private void processPhysicalPackage(IConfigurationElement element) {
        block3: {
            try {
                PhysicalPackageExtension ppp = new PhysicalPackageExtension(element);
                if (this.mIdToPhysicalExtension.containsKey(ppp.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicatePhysicalPackageId"));
                }
                this.mIdToPhysicalExtension.put(ppp.getID(), ppp);
                this.mPhysicalExtensionByFileExtension.add(ppp);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.physicalPackageParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processDeployDrivers(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processDeployDriver((IConfigurationElement)it.next());
        }
    }

    private void processDeployDriver(IConfigurationElement element) {
        block4: {
            try {
                List<DeployDriverExtension> drivers;
                DeployDriverExtension de = new DeployDriverExtension(element);
                Assert.isTrue((!this.mIdToDeployDriver.containsKey(de.getID()) ? 1 : 0) != 0, (String)DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.assert.duplicateDeployDriver", new Object[]{de.getID(), element.toString(), de.getID()}));
                this.mIdToDeployDriver.put(de.getID(), de);
                String profileID = de.getConnectionProfileProvider().getId();
                if (this.mProfileIdToDeployDriverList.containsKey(profileID)) {
                    drivers = (List)this.mProfileIdToDeployDriverList.get(profileID);
                } else {
                    drivers = new ArrayList();
                    this.mProfileIdToDeployDriverList.put(profileID, drivers);
                }
                drivers.add(de);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block4;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.deployDriverParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private static class IDComparator
    implements Comparator {
        IDComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof String ? (String)o1 : ((IPackageExtension)o1).getID();
            String s2 = o2 instanceof String ? (String)o2 : ((IPackageExtension)o2).getID();
            return s1.compareTo(s2);
        }
    }

    private static class FileExtensionComparator
    implements Comparator {
        FileExtensionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int retVal;
            if (o1 instanceof String) {
                String s1 = (String)o1;
                String s2 = o2 instanceof String ? (String)o2 : ((IPackageExtension)o2).getFileExtension();
                retVal = s1.compareTo(s2);
            } else if (o2 instanceof String) {
                String s2 = (String)o2;
                String s1 = o1 instanceof String ? (String)o1 : ((IPackageExtension)o1).getFileExtension();
                retVal = s1.compareTo(s2);
            } else {
                IPackageExtension ipe1 = (IPackageExtension)o1;
                IPackageExtension ipe2 = (IPackageExtension)o2;
                retVal = ipe1.getFileExtension().compareTo(ipe2.getFileExtension());
                if (retVal == 0) {
                    retVal = ipe1.getID().compareTo(ipe2.getID());
                }
            }
            return retVal;
        }
    }
}

