/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.MatchRule;

public class Version
implements IVersion {
    public static final Version NULL_VERSION = new Version(org.eclipse.datatools.connectivity.Version.NULL_VERSION);
    private org.eclipse.datatools.connectivity.Version mVersion;

    public static Version valueOf(String version) {
        return Version.valueOf(org.eclipse.datatools.connectivity.Version.valueOf((String)version));
    }

    public static Version valueOf(org.eclipse.datatools.connectivity.Version version) {
        if (version == org.eclipse.datatools.connectivity.Version.NULL_VERSION) {
            return NULL_VERSION;
        }
        return new Version(version);
    }

    public Version(int major, int minor, int release, String build) {
        this.mVersion = new org.eclipse.datatools.connectivity.Version(major, minor, release, build);
    }

    private Version(org.eclipse.datatools.connectivity.Version version) {
        this.mVersion = version;
    }

    public int getMajor() {
        return this.mVersion.getMajor();
    }

    public int getMinor() {
        return this.mVersion.getMinor();
    }

    public int getRelease() {
        return this.mVersion.getRelease();
    }

    public String getBuild() {
        return this.mVersion.getBuild();
    }

    public int compareTo(Object o) {
        return this.mVersion.compareTo((Object)((Version)o).mVersion);
    }

    public boolean equals(Object obj) {
        boolean retVal = obj instanceof Version ? this.compareTo(obj) == 0 : false;
        return retVal;
    }

    public boolean isCompatibleWithVersion(IVersion actual, MatchRule matchRule) {
        boolean retVal;
        if (matchRule == MatchRule.PERFECT) {
            retVal = this.comparePerfect(actual);
        } else if (matchRule == MatchRule.EQUIVALENT) {
            retVal = this.compareEquivalent(actual);
        } else if (matchRule == MatchRule.COMPATIBLE) {
            retVal = this.compareCompatible(actual);
        } else if (matchRule == MatchRule.EQUAL_OR_GREATER) {
            retVal = this.compareEqualOrGreater(actual);
        } else {
            throw new IllegalArgumentException();
        }
        return retVal;
    }

    public int hashCode() {
        return this.mVersion.hashCode();
    }

    public String toString() {
        return this.mVersion.toString();
    }

    private boolean comparePerfect(IVersion actual) {
        return this.getMajor() == actual.getMajor() && this.getMinor() == actual.getMinor() && this.getRelease() == actual.getRelease() && this.getBuild().compareTo(actual.getBuild()) == 0;
    }

    private boolean compareEquivalent(IVersion actual) {
        boolean retVal = this.getMajor() == actual.getMajor() ? (this.getMinor() == actual.getMinor() ? (this.getRelease() == actual.getRelease() ? this.getBuild().compareTo(actual.getBuild()) <= 0 : this.getRelease() < actual.getRelease()) : false) : false;
        return retVal;
    }

    private boolean compareCompatible(IVersion actual) {
        boolean retVal = this.getMajor() == actual.getMajor() ? (this.getMinor() == actual.getMinor() ? (this.getRelease() == actual.getRelease() ? this.getBuild().compareTo(actual.getBuild()) <= 0 : this.getRelease() < actual.getRelease()) : this.getMinor() < actual.getMinor()) : false;
        return retVal;
    }

    private boolean compareEqualOrGreater(IVersion actual) {
        boolean retVal = this.getMajor() == actual.getMajor() ? (this.getMinor() == actual.getMinor() ? (this.getRelease() == actual.getRelease() ? this.getBuild().compareTo(actual.getBuild()) <= 0 : this.getRelease() < actual.getRelease()) : this.getMinor() < actual.getMinor()) : this.getMajor() < actual.getMajor();
        return retVal;
    }
}

