/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.adapters;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IDeployDriverExtension;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;

public class DeployConfigurationDeployAPIAdapter
extends AdapterImpl
implements IDeployAPIAdapter {
    static /* synthetic */ Class class$0;

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public IDeployTarget asDeployTarget() {
        IDeployTarget idt = null;
        IPackage ip = this.asPackage();
        IConnectionProfile profile = this.asConnectionProfile();
        IDeployDriverExtension idde = DeploymentExtensionManager.getInstance().getDeployDriver(ip, profile.getProviderId());
        if (idde != null) {
            idt = idde.adaptProfile(profile);
        }
        return idt;
    }

    public ILogicalPackage asLogicalPackage() {
        IFile file = this.getFile();
        ILogicalPackage ilp = file == null ? null : DeploymentExtensionManager.getInstance().getLogicalPackage(file);
        return ilp;
    }

    public IConfigurablePackage asConfigurablePackage() {
        IFile file = this.getFile();
        IConfigurablePackage icp = file == null ? null : DeploymentExtensionManager.getInstance().getConfigurablePackage(file);
        return icp;
    }

    public IPackage asPackage() {
        IPackage ip;
        IFile file = this.getFile();
        if (file == null) {
            ip = null;
        } else {
            ip = DeploymentExtensionManager.getInstance().getPackage(file);
            if (ip instanceof IPhysicalPackage) {
                ip = this.asPhysicalPackage();
            }
        }
        return ip;
    }

    public IPhysicalPackage asPhysicalPackage() {
        IPhysicalPackage ipp;
        IFile file = this.getFile();
        if (file == null) {
            ipp = null;
        } else {
            IConnectionProfile profile;
            ipp = DeploymentExtensionManager.getInstance().getPhysicalPackage(file);
            List packageExtensions = DeploymentExtensionManager.getInstance().getPhysicalPackageExtensions(file.getFileExtension());
            if (ipp != null && packageExtensions.size() > 1 && (profile = this.asConnectionProfile()) != null) {
                String profileProviderID = profile.getProviderId();
                if (DeploymentExtensionManager.getInstance().getDeployDriver(ipp, profileProviderID) == null) {
                    ipp = null;
                    Iterator it = packageExtensions.iterator();
                    while (ipp == null && it.hasNext()) {
                        IPhysicalPackageExtension ippe = (IPhysicalPackageExtension)it.next();
                        IPhysicalPackage tmpIpp = (IPhysicalPackage)ippe.adaptFile(file);
                        if (DeploymentExtensionManager.getInstance().getDeployDriver(tmpIpp, profileProviderID) == null) continue;
                        ipp = tmpIpp;
                    }
                }
            }
        }
        return ipp;
    }

    public IConnectionProfile asConnectionProfile() {
        DeployServer server = ((DeployConfiguration)this.getTarget()).getTargetServer();
        if (server == null) {
            return null;
        }
        return ProfileManager.getInstance().getProfileByName(server.getProfileName());
    }

    private IFile getFile() {
        try {
            DeployPackage dp = ((DeployConfiguration)this.getTarget()).getSourcePackage();
            String path = dp.getPackageFile();
            URL url = FileLocator.toFileURL((URL)new URL(dp.eResource().getURI().toString()));
            IFile deployFile = DeployCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(url.getPath()));
            IProject project = deployFile.getProject();
            IFile retVal = project.getFile(path);
            Iterator<IProject> it = Arrays.asList(project.getReferencedProjects()).iterator();
            while (!retVal.exists() && it.hasNext()) {
                project = it.next();
                retVal = project.getFile(path);
            }
            if (retVal.exists()) {
                return retVal;
            }
        }
        catch (CoreException coreException) {
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return null;
    }
}

