/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.RefreshProfileJob;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IDeploySession;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.core.operations.CreateDeployPackagesJob;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DeployStatusDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.PreDeployCheckDialogPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.IProgressConstants;

public class ExecuteDeploymentJob
extends Job {
    private Root mRoot;
    private Map mDeployConfigToDeployTargetMap = new HashMap();
    private Map mDeployTargetToDeploySessionMap = new HashMap();
    private Map mDeployStatusMap = new HashMap();
    private boolean mHasErrorStatus = false;
    private CreateDeployPackagesJob mCreatePackages;
    private Shell mShell;

    public ExecuteDeploymentJob(Root root, Shell shell) {
        super(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.task.name"));
        this.mRoot = root;
        this.mShell = shell;
        this.mCreatePackages = new CreateDeployPackagesJob(this.mRoot);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.setUser(true);
        this.setSystem(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.task.name"), 3000);
        this.mDeployStatusMap.clear();
        this.mHasErrorStatus = false;
        status = Status.OK_STATUS;
        try {
            try {
                packageDescriptors = this.createPackages(monitor);
                this.preDeployCheck(packageDescriptors, monitor);
                this.deployPackages(packageDescriptors, monitor);
                if (this.mHasErrorStatus) {
                    status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.error.job"), null);
                }
                ** GOTO lbl-1000
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            catch (InterruptedException v0) {
                status = Status.CANCEL_STATUS;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var5_5) {
            var4_6 = null;
            it = this.mDeployTargetToDeploySessionMap.values().iterator();
        }
        while (true) {
            if (!it.hasNext()) {
                this.refreshDSE(monitor);
                this.mDeployConfigToDeployTargetMap.clear();
                this.mDeployTargetToDeploySessionMap.clear();
                throw var5_5;
            }
            session = (IDeploySession)it.next();
            if (session == null) continue;
            try {
                session.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
lbl-1000:
        // 4 sources

        {
            var4_7 = null;
            it = this.mDeployTargetToDeploySessionMap.values().iterator();
        }
        while (true) {
            if (!it.hasNext()) {
                this.refreshDSE(monitor);
                this.mDeployConfigToDeployTargetMap.clear();
                this.mDeployTargetToDeploySessionMap.clear();
                this.logStatus();
                monitor.done();
                this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.action.name")){

                    public void run() {
                        ExecuteDeploymentJob.this.displayStatus();
                    }
                });
                return status;
            }
            session = (IDeploySession)it.next();
            if (session == null) continue;
            try {}
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            session.dispose();
            continue;
            break;
        }
    }

    public Map getDeployStatusMap() {
        return this.mDeployStatusMap;
    }

    private void checkCancelled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private Map createPackages(IProgressMonitor monitor) throws CoreException, InterruptedException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
        IStatus status = this.mCreatePackages.run((IProgressMonitor)subMonitor);
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
        this.checkCancelled(monitor);
        return this.mCreatePackages.getPackageDescriptors();
    }

    private void preDeployCheck(Map packageDescriptors, final IProgressMonitor monitor) throws CoreException, InterruptedException {
        int deployTaskLength = this.getDeployTaskLength();
        HashMap<DeployConfiguration, IStatus[]> deployCheckStatus = new HashMap<DeployConfiguration, IStatus[]>();
        int severity = 0;
        Iterator it = packageDescriptors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DeployConfiguration config = (DeployConfiguration)entry.getKey();
            IPackageOutputDescriptor descriptor = (IPackageOutputDescriptor)entry.getValue();
            monitor.subTask(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.subtask.preDeployCheck", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}));
            if (descriptor == null) {
                String exceptionMessage = DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.error.deployError", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()});
                Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.error.log.message"), (Throwable)new Exception(exceptionMessage));
                throw new CoreException((IStatus)new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, new IStatus[]{status}, DeployCorePlugin.getDefault().getResourceString("DeployStatusDialog.TITLE"), null));
            }
            IDeployTarget target = Utilities.adaptToIDeployTarget((EObject)config);
            IDeploySession session = target.createDeploySession();
            this.mDeployConfigToDeployTargetMap.put(config, target);
            this.mDeployTargetToDeploySessionMap.put(target, session);
            IStatus[] status = session.preDeployCheck(descriptor);
            deployCheckStatus.put(config, status);
            if (status.length > 0) {
                int index = 0;
                int count = status.length;
                while ((severity & 4) == 0 && index < count) {
                    severity |= status[index].getSeverity();
                    ++index;
                }
            }
            monitor.worked(deployTaskLength);
            if (severity != 0) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                final PreDeployCheckDialogPage page = new PreDeployCheckDialogPage(deployCheckStatus, (severity & 4) == 0);
                display.syncExec(new Runnable(){

                    /*
                     * Exception decompiling
                     */
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 107->111)] java.lang.Throwable
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
            }
            this.checkCancelled(monitor);
        }
        this.checkCancelled(monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deployPackages(Map packageDescriptors, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int deployTaskLength = this.getDeployTaskLength();
        Iterator it = packageDescriptors.entrySet().iterator();
        while (true) {
            if (!it.hasNext()) {
                this.checkCancelled(monitor);
                return;
            }
            Map.Entry entry = it.next();
            DeployConfiguration config = (DeployConfiguration)entry.getKey();
            IPackageOutputDescriptor descriptor = (IPackageOutputDescriptor)entry.getValue();
            monitor.subTask(DeployCorePlugin.getDefault().getResourceString("ExecuteDeploymentJob.subtask.deploy", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}));
            if (descriptor == null || !new File(descriptor.getFileName()).exists()) {
                this.mDeployStatusMap.put(config, new IStatus[]{new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Deploy.ERROR.PackageDoesNotExist", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}), null)});
                this.mHasErrorStatus = true;
            } else {
                Object var11_11;
                IDeployTarget target = (IDeployTarget)this.mDeployConfigToDeployTargetMap.get(config);
                IDeploySession session = (IDeploySession)this.mDeployTargetToDeploySessionMap.get(target);
                try {
                    try {
                        session.deploy(descriptor);
                        this.mDeployStatusMap.put(config, new IStatus[]{new Status(1, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Deploy.SUCCESS.Generic", new Object[]{config.getSourcePackage().getPackageFile(), config.getTargetServer().getProfileName()}), null)});
                    }
                    catch (Exception e) {
                        this.mDeployStatusMap.put(config, new IStatus[]{new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("Deploy.ERROR.Generic", new Object[]{config.getSourcePackage().getPackageFile(), target.getConnectionProfile().getName(), e.getMessage()}), (Throwable)e)});
                        this.mHasErrorStatus = true;
                    }
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    if (session != null) {
                        session.dispose();
                    }
                    this.mDeployTargetToDeploySessionMap.remove(target);
                    throw throwable;
                }
                {
                    var11_11 = null;
                    if (session != null) {
                        session.dispose();
                    }
                    this.mDeployTargetToDeploySessionMap.remove(target);
                }
            }
            monitor.worked(deployTaskLength);
            this.checkCancelled(monitor);
        }
    }

    private void refreshDSE(IProgressMonitor monitor) {
        IViewPart dseView = null;
        IWorkbenchWindow[] workbenchWindows = DeployCorePlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (workbenchWindows != null) {
            int winIndex = 0;
            int winCount = workbenchWindows.length;
            while (dseView == null && winIndex < winCount) {
                IWorkbenchPage[] workbenchPages = workbenchWindows[winIndex].getPages();
                if (workbenchPages != null) {
                    IViewReference dseReference = null;
                    int pageIndex = 0;
                    int pageCount = workbenchPages.length;
                    while (dseReference == null && pageIndex < pageCount) {
                        dseReference = workbenchPages[pageIndex].findViewReference("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
                        ++pageIndex;
                    }
                    if (dseReference != null) {
                        dseView = dseReference.getView(false);
                    }
                }
                ++winIndex;
            }
        }
        if (dseView != null && dseView instanceof CommonNavigator) {
            int refreshTaskLength = this.getRefreshTaskLength();
            final CommonNavigator serversView = (CommonNavigator)dseView;
            Display display = serversView.getSite().getPage().getWorkbenchWindow().getShell().getDisplay();
            CommonViewer viewer = serversView.getCommonViewer();
            display.syncExec(new Runnable(){

                public void run() {
                    serversView.getViewSite().getPage().activate((IWorkbenchPart)serversView);
                }
            });
            Iterator it = this.mRoot.getServer().iterator();
            while (it.hasNext()) {
                DeployServer server = (DeployServer)it.next();
                IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(server.getProfileName());
                if (profile.isConnected()) {
                    RefreshProfileJob.scheduleRefreshProfileJob((IConnectionProfile)profile, (TreeViewer)viewer);
                }
                monitor.worked(refreshTaskLength);
            }
        }
    }

    private int getDeployTaskLength() {
        int retVal = 0;
        Iterator it = this.mRoot.getPackage().iterator();
        while (it.hasNext()) {
            retVal += ((DeployPackage)it.next()).getTargetConfiguration().size();
        }
        return retVal / 1000 + 1;
    }

    private int getRefreshTaskLength() {
        return this.mRoot.getServer().size() / 1000 + 1;
    }

    private void logStatus() {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        Iterator it = this.mDeployStatusMap.values().iterator();
        while (it.hasNext()) {
            statuses.addAll(Arrays.asList((IStatus[])it.next()));
        }
        DeployCorePlugin.getDefault().log((IStatus)new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, statuses.toArray(new IStatus[statuses.size()]), DeployCorePlugin.getDefault().getResourceString("DeployStatusDialog.TITLE"), null));
    }

    private void displayStatus() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final DeployStatusDialogPage page = new DeployStatusDialogPage(this.mDeployStatusMap);
        display.syncExec(new Runnable(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 97->101)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    static /* synthetic */ Shell access$1(ExecuteDeploymentJob executeDeploymentJob) {
        return executeDeploymentJob.mShell;
    }
}

