/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.ui.configuration;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConfigurationManager;
import org.eclipse.stp.soas.deploy.core.ui.configuration.IConfigurationNode;
import org.eclipse.swt.widgets.Shell;

public class ConfigurationDialog
extends PreferenceDialog {
    private IPackageConfiguration mPackageConfiguration;
    private IPackageConfigurationManager mPackageConfigManager;

    public ConfigurationDialog(Shell parentShell, IPackageConfiguration packageConfiguration) {
        super(parentShell, new PreferenceManager());
        this.mPackageConfiguration = packageConfiguration;
        this.mPackageConfigManager = ((IConfigurablePackageExtension)this.mPackageConfiguration.getPackage().getExtension()).getPackageConfigurationManager();
        if (this.mPackageConfiguration == null) {
            this.mPackageConfiguration = this.mPackageConfigManager.createPackageConfiguration(packageConfiguration.getPackage());
        }
        this.mPackageConfigManager.getConfigurationPageFactory().contribute(this.getPreferenceManager(), this.mPackageConfiguration);
    }

    public IPackageConfiguration getPackageConfiguration() {
        return this.mPackageConfiguration;
    }

    protected void handleSave() {
        super.handleSave();
        Iterator it = this.getPreferenceManager().getElements(0).iterator();
        while (it.hasNext()) {
            IConfigurationNode node = (IConfigurationNode)it.next();
            if (node == null || !node.needsSave()) continue;
            try {
                node.save();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

