/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.ILogicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtension;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;
import org.eclipse.stp.soas.internal.deploy.core.SupportedTechnologyType;

public class LogicalPackageExtension
extends PackageExtension
implements ILogicalPackageExtension {
    public static final String ATTR_CLASS = "class";
    private ISupportedTechnologyType mSupportedTechnology;

    public LogicalPackageExtension(IConfigurationElement element) throws PackageExtensionException {
        super(element);
        this.init();
    }

    public ISupportedTechnologyType getSupportedTechnologyType() {
        return this.mSupportedTechnology;
    }

    public boolean supportsTechnology(ITechnologyType type) {
        return this.mSupportedTechnology.supportsTechnology(type);
    }

    public IPackage adaptFile(IFile file) {
        ILogicalPackage ilp;
        try {
            ilp = (ILogicalPackage)this.getConfigurationElement().createExecutableExtension(ATTR_CLASS);
            ilp.init(this, file);
        }
        catch (CoreException coreException) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.trace.error.logicalPackageClassNotFound", new Object[]{this.getID(), this.getConfigurationElement().getAttribute(ATTR_CLASS), file.getFullPath().toString()}));
                System.err.flush();
            }
            ilp = null;
        }
        return ilp;
    }

    private void init() throws PackageExtensionException {
        this.processSupportedTechnologyElement();
    }

    private void processSupportedTechnologyElement() throws PackageExtensionException {
        IConfigurationElement[] supportedTechnologies = this.getConfigurationElement().getChildren("supportedTechnology");
        if (supportedTechnologies.length < 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.trace.error.supportedTechnologyNotSpecified", new Object[]{this.getID()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.exception.supportedTechnologyNotSpecified"));
        }
        if (supportedTechnologies.length > 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.trace.error.multipleSupportedTechnologyElements", new Object[]{this.getID()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("LogicalPackageExtension.exception.multipleSupportedTechnologyElements"));
        }
        this.mSupportedTechnology = new SupportedTechnologyType(supportedTechnologies[0]);
    }
}

