/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui;

import java.util.Vector;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.internal.deploy.emf.AdapterFactoryContentProvider;
import org.eclipse.stp.soas.internal.deploy.ui.TargetMapTreeViewer;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.Dialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.ServerSelectionDialogPage;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class TargetMapTableViewer {
    public static final String PROP_PACKAGE = "package";
    public static final String PROP_TARGET = "target";
    private static final String[] COLUMN_PROPERTIES = new String[]{"package", "target"};
    private TableViewer mTargetMap;

    public TargetMapTableViewer(Table table) {
        this.createControl(table);
    }

    public TableViewer getViewer() {
        return this.mTargetMap;
    }

    private void createControl(Table table) {
        this.mTargetMap = new TableViewer(table);
        this.mTargetMap.getTable().setHeaderVisible(true);
        this.mTargetMap.getTable().setLinesVisible(true);
        this.mTargetMap.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)Utilities.getItemAdapterFactory()));
        this.mTargetMap.setLabelProvider((IBaseLabelProvider)new TargetMapLabelProvider((AdapterFactory)Utilities.getItemAdapterFactory()));
        this.mTargetMap.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof DeployPackage;
            }
        });
        this.mTargetMap.setColumnProperties(COLUMN_PROPERTIES);
        this.mTargetMap.setCellModifier((ICellModifier)new TargetMapCellModifier());
        this.mTargetMap.setCellEditors(this.createCellEditors((Composite)table));
        this.mTargetMap.addDropSupport(20, new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()}, (DropTargetListener)new TargetMapDropListener((Viewer)this.mTargetMap));
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(table, 16384);
        column.setText(DeployCorePlugin.getDefault().getResourceString("TargetMapTableViewer.column.heading.package"));
        column.pack();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(80, true));
        column = new TableColumn(table, 16384);
        column.setText(DeployCorePlugin.getDefault().getResourceString("TargetMapTableViewer.column.heading.target"));
        column.pack();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        table.setLayout((Layout)layout);
    }

    private CellEditor[] createCellEditors(Composite parent) {
        Vector editors = new Vector(COLUMN_PROPERTIES.length);
        Object editor = null;
        editors.add(editor);
        editors.add(editor);
        return editors.toArray(new CellEditor[editors.size()]);
    }

    private static class TargetMapLabelProvider
    extends AdapterFactoryLabelProvider {
        private ILabelProvider mWorkbenchLabelProvider = new WorkbenchLabelProvider();
        static /* synthetic */ Class class$0;

        public TargetMapLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            if (element instanceof DeployPackage) {
                DeployPackage pkg = (DeployPackage)element;
                String property = COLUMN_PROPERTIES[columnIndex];
                if (property.equals(TargetMapTableViewer.PROP_PACKAGE)) {
                    image = this.getImage(pkg);
                } else if (property.equals(TargetMapTableViewer.PROP_TARGET) && pkg.getTargetConfiguration().size() > 0) {
                    DeployConfiguration config = (DeployConfiguration)pkg.getTargetConfiguration().get(0);
                    image = this.getImage(config);
                }
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = new String();
            if (element instanceof DeployPackage) {
                String property = COLUMN_PROPERTIES[columnIndex];
                if (property.equals(TargetMapTableViewer.PROP_PACKAGE)) {
                    text = this.getText(element);
                } else if (property.equals(TargetMapTableViewer.PROP_TARGET)) {
                    DeployPackage pkg = (DeployPackage)element;
                    text = pkg.getTargetConfiguration() == null || pkg.getTargetConfiguration().isEmpty() ? new String() : this.getText((DeployConfiguration)pkg.getTargetConfiguration().get(0));
                }
            }
            return text;
        }

        public Image getImage(Object element) {
            Image image = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IItemLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterFactory.adapt(element, (Object)clazz);
            if (element instanceof DeployPackage) {
                IPackage ip = Utilities.adaptToIPackage((EObject)((DeployPackage)element));
                image = ip == null ? super.getImage(element) : this.mWorkbenchLabelProvider.getImage((Object)ip.getFile());
            } else if (element instanceof DeployConfiguration) {
                DeployConfiguration config = (DeployConfiguration)element;
                IConnectionProfile cp = Utilities.adaptToIConnectionProfile((EObject)config);
                image = cp == null ? super.getImage((Object)config.getTargetServer()) : ProfileImageRegistry.getInstance().getProfileImage(cp.getProvider());
            }
            return image;
        }

        public String getText(Object element) {
            DeployConfiguration config;
            IConnectionProfile cp;
            IPackage ip;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IItemLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterFactory.adapt(element, (Object)clazz);
            String text = element instanceof DeployPackage ? ((ip = Utilities.adaptToIPackage((EObject)((DeployPackage)element))) == null ? super.getText(element) : ip.getFile().getFullPath().toString()) : (element instanceof DeployConfiguration ? ((cp = Utilities.adaptToIConnectionProfile((EObject)(config = (DeployConfiguration)element))) == null ? (config.getTargetServer() == null || config.getTargetServer().getProfileName() == null ? TargetMapTreeViewer.LABEL_UNSPECIFIED_TARGET : config.getTargetServer().getProfileName()) : cp.getName()) : super.getText(element));
            return text;
        }

        public void dispose() {
            this.mWorkbenchLabelProvider.dispose();
            super.dispose();
        }
    }

    private class TargetMapCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            boolean retVal = false;
            if (element instanceof DeployPackage) {
                if (property.equals(TargetMapTableViewer.PROP_PACKAGE)) {
                    retVal = false;
                } else {
                    property.equals(TargetMapTableViewer.PROP_TARGET);
                }
            }
            return retVal;
        }

        public Object getValue(Object element, String property) {
            Object retVal = null;
            if (element instanceof DeployPackage) {
                EList list;
                if (property.equals(TargetMapTableViewer.PROP_PACKAGE)) {
                    retVal = element;
                } else if (property.equals(TargetMapTableViewer.PROP_TARGET) && !(list = ((DeployPackage)element).getTargetConfiguration()).isEmpty()) {
                    retVal = list.get(0);
                }
            }
            return retVal;
        }

        public void modify(Object element, String property, Object value) {
            Object data = null;
            data = element instanceof Item ? ((Item)element).getData() : element;
            if (data instanceof DeployPackage) {
                if (!property.equals(TargetMapTableViewer.PROP_PACKAGE) && property.equals(TargetMapTableViewer.PROP_TARGET)) {
                    ((DeployPackage)data).getTargetConfiguration();
                }
                TargetMapTableViewer.this.mTargetMap.refresh(data);
            }
        }
    }

    private class TargetMapDropListener
    extends ViewerDropAdapter {
        public TargetMapDropListener(Viewer viewer) {
            super(viewer);
        }

        public void dragOver(DropTargetEvent event) {
            if ((event.operations & 4) == 4) {
                event.detail = 4;
            }
            super.dragOver(event);
        }

        public void drop(DropTargetEvent event) {
            super.drop(event);
            event.detail = 4;
        }

        public boolean performDrop(Object data) {
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (transferType != null && (LocalSelectionTransfer.getInstance().isSupportedType(transferType) || ResourceTransfer.getInstance().isSupportedType(transferType))) {
                return this.validateSource();
            }
            return false;
        }

        private boolean validateSource() {
            return true;
        }
    }

    public class ServerSelectionCellEditor
    extends DialogCellEditor {
        public ServerSelectionCellEditor() {
        }

        public ServerSelectionCellEditor(Composite parent) {
            super(parent);
        }

        public ServerSelectionCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            DeployConfiguration value = (DeployConfiguration)this.getValue();
            ServerSelectionDialogPage page = new ServerSelectionDialogPage();
            page.init(value.getSourcePackage(), value.getTargetServer());
            Dialog dialog = new Dialog(cellEditorWindow.getShell(), (IDialogPage)page);
            if (dialog.open() == 0) {
                DeployServer server = page.getSelectedDeployServer();
                value.setTargetServer(server);
                if (server.getRoot() == null) {
                    server.setRoot(value.getSourcePackage().getRoot());
                }
            }
            return value;
        }

        protected void updateContents(Object value) {
            DeployServer ds;
            Label defaultLabel = this.getDefaultLabel();
            if (defaultLabel == null) {
                return;
            }
            String text = null;
            if (value != null && (ds = ((DeployConfiguration)value).getTargetServer()) != null) {
                text = ds.getProfileName();
            }
            if (text == null) {
                text = new String();
            }
            defaultLabel.setText(text);
        }
    }
}

