/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFileFactory;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.ConnectionProfileTreeViewer;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DialogPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ServerSelectionDialogPage
extends DialogPage {
    public static final String TITLE = DeployCorePlugin.getDefault().getResourceString("ServerSelectionDialogPage.title.selectTargetServer");
    public static final String ICON_PATH = "icons/blank_wizard_graphic.gif";
    public static final ImageDescriptor ICON_DESC;
    public static final String LABEL_ADD_SERVER;
    public static final int MIN_LIST_HEIGHT;
    public static final int INDENT;
    private ConnectionProfileTreeViewer mCPViewer;
    private IPackage mPackage;
    private DeployPackage mDeployPackage;
    private Root mRoot;
    private DeployServer mSelectedServer;

    static {
        URL url = null;
        try {
            url = DeployCorePlugin.getDefault().getBundle().getEntry(ICON_PATH);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        ICON_DESC = url == null ? ImageDescriptor.getMissingImageDescriptor() : ImageDescriptor.createFromURL((URL)url);
        LABEL_ADD_SERVER = DeployCorePlugin.getDefault().getResourceString("ServerSelectionDialogPage.LABEL.addServer");
        MIN_LIST_HEIGHT = 15;
        INDENT = 25;
    }

    public ServerSelectionDialogPage() {
        this(TITLE, ICON_DESC);
    }

    public ServerSelectionDialogPage(String title, ImageDescriptor image) {
        super(title, image);
        this.setNeedsApplyButton(false);
    }

    public void init(DeployPackage pkg, DeployServer server) {
        this.mDeployPackage = pkg;
        this.mRoot = this.mDeployPackage.getRoot();
        this.mSelectedServer = server;
        this.mPackage = Utilities.adaptToIPackage((EObject)this.mDeployPackage);
    }

    public void init(DeployPackage deployPackage, IPackage iPackage, DeployServer server) {
        this.mDeployPackage = deployPackage;
        this.mRoot = this.mDeployPackage.getRoot();
        this.mSelectedServer = server;
        this.mPackage = iPackage;
    }

    public DeployServer getSelectedDeployServer() {
        return this.mSelectedServer;
    }

    public boolean performOk() {
        String selectedProfileName = ((IConnectionProfile)((IStructuredSelection)this.mCPViewer.getViewer().getSelection()).getFirstElement()).getName();
        this.mSelectedServer = null;
        Iterator it = this.mRoot.getServer().iterator();
        while (this.mSelectedServer == null && it.hasNext()) {
            DeployServer server = (DeployServer)it.next();
            if (!selectedProfileName.equals(server.getProfileName())) continue;
            this.mSelectedServer = server;
        }
        if (this.mSelectedServer == null) {
            this.mSelectedServer = DeployFileFactory.eINSTANCE.createDeployServer(selectedProfileName);
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree(content, 772);
        this.mCPViewer = new ConnectionProfileTreeViewer(tree);
        this.mCPViewer.getViewer().setAutoExpandLevel(3);
        GridData data = new GridData(1808);
        data.heightHint = tree.getItemHeight() * MIN_LIST_HEIGHT;
        tree.setLayoutData((Object)data);
        this.mCPViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServerSelectionDialogPage.this.handleCPSelectionChanged();
            }
        });
        this.mCPViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ServerSelectionDialogPage.this.handleCPDoubleClick();
            }
        });
        this.mCPViewer.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean retVal;
                if (element instanceof IConnectionProfile) {
                    retVal = true;
                    String profileName = ((IConnectionProfile)element).getName();
                    if (ServerSelectionDialogPage.this.mSelectedServer == null || !ServerSelectionDialogPage.this.mSelectedServer.getProfileName().equals(profileName)) {
                        Iterator it = ServerSelectionDialogPage.this.mDeployPackage.getTargetConfiguration().iterator();
                        while (retVal && it.hasNext()) {
                            DeployServer server = ((DeployConfiguration)it.next()).getTargetServer();
                            boolean bl = retVal = server == null || !server.getProfileName().equals(profileName);
                        }
                    }
                } else {
                    retVal = element instanceof ICategory;
                }
                return retVal;
            }
        });
        if (this.mPackage != null) {
            if (this.mPackage instanceof IPhysicalPackage) {
                IFile packageFile = this.mPackage.getFile();
                List packageExtensions = DeploymentExtensionManager.getInstance().getPhysicalPackageExtensions(this.mPackage.getFile().getFileExtension());
                final ArrayList<IPackage> packages = new ArrayList<IPackage>(packageExtensions.size());
                Iterator it = packageExtensions.iterator();
                while (it.hasNext()) {
                    IPhysicalPackageExtension ippe = (IPhysicalPackageExtension)it.next();
                    if (!ippe.supportsFile(packageFile)) continue;
                    packages.add(ippe.adaptFile(packageFile));
                }
                this.mCPViewer.getViewer().addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        boolean retVal;
                        if (element instanceof IConnectionProfile) {
                            String profileProviderID = ((IConnectionProfile)element).getProviderId();
                            retVal = false;
                            Iterator it = packages.iterator();
                            while (!retVal && it.hasNext()) {
                                boolean bl = retVal = DeploymentExtensionManager.getInstance().getDeployDriver((IPhysicalPackage)it.next(), profileProviderID) != null;
                            }
                        } else {
                            retVal = true;
                        }
                        return retVal;
                    }
                });
            } else {
                this.mCPViewer.getViewer().addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        boolean retVal = element instanceof IConnectionProfile ? DeploymentExtensionManager.getInstance().getDeployDriver(ServerSelectionDialogPage.this.mPackage, ((IConnectionProfile)element).getProviderId()) != null : true;
                        return retVal;
                    }
                });
            }
        }
        this.initControls();
        this.setControl((Control)content);
    }

    private void initControls() {
        IConnectionProfile profile;
        this.mCPViewer.getViewer().setInput((Object)ProfileManager.getInstance());
        if (this.mSelectedServer != null && (profile = ProfileManager.getInstance().getProfileByName(this.mSelectedServer.getProfileName())) != null) {
            this.mCPViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)profile));
        }
        this.updateControls();
        this.validate();
        this.setErrorMessage(null);
    }

    private void updateControls() {
    }

    private void validate() {
        this.validateExistingServer();
    }

    private void validateExistingServer() {
        if (this.mCPViewer.getViewer().getSelection().isEmpty() || !(((IStructuredSelection)this.mCPViewer.getViewer().getSelection()).getFirstElement() instanceof IConnectionProfile)) {
            this.setErrorMessage(DeployCorePlugin.getDefault().getResourceString("ServerSelectionDialogPage.error.selectTargetServer"));
            this.setIsValid(false);
        } else {
            this.setErrorMessage(null);
            this.setIsValid(true);
        }
    }

    private void handleCPDoubleClick() {
        this.updateControls();
        this.validate();
        if (this.isValid()) {
            this.getContainer().closeOK();
        }
    }

    private void handleCPSelectionChanged() {
        this.validateExistingServer();
    }
}

